/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.zip;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipFile;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipItem;

public class ZipModelToWorkspaceCreator {
    protected Logger logger = Logger.getLogger(ZipModelToWorkspaceCreator.class);

    public void create(WorkspaceFolder root, List<ZipItem> items) {
        for (ZipItem item : items) {
            try {
                this.createWorkspaceItem(root, item);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error creating item " + item), (Throwable)e);
            }
        }
    }

    protected void createWorkspaceItem(WorkspaceFolder parentFolder, ZipItem item) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, FileNotFoundException {
        switch (item.getType()) {
            case FOLDER: {
                this.createWorkspace(parentFolder, (ZipFolder)item);
                break;
            }
            case FILE: {
                this.createItem(parentFolder, (ZipFile)item);
            }
        }
    }

    protected void createWorkspace(WorkspaceFolder parentFolder, ZipFolder zipFolder) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String name = WorkspaceUtil.getUniqueName(zipFolder.getName(), parentFolder);
        String description = zipFolder.getComment() != null ? zipFolder.getComment() : "";
        WorkspaceFolder folder = parentFolder.createFolder(name, description);
        for (ZipItem workspaceFolder : zipFolder.getChildren()) {
            try {
                this.createWorkspaceItem(folder, workspaceFolder);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error creating item " + workspaceFolder), (Throwable)e);
            }
        }
    }

    protected void createItem(WorkspaceFolder folder, ZipFile zipFile) throws FileNotFoundException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        this.logger.trace((Object)("Creating item " + zipFile));
        String zipItemName = zipFile.getName();
        String name = WorkspaceUtil.getUniqueName(zipItemName, folder);
        String description = zipFile.getComment() != null ? zipFile.getComment() : "";
        FileInputStream is = new FileInputStream(zipFile.getContentFile());
        String mimeType = MimeTypeUtil.getMimeType(zipFile.getContentFile());
        ExternalFile item = folder.createExternalFileItem(name, description, mimeType, is);
        this.logger.trace((Object)("Item created " + item));
        zipFile.getContentFile().delete();
        this.logger.trace((Object)"Tmp file deleted");
    }
}

