/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.consistency;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.consistency.CheckException;
import org.gcube.portlets.user.homelibrary.consistency.CheckerUtil;
import org.gcube.portlets.user.homelibrary.consistency.statistics.WorkspaceCheckStatistics;
import org.gcube.portlets.user.homelibrary.examples.ExamplesUtil;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.File;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Image;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.PDF;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Url;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.DocumentMetadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentAlternativeLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentPartLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;

public class WorkspaceConsistencyChecker {
    protected Logger logger;
    protected Workspace workspace;
    protected boolean testEntireStream;
    protected WorkspaceCheckStatistics statistics;
    protected boolean acceptAllSentRequests = false;

    public WorkspaceConsistencyChecker(Logger logger, Workspace workspace, boolean testEntireStream, boolean acceptAllSentRequests) {
        this.logger = logger;
        this.workspace = workspace;
        this.testEntireStream = testEntireStream;
        this.acceptAllSentRequests = acceptAllSentRequests;
        this.statistics = new WorkspaceCheckStatistics();
    }

    public WorkspaceCheckStatistics getStatistics() {
        return this.statistics;
    }

    public boolean checkWorkspace() {
        this.logger.debug((Object)"start checking the Workspace");
        if (this.acceptAllSentRequests) {
            try {
                this.logger.trace((Object)"Accepting all received items");
                WorkspaceMessageManager manager = this.workspace.getWorkspaceMessageManager();
            }
            catch (Exception e) {
                this.logger.debug((Object)("Accepting all received items FAILED: " + e.getMessage()));
                this.logger.trace((Object)("Accepting all received items FAILED: " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        WorkspaceFolder root = null;
        try {
            root = this.workspace.getRoot();
            this.logger.trace((Object)("Checking root " + root));
            CheckerUtil.checkNotNull("ROOT", root);
            CheckerUtil.checkNotNull("Id", root.getId());
            CheckerUtil.checkNotNull("Name", root.getName());
            CheckerUtil.checkNotNull("Description", root.getDescription());
            CheckerUtil.checkNotNull("Owner", root.getOwner());
            CheckerUtil.checkNotNull("Type", root.getType());
            this.statistics.increaseFolders();
        }
        catch (Exception e) {
            this.logger.debug((Object)("Root check FAILED: " + e.getMessage()));
            this.logger.trace((Object)("Root check FAILED: " + e.getMessage()), (Throwable)e);
            this.statistics.increaseErrors();
            return false;
        }
        try {
            this.logger.trace((Object)"Checking root children");
            List itemChildren = root.getChildren();
            CheckerUtil.checkNotNull("Children", itemChildren);
            for (WorkspaceItem itemChild : itemChildren) {
                CheckerUtil.checkNotNull("itemChild", itemChild);
                this.checkWorkspaceItem(itemChild);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)("Root children check FAILED: " + e.getMessage()));
            this.logger.trace((Object)("Root children check FAILED: " + e.getMessage()), (Throwable)e);
            this.statistics.increaseErrors();
            return false;
        }
        this.logger.debug((Object)"Workspace OK");
        return true;
    }

    protected void checkWorkspaceItem(WorkspaceItem item) throws CheckException {
        this.logger.trace((Object)("checking item: " + item));
        try {
            CheckerUtil.checkNotNull("Id", item.getId());
            CheckerUtil.checkNotNull("Name", item.getName());
            CheckerUtil.checkNotNull("Description", item.getDescription());
            CheckerUtil.checkNotNull("Owner", item.getOwner());
            CheckerUtil.checkNotNull("Type", item.getType());
            CheckerUtil.checkNotNull("Parent", item.getParent());
            switch (item.getType()) {
                case FOLDER_ITEM: {
                    FolderItem folderItem = (FolderItem)item;
                    this.checkFolderItem(folderItem);
                    this.statistics.increaseFolderItems(folderItem.getFolderItemType());
                    break;
                }
                case FOLDER: {
                    this.statistics.increaseFolders();
                }
            }
            List itemChildren = item.getChildren();
            CheckerUtil.checkNotNull("Children", itemChildren.size());
            for (WorkspaceItem itemChild : itemChildren) {
                CheckerUtil.checkNotNull("itemChild", itemChild);
                this.checkWorkspaceItem(itemChild);
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking workspace item: " + item), (Throwable)e);
            this.statistics.increaseErrors();
        }
    }

    protected void checkFolderItem(FolderItem item) throws CheckException {
        this.logger.trace((Object)("checking FolderItem: " + item));
        try {
            CheckerUtil.checkNotNull("FolderItemType", item.getFolderItemType());
            CheckerUtil.checkNotNull("Length", item.getLength());
            switch (item.getFolderItemType()) {
                case EXTERNAL_FILE: {
                    this.checkFile((File)((ExternalFile)item));
                    break;
                }
                case EXTERNAL_IMAGE: {
                    this.checkImage((Image)((ExternalImage)item));
                    break;
                }
                case EXTERNAL_PDF_FILE: {
                    this.checkFile((File)((ExternalPDFFile)item));
                    this.checkPDF((PDF)((ExternalPDFFile)item));
                    break;
                }
                case EXTERNAL_URL: {
                    this.checkUrl((Url)((ExternalUrl)item));
                    break;
                }
                case TIME_SERIES: {
                    this.checkTimeSeries((TimeSeries)item);
                    break;
                }
                case QUERY: {
                    this.checkQuery((Query)item);
                    break;
                }
                case REPORT: {
                    this.checkReport((Report)item);
                    break;
                }
                case REPORT_TEMPLATE: {
                    this.checkReportTemplate((ReportTemplate)item);
                    break;
                }
                case AQUAMAPS_ITEM: {
                    this.checkAquaMapsItem((AquaMapsItem)item);
                    break;
                }
                case DOCUMENT: {
                    this.checkDocument((Document)item);
                    break;
                }
                case IMAGE_DOCUMENT: {
                    this.checkDocument((Document)((ImageDocument)item));
                    this.checkImage((Image)((ImageDocument)item));
                    break;
                }
                case PDF_DOCUMENT: {
                    this.checkDocument((Document)((PDFDocument)item));
                    this.checkPDF((PDF)((PDFDocument)item));
                    break;
                }
                case URL_DOCUMENT: {
                    this.checkDocument((Document)((UrlDocument)item));
                    this.checkUrl((Url)((UrlDocument)item));
                    break;
                }
                case METADATA: {
                    this.checkMetadata((Metadata)item);
                }
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking folder item " + item), (Throwable)e);
            throw new CheckException("Error checking folder item " + item, e);
        }
    }

    protected void checkFile(File item) throws CheckException {
        try {
            CheckerUtil.checkNotNull("Name", item.getName());
            CheckerUtil.checkNotNull("Length", item.getLength());
            CheckerUtil.checkNotNull("Data", item.getData());
            if (this.testEntireStream) {
                CheckerUtil.checkStream("Data", item.getData());
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking file " + item), (Throwable)e);
            throw new CheckException("Error checking file " + item, e);
        }
    }

    protected void checkImage(Image item) throws CheckException {
        try {
            this.checkFile((File)item);
            CheckerUtil.checkNotNull("Width", item.getWidth());
            CheckerUtil.checkNotNull("Height", item.getHeight());
            CheckerUtil.checkNotNull("ThumbnailWidth", item.getThumbnailWidth());
            CheckerUtil.checkNotNull("ThumbnailHeight", item.getThumbnailHeight());
            CheckerUtil.checkNotNull("ThumbnailLength", item.getThumbnailLength());
            CheckerUtil.checkNotNull("Thumbnail", item.getThumbnail());
            if (this.testEntireStream) {
                CheckerUtil.checkStream("Thumbnail", item.getThumbnail());
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking image " + item), (Throwable)e);
            throw new CheckException("Error checking image " + item, e);
        }
    }

    protected void checkPDF(PDF item) throws CheckException {
        CheckerUtil.checkNotNull("Title", item.getTitle());
        CheckerUtil.checkNotNull("Author", item.getAuthor());
        CheckerUtil.checkNotNull("Producer", item.getProducer());
        CheckerUtil.checkNotNull("Version", item.getVersion());
        CheckerUtil.checkNotNull("NumberOfPages", item.getNumberOfPages());
    }

    protected void checkUrl(Url item) throws CheckException {
        try {
            CheckerUtil.checkNotNull("Url", item.getUrl());
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking url " + item), (Throwable)e);
            throw new CheckException("Error checking url " + item, e);
        }
    }

    protected void checkDocument(Document item) throws CheckException {
        try {
            CheckerUtil.checkNotNull("OID", item.getURI());
            CheckerUtil.checkNotNull("CollectionName", item.getCollectionName());
            CheckerUtil.checkNotNull("Metadata", item.getMetadata());
            for (Map.Entry entry : item.getMetadata().entrySet()) {
                CheckerUtil.checkNotNull("(Metadata) SchemaName", ((DocumentMetadata)entry.getValue()).getSchemaName());
                CheckerUtil.checkNotNull("(Metadata) XML", ((DocumentMetadata)entry.getValue()).getXML());
            }
            CheckerUtil.checkNotNull("Alternatives", item.getAlternatives());
            for (DocumentAlternativeLink itemAlternative : item.getAlternatives()) {
                CheckerUtil.checkNotNull("(Alternative) ParentOID", itemAlternative.getParentURI());
                CheckerUtil.checkNotNull("(Alternative) OID", itemAlternative.getURI());
                CheckerUtil.checkNotNull("(Alternative) Name", itemAlternative.getName());
            }
            CheckerUtil.checkNotNull("Annotation", item.getAnnotation());
            for (Map.Entry entry : item.getAnnotation().entrySet()) {
                CheckerUtil.checkNotNull("(Annotation) Value", entry.getValue());
            }
            CheckerUtil.checkNotNull("Parts", item.getParts());
            for (DocumentPartLink itemPart : item.getParts()) {
                CheckerUtil.checkNotNull("(Part) ParentOID", itemPart.getParentURI());
                CheckerUtil.checkNotNull("(Part) OID", itemPart.getURI());
                CheckerUtil.checkNotNull("(Part) Name", itemPart.getName());
            }
            CheckerUtil.checkNotNull("Data", item.getData());
            if (this.testEntireStream) {
                CheckerUtil.checkStream("Data", item.getData());
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking document " + item), (Throwable)e);
            throw new CheckException("Error checking document " + item, e);
        }
    }

    protected void checkMetadata(Metadata item) throws CheckException {
        try {
            CheckerUtil.checkNotNull("OID", item.getURI());
            CheckerUtil.checkNotNull("Schema", item.getSchema());
            CheckerUtil.checkNotNull("Language", item.getLanguage());
            CheckerUtil.checkNotNull("CollectionName", item.getCollectionName());
            CheckerUtil.checkNotNull("Data", item.getData());
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking metadata " + item), (Throwable)e);
            throw new CheckException("Error checking metadata " + item, e);
        }
    }

    protected void checkTimeSeries(TimeSeries item) throws CheckException {
        try {
            CheckerUtil.checkNotNull("TimeSeriesInfo", item.getTimeSeriesInfo());
            CheckerUtil.checkNotNull("NumberOfColumns", item.getNumberOfColumns());
            CheckerUtil.checkNotNull("HeaderLabels", item.getHeaderLabels());
            CheckerUtil.checkNotNull("Data", item.getData());
            if (this.testEntireStream) {
                CheckerUtil.checkStream("Data", item.getData());
            }
            CheckerUtil.checkNotNull("CompressedData", item.getCompressedData());
            if (this.testEntireStream) {
                CheckerUtil.checkStream("CompressedData", item.getCompressedData());
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking timeseries " + item), (Throwable)e);
            throw new CheckException("Error checking timeseries " + item, e);
        }
    }

    protected void checkQuery(Query item) throws CheckException {
        CheckerUtil.checkNotNull("Query", item.getQuery());
    }

    protected void checkReport(Report item) throws CheckException {
        try {
            CheckerUtil.checkNotNull("Data", item.getData());
            if (this.testEntireStream) {
                CheckerUtil.checkStream("Data", item.getData());
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking report " + item), (Throwable)e);
            throw new CheckException("Error checking report " + item, e);
        }
    }

    protected void checkReportTemplate(ReportTemplate item) throws CheckException {
        try {
            CheckerUtil.checkNotNull("Data", item.getData());
            if (this.testEntireStream) {
                CheckerUtil.checkStream("Data", item.getData());
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking report template " + item), (Throwable)e);
            throw new CheckException("Error checking report template " + item, e);
        }
    }

    protected void checkAquaMapsItem(AquaMapsItem item) throws CheckException {
        try {
            this.checkFile(item.getMetadata());
            CheckerUtil.checkNotNull("Images", item.getImages());
            for (Image image : item.getImages()) {
                this.checkImage(image);
            }
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)("Error checking aquamaps item " + item), (Throwable)e);
            throw new CheckException("Error checking aquamaps " + item, e);
        }
    }

    public static void main(String[] args) throws GCUBEScope.MalformedScopeExpressionException, InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        Workspace wa = ExamplesUtil.createWorkspace();
        TestDataFactory.getInstance().fillAllFolderItem(wa.getRoot());
        System.out.println("WA ready");
        Logger logger = Logger.getLogger((String)"test");
        logger.setLevel(Level.ALL);
        WorkspaceConsistencyChecker checker = new WorkspaceConsistencyChecker(logger, wa, true, false);
        boolean check = checker.checkWorkspace();
        System.out.println("is ok? " + check);
    }
}

