/**
 * 
 */
package org.gcube.portlets.user.homelibrary.home;

import org.gcube.common.core.scope.GCUBEScope;

/**
 * Represent an user. 
 * An user is identified by an id.
 * One user can be present in only one scope at time.
 * @author Federico De Faveri defaveri@isti.cnr.it
 */
public interface User {
	
	/**
	 * Retrieves the user's id.
	 * @return the id.
	 */
	String getId();
	
	/**
	 * Retrieves the user's portal login.
	 * @return the portal login.
	 */
	String getPortalLogin();
	
	/**
	 * Retrieves the user's scope.
	 * @return the scope.
	 */
	GCUBEScope getScope();
}
