/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util;

import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.util.IndentedVisitor;
import org.gcube.portlets.user.homelibrary.util.WorkspaceTreeVisitor;

public class HomeLibraryVisitor
extends IndentedVisitor {
    protected boolean visitHomes = false;

    public HomeLibraryVisitor() {
    }

    public HomeLibraryVisitor(boolean visitHomes) {
        this.visitHomes = visitHomes;
    }

    public void visitHomeLibrary(HomeManagerFactory factory) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        this.reset();
        List<String> scopes = factory.listScopes();
        for (String scope : scopes) {
            this.println(scope);
            HomeManager homeManager = factory.getHomeManager();
            this.visitHomeManager(homeManager);
        }
    }

    protected void visitHomeManager(HomeManager homeManager) throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        this.indent();
        List<User> users = homeManager.getUsers();
        for (User user : users) {
            this.println(user.getPortalLogin());
            if (!this.visitHomes) continue;
            Home home = homeManager.getHome(user, GCUBEScope.getScope((String)"/test/scope/"));
            this.visitUser(home);
        }
        this.outdent();
    }

    protected void visitUser(Home home) throws InternalErrorException, WorkspaceFolderNotFoundException {
        this.indent();
        WorkspaceTreeVisitor wtv = new WorkspaceTreeVisitor(this.indentationLevel, this.indentationChar, this.os, this.logger);
        wtv.visitItem(home.getWorkspace().getRoot());
        this.outdent();
    }

    public void visitUser(Home home, GCUBEScope scope) throws InternalErrorException, WorkspaceFolderNotFoundException {
        this.indent();
        WorkspaceTreeVisitor wtv = new WorkspaceTreeVisitor(this.indentationLevel, this.indentationChar, this.os, this.logger);
        wtv.visitItem(home.getWorkspace().getRoot(scope));
        this.outdent();
    }
}

