/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.util.LinkedList;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.homelibrary.testdata.AbstractDataManager;
import org.gcube.portlets.user.homelibrary.testdata.data.QueryData;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class QueryDataManager
extends AbstractDataManager<QueryData, Query> {
    public QueryDataManager() {
        super("queries.xml");
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("query", QueryData.class);
        this.xstream.alias("queries", LinkedList.class);
    }

    @Override
    protected Query fillData(WorkspaceFolder destinationFolder, QueryData testData) throws InternalErrorException {
        try {
            String name = WorkspaceUtil.getUniqueName((String)testData.getName(), (WorkspaceFolder)destinationFolder);
            QueryType queryType = QueryType.valueOf((String)testData.getType());
            return destinationFolder.createQueryItem(name, testData.getDescription(), testData.getValue(), queryType);
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error((Object)"Error creating the query", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error((Object)"Error creating the query", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }
}

