/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.LinkedList;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.testdata.AbstractDataManager;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.testdata.data.TemplateData;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class TemplateDataManager
extends AbstractDataManager<TemplateData, ReportTemplate> {
    public TemplateDataManager() {
        super("templates.xml");
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("template", TemplateData.class);
        this.xstream.alias("templates", LinkedList.class);
    }

    protected static InputStream getTestDataStream(TemplateData testData) {
        String testDataPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + testData.getFile();
        return TestDataFactory.class.getResourceAsStream(testDataPath);
    }

    @Override
    protected ReportTemplate fillData(WorkspaceFolder destinationFolder, TemplateData testData) throws InternalErrorException {
        InputStream reportTemplateData = TemplateDataManager.getTestDataStream(testData);
        try {
            String name = WorkspaceUtil.getUniqueName((String)testData.getName(), (WorkspaceFolder)destinationFolder);
            return destinationFolder.createReportTemplateItem(name, testData.getDescription(), testData.getCreated(), testData.getLastEdit(), testData.getAuthor(), testData.getLastEditBy(), testData.getNumberOfSections(), testData.getStatus(), reportTemplateData);
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error((Object)"Error creating the report template", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error((Object)"Error creating the report template", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }
}

