/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.util.LinkedList;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.portlets.user.homelibrary.testdata.AbstractDataManager;
import org.gcube.portlets.user.homelibrary.testdata.data.WorkflowReportData;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class WorkflowReportDataManager
extends AbstractDataManager<WorkflowReportData, WorkflowReport> {
    public WorkflowReportDataManager() {
        super("workflowreports.xml");
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("workflowreport", WorkflowReportData.class);
        this.xstream.alias("workflowreports", LinkedList.class);
    }

    @Override
    protected WorkflowReport fillData(WorkspaceFolder destinationFolder, WorkflowReportData testData) throws InternalErrorException {
        try {
            String name = WorkspaceUtil.getUniqueName((String)testData.getName(), (WorkspaceFolder)destinationFolder);
            return destinationFolder.createWorkflowReport(name, testData.getDescription(), testData.getWorkflowId(), testData.getWorkflowStatus(), testData.getWorkflowData());
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error((Object)"Error creating the workflow report", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error((Object)"Error creating the workflow report", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }
}

