package org.gcube.portlets.user.joinvre.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.gcube.common.portal.PortalContext;
import org.gcube.common.portal.mailing.EmailNotification;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Massimiliano Assante ISTI-CNR
 * 
 */
public class LoginServiceUtil {
	/**
	 * 
	 */
	public static final String ROOT_ORG = "rootorganization";
	/**
	 * 
	 */
	public static final String PUBLIC_LAYOUT_NAME = "Data e-Infrastructure gateway";
	/**
	 * 
	 */
	public static final String GUEST_COMMUNITY_NAME = "Guest";

	private static Logger _log = LoggerFactory.getLogger(LoginServiceUtil.class);	
	
	protected static ArrayList<String> getAdministratorsEmails(String scope) {
		LiferayUserManager userManager = new LiferayUserManager();
		LiferayGroupManager groupManager = new LiferayGroupManager();
		long groupId = -1;
		try {
			List<GCubeGroup> allGroups = groupManager.listGroups();
			_log.debug("Number of groups retrieved: " + allGroups.size());
			for (int i = 0; i < allGroups.size(); i++) {
				long grId = allGroups.get(i).getGroupId();
				String groupScope = groupManager.getInfrastructureScope(grId);
				System.out.println("Comparing: " + groupScope + " " + scope);
				if (groupScope.equals(scope)) {
					groupId = allGroups.get(i).getGroupId();
					break;
				}
			}
		} catch (UserManagementSystemException e) {
			e.printStackTrace();
		} catch (GroupRetrievalFault e) {
			e.printStackTrace();
		}
		Map<GCubeUser, List<GCubeRole>> usersAndRoles = null;
		try {
			usersAndRoles = userManager.listUsersAndRolesByGroup(groupId);
		} catch (Exception e) {
			e.printStackTrace();
		} 
		Set<GCubeUser> users = usersAndRoles.keySet();
		ArrayList<String> adminEmailsList = new ArrayList<String>();
		for (GCubeUser usr:users) {
			List<GCubeRole> roles = usersAndRoles.get(usr);
			for (int i = 0; i < roles.size(); i++) {
				if (roles.get(i).getRoleName().equals("VO-Admin") || roles.get(i).getRoleName().equals("VRE-Manager")) {
					adminEmailsList.add(usr.getEmail());
					_log.debug("Admin: " + usr.getFullname());
					break;
				}
			}
		}
		return adminEmailsList;
	}

	/**
	 * 
	 * @param scope .
	 * @param optionalMessage .
	 */
	public static void addMembershipRequest(String username, String scope, String optionalMessage, HttpServletRequest request) throws Exception{
		
		String gatewayName = PortalContext.getConfiguration().getGatewayName(request);
		String portalbasicurl = PortalContext.getConfiguration().getGatewayURL(request);
		_log.info("gatewayName = " + gatewayName + " Message=" + optionalMessage);

		
		ArrayList<String> adminEmails = LoginServiceUtil.getAdministratorsEmails(scope);

		UserManager um = new LiferayUserManager();
		GCubeUser currUser = um.getUserByUsername(username);
		String name = currUser.getFirstName();
		String lastname = currUser.getLastName();

		String selectedVRE = scope.substring(scope.lastIndexOf("/")+1, scope.length());		
		_log.info("Requested MEMBERSHIP for: " + selectedVRE + " scope: " +	scope);
		GroupManager gm = new LiferayGroupManager();
		um.requestMembership(currUser.getUserId(), gm.getGroupIdFromInfrastructureScope(scope), optionalMessage);

		StringBuffer body = new StringBuffer();
		body.append("<p>Dear manager of "+ scope +",<br />this email message was automatically generated by " + portalbasicurl +" to inform you that ");
		body.append("</p>");
		body.append("<p>");
		body.append("<b>"+name + " " + lastname +"</b> has requested access to the following environment: ");
		body.append("<br /><br />");
		body.append("<b>" + scope+"</b>");
		body.append("<br />");
		body.append("<br />");
		body.append("<b>Username: </b>" + username);
		body.append("<br />");
		body.append("<b>e-mail: </b>" + currUser.getEmail());
		body.append("</p>");
		body.append("<p>");
		body.append("The request is annotated with the following text: " + optionalMessage);
		body.append("</p>");
		body.append("<p>");
		body.append("You are kindly asked to manage such request by either approving or rejecting it through the user management " +
				"facilities available at ");
		body.append("<br />" + portalbasicurl);
		body.append("</p>");
		
		
		String[] allMails = new String[adminEmails.size()];

		adminEmails.toArray(allMails);

		EmailNotification mailToAdmin = new EmailNotification(allMails , "[" + gatewayName + "] - Join Request", body.toString(), request);

		mailToAdmin.sendEmail();
	}
	
	/**
	 * 
	 * @param scope .
	 * @param optionalMessage .
	 */
	public static void notifyUserSelfRegistration(String username, String scope, HttpServletRequest request) throws Exception {
			
		ArrayList<String> adminEmails = LoginServiceUtil.getAdministratorsEmails(scope);
		LiferayUserManager um = new LiferayUserManager();
		GCubeUser currUser = um.getUserByUsername(username);
		String name = currUser.getFirstName();
		String lastname = currUser.getLastName();
		String portalbasicurl = PortalContext.getConfiguration().getGatewayURL(request);
		String gatewayName = PortalContext.getConfiguration().getGatewayName(request);
		StringBuffer body = new StringBuffer();
		body.append("<p>Dear manager of "+ scope +",<br />this email message was automatically generated by " + portalbasicurl +" to inform you that ");
		body.append("</p>").append("<p>")
		.append("<b>"+name + " " + lastname +"</b> has self registered to the following environment: ")
		.append("<br /><br />")
		.append("<b>" + scope+"</b>")
		.append("<br />")
		.append("<br />")
		.append("<b>Username: </b>" + username)
		.append("<br />")
		.append("<b>e-mail: </b>" + currUser.getEmail())
		.append("</p>")
		.append("<p>")
		.append("<br />" + portalbasicurl)
		.append("</p>");
		
		String[] allMails = new String[adminEmails.size()];

		adminEmails.toArray(allMails);

		EmailNotification mailToAdmin = new EmailNotification(allMails , "[" + gatewayName + "] - Self Registration", body.toString(), request);

		mailToAdmin.sendEmail();
	}
	
	
	/**
	 * 
	 * @param scope .
	 * @param optionalMessage .
	 */
	public static void notifyUserAcceptedInvite(String username, String scope, Invite invite, HttpServletRequest request) throws Exception {
			
		String portalbasicurl = PortalContext.getConfiguration().getGatewayURL(request);
		String gatewayName = PortalContext.getConfiguration().getGatewayName(request);
		
		ArrayList<String> adminEmails = LoginServiceUtil.getAdministratorsEmails(scope);

		LiferayUserManager um = new LiferayUserManager();
		GCubeUser currUser = um.getUserByUsername(username);
		String name = currUser.getFirstName();
		String lastname = currUser.getLastName();
	

		StringBuffer body = new StringBuffer();
		body.append("<p>Dear manager of "+ scope +",<br />this email message was automatically generated by " + portalbasicurl +" to inform you that ");
		body.append("</p>")
		.append("<p>")
		.append("<b>"+name + " " + lastname +"</b> has accepted an invitation to the following environment: ")
		.append("<br /><br />")
		.append("<b>" + scope+"</b>")
		.append("<br />")
		.append("<br />")
		.append("<b>Username: </b>" + username)
		.append("<br />")
		.append("<b>e-mail: </b>" + currUser.getEmail())
		.append("</p>")
		.append("<p>")
		.append("<b>The invitation was sent by " + invite.getSenderFullName() +" (" + invite.getSenderUserId()+") on " + invite.getTime()+"</b>")
		.append("</p>");
	
		
		String[] allMails = new String[adminEmails.size()];

		adminEmails.toArray(allMails);

		EmailNotification mailToAdmin = new EmailNotification(allMails , "[" + gatewayName + "] - Accepted Invitation", body.toString(), request);

		mailToAdmin.sendEmail();
	}
	
}
