/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinnew.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portlets.user.joinnew.client.JoinNewService;
import org.gcube.portlets.user.joinnew.server.LoginServiceUtil;
import org.gcube.portlets.user.joinnew.shared.UserBelonging;
import org.gcube.portlets.user.joinnew.shared.VO;
import org.gcube.portlets.user.joinnew.shared.VRE;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JoinNewServiceImpl
extends RemoteServiceServlet
implements JoinNewService {
    public static final String CACHED_VOS = "CACHED_VOS";
    private static final String REQUEST_BASED_GROUP = "Requestbasedgroup";
    private static DatabookStore store;
    public String SELECTED_THEMEID = "";
    private VO rootVO = new VO();
    private static Logger _log;

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user");
            user = "test.user";
        } else {
            _log.info("LIFERAY PORTAL DETECTED user=" + user);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public boolean registerUser(String scope, long organizationid) {
        LiferayUserManager userM = new LiferayUserManager();
        try {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            userM.assignUserToGroup("" + organizationid, userM.getUserId(username));
            this.addUserToHLGroup(username, scope, session.getUsername());
            String gatewayName = "D4Science Gateway";
            if (this.getThreadLocalRequest().getSession().getAttribute("GATEWAY_NAME") != null) {
                gatewayName = this.getThreadLocalRequest().getSession().getAttribute("GATEWAY_NAME").toString();
                _log.debug("Gateway Label was Found=" + gatewayName);
            } else {
                _log.debug("Gateway Label Not Found");
            }
            JoinNewServiceImpl.initStore();
            String inviteId = store.isExistingInvite(scope, session.getUserEmailAddress());
            if (inviteId != null) {
                Invite invite = store.readInvite(inviteId);
                store.setInviteStatus(scope, session.getUserEmailAddress(), InviteStatus.ACCEPTED);
                LoginServiceUtil.notifyUserAcceptedInvite((String)username, (VO)this.rootVO, (String)scope, (String)this.getPortalBasicUrl(), (String)gatewayName, (Invite)invite);
            } else {
                LoginServiceUtil.notifyUserSelfRegistration((String)username, (VO)this.rootVO, (String)scope, (String)this.getPortalBasicUrl(), (String)gatewayName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public ArrayList<VO> getInfrastructureVOs() {
        _log.trace("getInfrastructureVOs method called");
        if (!this.isWithinPortal()) {
            return LoginServiceUtil.getFakeVOs();
        }
        try {
            User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
            List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
            ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
            Organization rootOrganization = null;
            for (Organization organization : organizations) {
                if (!organization.getName().equals(LoginServiceUtil.getRootOrganizationName())) continue;
                rootOrganization = organization;
                break;
            }
            try {
                _log.info("root: " + rootOrganization.getName());
            }
            catch (NullPointerException e) {
                _log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
                return new ArrayList<VO>();
            }
            ArrayList<VO> infrastructureVOs = new ArrayList<VO>();
            this.rootVO = new VO();
            this.rootVO.setName(rootOrganization.getName());
            this.rootVO.setGroupName("/" + rootOrganization.getName());
            this.rootVO.setRoot(true);
            Group orgGroup = rootOrganization.getGroup();
            String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
            this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
            long logoId = rootOrganization.getLogoId();
            String logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
            this.rootVO.setImageURL(logoURL);
            if (rootOrganization.getComments() != null) {
                this.rootVO.setDescription(rootOrganization.getComments());
            }
            if (this.hasRole(this.getVoAdminRoleName(), rootOrganization.getName(), currUser)) {
                this.rootVO.setUserBelonging(UserBelonging.BELONGING);
            } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)rootOrganization.getOrganizationId())) {
                this.rootVO.setUserBelonging(UserBelonging.PENDING);
            } else {
                this.rootVO.setUserBelonging(UserBelonging.NOT_BELONGING);
            }
            for (Organization vOrg : rootOrganization.getSuborganizations()) {
                _log.debug("FOUND VO: " + vOrg.getName());
                VO voToAdd = new VO();
                voToAdd.setName(vOrg.getName());
                voToAdd.setGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName());
                voToAdd.setRoot(false);
                for (VRE vre : vOrg.getSuborganizations()) {
                    VRE vreToAdd = new VRE();
                    vreToAdd.setId(vre.getOrganizationId());
                    vreToAdd.setName(vre.getName());
                    vreToAdd.setGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName() + "/" + vre.getName());
                    logoId = vre.getLogoId();
                    logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
                    vreToAdd.setImageURL(logoURL);
                    String vreUrl = vre.getGroup().getPathFriendlyURL(true, themeDisplay) + vre.getGroup().getFriendlyURL();
                    vreToAdd.setFriendlyURL(this.getPortalBasicUrl() + vreUrl);
                    if (vre.getComments() != null) {
                        vreToAdd.setDescription(vre.getComments());
                    }
                    vreToAdd.setUponRequest(true);
                    if (currUser.getOrganizations().contains(vre)) {
                        vreToAdd.setUserBelonging(UserBelonging.BELONGING);
                    } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)vre.getOrganizationId())) {
                        vreToAdd.setUserBelonging(UserBelonging.PENDING);
                    } else {
                        vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                        boolean requireAccessGrant = LoginServiceUtil.isEnabled((String)currUser.getScreenName(), (Organization)vre, (String)"Requestbasedgroup");
                        vreToAdd.setUponRequest(requireAccessGrant);
                    }
                    if (currUser.getOrganizations().contains(vre)) continue;
                    voToAdd.addVRE(vreToAdd);
                }
                Group group = vOrg.getGroup();
                String url = group.getPathFriendlyURL(true, themeDisplay) + group.getFriendlyURL();
                voToAdd.setFriendlyURL(this.getPortalBasicUrl() + url);
                if (vOrg.getComments() != null) {
                    voToAdd.setDescription(vOrg.getComments());
                }
                if (currUser.getOrganizations().contains(vOrg)) {
                    voToAdd.setUserBelonging(UserBelonging.BELONGING);
                } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)vOrg.getOrganizationId())) {
                    voToAdd.setUserBelonging(UserBelonging.PENDING);
                } else {
                    voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                }
                infrastructureVOs.add(voToAdd);
            }
            ArrayList<VO> toReturn = new ArrayList<VO>();
            for (VO vo : infrastructureVOs) {
                for (VRE vre : vo.getVres()) {
                    _log.debug("VRE FOUND.... " + vre.getName());
                }
                toReturn.add(vo);
            }
            Collections.sort(toReturn, Collections.reverseOrder());
            toReturn.add(0, this.rootVO);
            ArrayList<VO> toStoreInSession = toReturn;
            _log.debug("SETTING INFRASTRUCTURE VOS in ASLSession");
            this.getASLSession().setAttribute("CACHED_VOS", toStoreInSession);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<VO>();
        }
    }

    public void addMembershipRequest(String scope, String optionalMessage) {
        String username = this.getASLSession().getUsername();
        String gatewayName = "D4Science Gateway";
        if (this.getThreadLocalRequest().getSession().getAttribute("GATEWAY_NAME") != null) {
            gatewayName = this.getThreadLocalRequest().getSession().getAttribute("GATEWAY_NAME").toString();
            _log.debug("Gateway Label was Found=" + gatewayName);
        } else {
            _log.debug("Gateway Label Not Found");
        }
        LoginServiceUtil.addMembershipRequest((String)username, (VO)this.rootVO, (String)scope, (String)optionalMessage, (String)this.getPortalBasicUrl(), (String)gatewayName);
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String toReturn = "";
        String protocol = request.isSecure() ? "https://" : "http://";
        toReturn = toReturn + protocol;
        toReturn = toReturn + request.getServerName();
        toReturn = toReturn + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        return toReturn;
    }

    public VO getRootVO() {
        this.getASLSession().invalidate();
        if (this.rootVO != null) {
            return this.rootVO;
        }
        Organization rootOrganization = null;
        List organizations = null;
        try {
            organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        for (Organization organization : organizations) {
            if (!organization.getName().equals(LoginServiceUtil.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        this.rootVO.setName(rootOrganization.getName());
        this.rootVO.setGroupName("/" + rootOrganization.getName());
        this.rootVO.setRoot(true);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
        Group orgGroup = rootOrganization.getGroup();
        String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
        this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
        return this.rootVO;
    }

    public VRE getSelectedVRE(long organizationId) {
        _log.info("*getting Selected Research Environment from referral, org id = " + organizationId);
        ASLSession session = this.getASLSession();
        try {
            User currUser = OrganizationsUtil.validateUser((String)session.getUsername());
            long[] userOrgs = currUser.getOrganizationIds();
            _log.debug("Scanning " + currUser.getScreenName() + " organizations ids ... ");
            for (int i = 0; i < userOrgs.length; ++i) {
                System.out.println("FoundOrgId=" + userOrgs[i]);
            }
            UserBelonging belonging = UserBelonging.NOT_BELONGING;
            for (int i = 0; i < userOrgs.length; ++i) {
                if (userOrgs[i] != organizationId) continue;
                belonging = UserBelonging.BELONGING;
            }
            _log.debug("* * GetOrganizaion By Id() " + organizationId);
            Organization org = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            VRE toReturn = null;
            if (org != null) {
                String scope = "/" + PortalContext.getConfiguration().getInfrastructureName() + "/" + org.getParentOrganization().getName() + "/" + org.getName();
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                Group orgGroup = org.getGroup();
                String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
                boolean requireAccessGrant = LoginServiceUtil.isEnabled((String)currUser.getScreenName(), (Organization)org, (String)"Requestbasedgroup");
                toReturn = new VRE(org.getOrganizationId(), org.getName(), "", "", scope, friendlyURL, belonging, requireAccessGrant);
                _log.debug("* * Received referral, returning " + toReturn.toString());
            }
            return toReturn;
        }
        catch (PortalException | SystemException e) {
            _log.error("Something wrong happened while trying to getOrganization, probably the organization id is wrong. " + e.getMessage());
            return null;
        }
    }

    public String isExistingInvite(long organizationid) {
        VRE vre = this.getSelectedVRE(organizationid);
        String email = this.getASLSession().getUserEmailAddress();
        _log.debug("checking if invite exists for " + email + " on " + vre.getGroupName());
        JoinNewServiceImpl.initStore();
        return store.isExistingInvite(vre.getGroupName(), email);
    }

    private String getVoAdminRoleName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = OrganizationsUtil.getTomcatFolder() + "conf/gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("voadminRole");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename + "-" + organizationName) != 0) continue;
            return true;
        }
        return false;
    }

    public Boolean isUserRegistered() {
        this.getASLSession();
        return new Boolean(false);
    }

    public void loadLayout(String scope, String URL2) {
        _log.trace("Calling Load Layout...");
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), session.getAttribute("username").toString());
        mysession.setAttribute("loadlayout", (Object)"true");
        session.setAttribute("loadLayout", (Object)"true");
        session.setAttribute("selectedVRE", (Object)scope);
        mysession.logUserLogin(scope);
        mysession.setScope(scope);
        _log.trace("User login logged to: " + scope);
    }

    private void addUserToHLGroup(String username, String group, String adminUsername) {
        try {
            UserManager um = HomeLibrary.getHomeManagerFactory().getUserManager();
            um.associateUserToGroup(group, username, adminUsername);
        }
        catch (Exception e) {
            _log.error("Failed to get the usermanager from HL. Could not add user to the HL group");
        }
    }

    private void setVREBelonginApplication(VRE vre) {
        _log.info("AvailablePortlets stored in session");
        ArrayList<String> toSet = new ArrayList<String>();
        toSet.add("AnnotationFrontEnd_V2");
        this.getASLSession().setAttribute("availablePortlets", toSet);
    }

    public static synchronized DatabookStore initStore() {
        if (store == null) {
            store = new DBCassandraAstyanaxImpl();
        }
        return store;
    }

    static {
        _log = LoggerFactory.getLogger(JoinNewServiceImpl.class);
    }
}

