package org.gcube.portlets.user.joinnew.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.portal.CustomAttributeKeys;
import org.gcube.common.portal.GCubePortalConstants;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.SiteManagerUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portlets.user.joinnew.client.JoinNewService;
import org.gcube.portlets.user.joinnew.server.portlet.LoginPortlet;
import org.gcube.portlets.user.joinnew.shared.UserBelonging;
import org.gcube.portlets.user.joinnew.shared.VO;
import org.gcube.portlets.user.joinnew.shared.VRE;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class JoinNewServiceImpl extends RemoteServiceServlet implements JoinNewService {

	/**
	 * 
	 */
	public static final String CACHED_VOS = "CACHED_VOS";

	private static DatabookStore store;
	/**
	 * 
	 */
	public String SELECTED_THEMEID = "";

	private VO rootVO = new VO();

	private static Logger _log = LoggerFactory.getLogger(JoinNewServiceImpl.class);	

	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			_log.warn("USER IS NULL setting test.user");
			user = "test.user";
		}
		else {
			_log.info("LIFERAY PORTAL DETECTED user=" + user);
		}
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	/**
	 * 
	 * @return true if you're running into the portal, false if in development
	 */
	private boolean isWithinPortal() {
		try {
			UserLocalServiceUtil.getService();
			return true;
		} 
		catch (com.liferay.portal.kernel.bean.BeanLocatorException ex) {			
			_log.trace("Development Mode ON");
			return false;
		}			
	}
	/**
	 * the user to the VRE and in the HL Group, plus send notifications to the vre manages of the vre
	 */
	@Override
	public boolean registerUser(String scope, long groupId) {
		UserManager userM = new LiferayUserManager();
		try {
			ASLSession session = getASLSession();
			String username = session.getUsername();
			//add the user to the VRE
			userM.assignUserToGroup(groupId, userM.getUserId(username));
			//add him to the HL			
			addUserToHLGroup(username, scope, session.getUsername());

			String gatewayName = PortalContext.getConfiguration().getGatewayName();
			if (this.getThreadLocalRequest().getSession().getAttribute(LoginPortlet.GATEWAY_NAME) != null) {
				gatewayName = this.getThreadLocalRequest().getSession().getAttribute(LoginPortlet.GATEWAY_NAME).toString();
				_log.debug("Gateway Label was Found="+gatewayName);
			} else
				_log.debug("Gateway Label Not Found");

			initStore();
			String inviteId = store.isExistingInvite(scope, session.getUserEmailAddress());
			if (inviteId != null) {
				Invite invite = store.readInvite(inviteId);
				store.setInviteStatus(scope, session.getUserEmailAddress(), InviteStatus.ACCEPTED);
				LoginServiceUtil.notifyUserAcceptedInvite(username, rootVO, scope, getPortalBasicUrl(), gatewayName, invite);
			}
			else {			
				LoginServiceUtil.notifyUserSelfRegistration(username, rootVO, scope, getPortalBasicUrl(), gatewayName);
			}
		} 
		catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	/**
	 * first method called by the UI
	 */
	public ArrayList<VO> getInfrastructureVOs() {	
		_log.trace("getInfrastructureVOs method called");
		if (! isWithinPortal()) {
			//return new ArrayList<VO>();
			return LoginServiceUtil.getFakeVOs();
		}
		else {

			try {
				User currUser = SiteManagerUtil.validateUser(getASLSession().getUsername());
				GroupManager gm = new LiferayGroupManager();
				GCubeGroup rootGroupVO = gm.getRootVO();


				try {
					_log.info("root: " + rootGroupVO.getGroupName());
				}
				catch (NullPointerException e) {
					_log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
					return new ArrayList<VO>();
				}
				// Create the list of the Infrastructure VOs
				List<VO> infrastructureVOs = new ArrayList<VO>();

				//create and check the root VO
				rootVO = new VO();
				rootVO.setName(rootGroupVO.getGroupName());
				rootVO.setGroupName(gm.getInfrastructureScope(rootGroupVO.getGroupId()));
				rootVO.setRoot(true);	

				String friendlyURL = rootGroupVO.getFriendlyURL();
				rootVO.setFriendlyURL(GCubePortalConstants.PREFIX_GROUP_URL+friendlyURL);
				long logoId = rootGroupVO.getLogoId();
				String logoURL = "/image/layout_set_logo?img_id="+rootGroupVO.getLogoId();
				rootVO.setImageURL(logoURL);
				UserManager um = new LiferayUserManager();
				if (rootGroupVO.getDescription() != null)
					rootVO.setDescription(rootGroupVO.getDescription());
				rootVO.setUserBelonging(UserBelonging.NOT_BELONGING);
				List<GCubeUser> users = um.listUsersByGroup(rootGroupVO.getGroupId());
				for (GCubeUser gCubeUser : users) {
					if (currUser.getScreenName().compareTo(gCubeUser.getUsername()) == 0) {
						rootVO.setUserBelonging(UserBelonging.BELONGING);
						break;
					}							
				}

				_log.debug("rootVO = " + rootGroupVO.getGroupName() + " children? = " + rootGroupVO.getChildren().size());
				

				//for each root sub organizations (VO)
				for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
					_log.debug("FOUND VO: " + vOrg.getGroupName() );
					//create the VO
					VO voToAdd = new VO();
					voToAdd.setName(vOrg.getGroupName());
					voToAdd.setGroupName(gm.getInfrastructureScope(vOrg.getGroupId()));
					voToAdd.setRoot(false);	
					logoURL = "/image/layout_set_logo?img_id="+vOrg.getLogoId();
					voToAdd.setImageURL(logoURL);

					for (GCubeGroup vre : vOrg.getChildren()) {
						VRE vreToAdd = new VRE();
						vreToAdd.setName(vre.getGroupName());
						vreToAdd.setGroupName(gm.getInfrastructureScope(vre.getGroupId()));

						logoId = vre.getLogoId();
						logoURL =  "/image/layout_set_logo?img_id="+ logoId;
						_log.debug("VRE logoURL=" + logoURL);
						vreToAdd.setImageURL(logoURL);

						String vreUrl = vre.getFriendlyURL();
						vreToAdd.setFriendlyURL(GCubePortalConstants.PREFIX_GROUP_URL+vreUrl);

						//set the description for the vre
						if (vre.getDescription() != null)	{
							vreToAdd.setDescription(vre.getDescription());
						}

						//as default all require access grant
						vreToAdd.setUponRequest(true);
						//check if the user belongs to it
						if (gm.listGroupsByUser(currUser.getUserId()).contains(vre)) {
							vreToAdd.setUserBelonging(UserBelonging.BELONGING);
						}
						else if (LoginServiceUtil.checkPending(currUser.getScreenName(), vre.getGroupId()))
							vreToAdd.setUserBelonging(UserBelonging.PENDING);
						else {
							vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
							boolean requireAccessGrant = vre.isRequestBasedGroup();
							vreToAdd.setUponRequest(requireAccessGrant);
						}

						if (! currUser.getOrganizations().contains(vre))
							voToAdd.addVRE(vreToAdd);
					}
					String url = vOrg.getFriendlyURL();
					voToAdd.setFriendlyURL(GCubePortalConstants.PREFIX_GROUP_URL + url);

					//set the description for the vre
					if (vOrg.getDescription() != null)	voToAdd.setDescription(vOrg.getDescription());
					//check if the user belongs to it
					voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
					users = um.listUsersByGroup(vOrg.getGroupId());
					for (GCubeUser gCubeUser : users) {
						if (currUser.getScreenName().compareTo(gCubeUser.getUsername()) == 0) {
							voToAdd.setUserBelonging(UserBelonging.BELONGING);
							break;
						}							
					}
					infrastructureVOs.add(voToAdd);
				}

				ArrayList<VO> toReturn = new ArrayList<VO>();


				for (VO vo : infrastructureVOs) {
					for (VRE vre : vo.getVres()) {
						_log.debug("VRE FOUND.... " + vre.getName());
					}
					toReturn.add(vo);
				}			
				//sort the VOs
				Collections.sort(toReturn, Collections.reverseOrder()); 

				//set the root vo as FIRST
				toReturn.add(0, rootVO);

				ArrayList<VO> toStoreInSession = toReturn;			
				_log.debug("SETTING INFRASTRUCTURE VOS in ASLSession");
				getASLSession().setAttribute(CACHED_VOS, toStoreInSession);

				return toReturn;

			} 
			catch (Exception e) {			
				e.printStackTrace();
			} 
			return new ArrayList<VO>();
		}
	}

	/**
	 * addMembershipRequest
	 */
	public void addMembershipRequest(String scope, String optionalMessage) {
		String username = getASLSession().getUsername();
		try {
			LoginServiceUtil.addMembershipRequest(username, rootVO, scope, optionalMessage, getPortalBasicUrl(), PortalContext.getConfiguration().getGatewayName());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}	

	/**
	 * 
	 * @return the portal basic url, e.g. http://www.foo.com
	 */
	private String getPortalBasicUrl() {
		HttpServletRequest request = this.getThreadLocalRequest();
		String toReturn = "";
		//protocol
		String protocol = (request.isSecure()) ? "https://" : "http://" ;
		toReturn += protocol;
		//server name
		toReturn += request.getServerName();
		//port
		toReturn +=  (request.getServerPort() == 80) ? "" : ":"+request.getServerPort() ;
		//_log.trace("getPortalBasicUrl: " +toReturn + "request.getServerPort: " +	request.getServerPort());
		return toReturn;
	}

	public boolean isExternal(Group group) throws GroupRetrievalFault {
		GroupManager gm = new LiferayGroupManager();
		return (Boolean) gm.readCustomAttr(20620, CustomAttributeKeys.IS_EXTERNAL.getKeyName());
	}


	/**
	 * return the root org
	 */
	public VO getRootVO() {
		//_log.debug("root called");
		getASLSession().invalidate();

		if (rootVO != null) return rootVO;
		else {
			GroupManager gm = new LiferayGroupManager();
			GCubeGroup root = null;
			try {
				root = gm.getRootVO();
			} catch (UserManagementSystemException | GroupRetrievalFault e) {
				e.printStackTrace();
			}
			rootVO.setName(root.getGroupName());
			rootVO.setGroupName("/"+root.getGroupName());
			rootVO.setRoot(true);	
			String friendlyURL = root.getFriendlyURL();
			rootVO.setFriendlyURL(GCubePortalConstants.PREFIX_GROUP_URL+friendlyURL);
			String logoURL = "/image/layout_set_logo?img_id="+root.getLogoId();
			rootVO.setImageURL(logoURL);
			return rootVO;
		}
	}
	/**
	 * return the selected VRE "from outside" with information about the user
	 */
	public VRE getSelectedVRE(long groupId) {
		_log.info("*getting Selected Research Environment from referral, org id = " + groupId);
		ASLSession session = getASLSession();
		try {
			GroupManager gm = new LiferayGroupManager();
			GCubeGroup vre = null;
			try {
				vre = gm.getGroup(groupId);
			} catch (UserManagementSystemException | GroupRetrievalFault e) {
				e.printStackTrace();
			}
			
			VRE vreToAdd = new VRE();		
			vreToAdd.setName(vre.getGroupName());
			vreToAdd.setGroupName(gm.getInfrastructureScope(vre.getGroupId()));
		
			String logoURL =  "/image/layout_set_logo?img_id="+ +vre.getLogoId();
			_log.debug("VRE logoURL=" + logoURL);
			vreToAdd.setImageURL(logoURL);

			String vreUrl = vre.getFriendlyURL();
			vreToAdd.setFriendlyURL(GCubePortalConstants.PREFIX_GROUP_URL+vreUrl);

			//set the description for the vre
			if (vre.getDescription() != null)	{
				vreToAdd.setDescription(vre.getDescription());
			}

			//as default all require access grant
			vreToAdd.setUponRequest(true);
			
			//check if the user belongs to it
			UserManager um = new LiferayUserManager();
			GCubeUser user = um.getUserByUsername(session.getUsername());
			if (gm.listGroupsByUser(user.getUserId()).contains(vre)) {
				vreToAdd.setUserBelonging(UserBelonging.BELONGING);
			}
			else if (LoginServiceUtil.checkPending(session.getUsername(), vre.getGroupId()))
				vreToAdd.setUserBelonging(UserBelonging.PENDING);
			else {
				vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
				boolean requireAccessGrant = vre.isRequestBasedGroup();
				vreToAdd.setUponRequest(requireAccessGrant);
			}
		} catch (Exception e) {
			_log.error("Something wrong happened while trying to getOrganization, probably the organization id is wrong. " + e.getMessage());
		}
		return null;
	}

	@Override
	public String isExistingInvite(long organizationid) {
		VRE vre = getSelectedVRE(organizationid);
		String email = getASLSession().getUserEmailAddress();
		_log.debug("checking if invite exists for " + email + " on " + vre.getGroupName());
		initStore();
		return store.isExistingInvite(vre.getGroupName(), email);
	}	

	
	/**
	 * 
	 * @param rolename
	 * @param organizationName
	 * @param user
	 * @return
	 * @throws SystemException 
	 */
	private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
		for (Role role : user.getRoles()) {
			//_log.trace("COMPARING ROLE: " +role.getName() + " -> " + rolename + "-" + organizationName);
			if (role.getName().compareTo( rolename + "-" + organizationName) == 0 ) 
				return true;
		}
		return false;
	}


	/**
	 * the first method to call
	 */
	public Boolean isUserRegistered() {
		getASLSession();
		return new Boolean(false);
	}
	/**
	 * 
	 * @param scope
	 */
	public void loadLayout(String scope, String URL) {
		_log.trace("Calling Load Layout...");
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), session.getAttribute("username").toString());
		mysession.setAttribute("loadlayout", "true");
		session.setAttribute("loadLayout", "true");
		session.setAttribute("selectedVRE", scope);
		mysession.logUserLogin(scope);
		mysession.setScope(scope);

		_log.trace("User login logged to: " + scope);
	}


	private void addUserToHLGroup(String username, String group, String adminUsername) {
		try {
			org.gcube.common.homelibrary.home.workspace.usermanager.UserManager um = HomeLibrary.getHomeManagerFactory().getUserManager();
			um.associateUserToGroup(group, username, adminUsername);
		} catch (Exception e) {
			_log.error("Failed to get the usermanager from HL. Could not add user to the HL group");
		}
	}
	/**
	 * TODO: Look which portlets are in the current VRE layout and create a List of names with them
	 * @param vre
	 */
	private void setVREBelonginApplication(VRE vre) {
		_log.info("AvailablePortlets stored in session");
		ArrayList<String> toSet = new ArrayList<String>();
		toSet.add("AnnotationFrontEnd_V2");
		getASLSession().setAttribute("availablePortlets", toSet);
	}


	/**
	 * 
	 * @return the unique instance of the store
	 */
	public static synchronized DatabookStore initStore() {
		if (store == null) {
			store = new DBCassandraAstyanaxImpl();
		}
		return store;
	}
}
