package org.gcube.portlets.user.joinvre.model;

import java.io.Serializable;

/**
 * VRE Model - Migrated from 6.2 to 7.4
 * 
 * @author Massimiliano Assante, ISTI-CNR (original)
 * @author netfarm-m2 (migration to 7.4)
 */
public class VRE implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	private long id;
	private String name;
	private String description;
	private String thumbnailURL;
	private String url;
	private boolean isPublic;
	private boolean isOpen;
	private int membersCount;
	private String categoryName;
	private UserBelonging userBelonging;
	
	// New fields for 7.4 compatibility
	private String membershipType;
	private boolean publicPages;
	private String friendlyURL;
	
	public VRE() {
		super();
	}
	
	public VRE(long id, String name, String description, String thumbnailURL, String url, 
			boolean isPublic, boolean isOpen, int membersCount, String categoryName, UserBelonging userBelonging) {
		this.id = id;
		this.name = name;
		this.description = description;
		this.thumbnailURL = thumbnailURL;
		this.url = url;
		this.isPublic = isPublic;
		this.isOpen = isOpen;
		this.membersCount = membersCount;
		this.categoryName = categoryName;
		this.userBelonging = userBelonging;
	}
	
	/**
	 * Full constructor with all fields including new ones for 7.4 compatibility
	 */
	public VRE(long id, String name, String description, String thumbnailURL, String url, 
			boolean isPublic, boolean isOpen, int membersCount, String categoryName, UserBelonging userBelonging,
			String membershipType, boolean publicPages, String friendlyURL) {
		this.id = id;
		this.name = name;
		this.description = description;
		this.thumbnailURL = thumbnailURL;
		this.url = url;
		this.isPublic = isPublic;
		this.isOpen = isOpen;
		this.membersCount = membersCount;
		this.categoryName = categoryName;
		this.userBelonging = userBelonging;
		this.membershipType = membershipType;
		this.publicPages = publicPages;
		this.friendlyURL = friendlyURL;
	}
	
	public long getId() {
		return id;
	}
	
	public void setId(long id) {
		this.id = id;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public String getDescription() {
		return description;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}
	
	public String getThumbnailURL() {
		return thumbnailURL;
	}
	
	public void setThumbnailURL(String thumbnailURL) {
		this.thumbnailURL = thumbnailURL;
	}
	
	public String getUrl() {
		return url;
	}
	
	public void setUrl(String url) {
		this.url = url;
	}
	
	public boolean isPublic() {
		return isPublic;
	}
	
	public void setPublic(boolean isPublic) {
		this.isPublic = isPublic;
	}
	
	public boolean isOpen() {
		return isOpen;
	}
	
	public void setOpen(boolean isOpen) {
		this.isOpen = isOpen;
	}
	
	public int getMembersCount() {
		return membersCount;
	}
	
	public void setMembersCount(int membersCount) {
		this.membersCount = membersCount;
	}
	
	public String getCategoryName() {
		return categoryName;
	}
	
	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}
	
	/**
	 * Get user belonging object
	 */
	public UserBelonging getUserBelongingObject() {
		return userBelonging;
	}
	
	public void setUserBelonging(UserBelonging userBelonging) {
		this.userBelonging = userBelonging;
	}
	
	/**
	 * Get user belonging as string for JSP compatibility
	 * @return "NOT_BELONGING", "PENDING", "BELONGING", etc.
	 */
	public String getUserBelonging() {
		if (userBelonging == null) {
			return "NOT_BELONGING";
		}
		
		switch (userBelonging.getMembershipType()) {
			case MEMBER:
			case ADMIN:
			case OWNER:
				return "BELONGING";
			case PENDING:
				return "PENDING";
			case NOT_MEMBER:
			default:
				return "NOT_BELONGING";
		}
	}
	
	// Additional methods for JSP compatibility
	
	/**
	 * Alias for getCategoryName() - for JSP compatibility
	 */
	public String getCategory() {
		return this.categoryName;
	}
	
	/**
	 * Get membership type (OPEN, RESTRICTED, PRIVATE)
	 */
	public String getMembershipType() {
		return membershipType;
	}
	
	public void setMembershipType(String membershipType) {
		this.membershipType = membershipType;
	}
	
	/**
	 * Check if VRE has public pages
	 */
	public boolean isPublicPages() {
		return publicPages;
	}
	
	public void setPublicPages(boolean publicPages) {
		this.publicPages = publicPages;
	}
	
	/**
	 * Get friendly URL for the VRE
	 */
	public String getFriendlyURL() {
		return friendlyURL;
	}
	
	public void setFriendlyURL(String friendlyURL) {
		this.friendlyURL = friendlyURL;
	}
	
	@Override
	public String toString() {
		return "VRE [id=" + id + ", name=" + name + ", description=" + description + 
				", isPublic=" + isPublic + ", isOpen=" + isOpen + ", membersCount=" + membersCount + 
				", userBelonging=" + userBelonging + "]";
	}
}