package org.gcube.portlets.user.joinvre.portlet.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.gcube.portlets.user.joinvre.constants.JoinVREPortletKeys;
import org.osgi.service.component.annotations.Component;

/**
 * Configuration Action for JoinVRE Portlet - Migrated from 6.2 to 7.4
 * 
 * @author Luca Frosini (ISTI - CNR) (original)
 * @author netfarm-m2 (migration to 7.4)
 */
@Component(
    immediate = true,
    property = {
        "javax.portlet.name=" + JoinVREPortletKeys.JOINVRE
    },
    service = ConfigurationAction.class
)
public class JoinVREConfigurationAction extends DefaultConfigurationAction {

    private static final Log _log = LogFactoryUtil.getLog(JoinVREConfigurationAction.class);
    
    public static final String PROPERTIES = "properties";

    @Override
    public void processAction(
            PortletConfig portletConfig, ActionRequest actionRequest,
            ActionResponse actionResponse)
        throws Exception {

        try {
            // Get the properties parameter from the request
            String properties = ParamUtil.getString(actionRequest, PROPERTIES);
            
            // Get portlet preferences
            PortletPreferences preferences = actionRequest.getPreferences();
            
            // Store the properties
            preferences.setValue(PROPERTIES, properties);
            preferences.store();
            
            // Add success message
            SessionMessages.add(actionRequest, "requestProcessed");
            
            _log.info("JoinVRE portlet configuration updated successfully");
            
        } catch (Exception e) {
            _log.error("Error processing JoinVRE portlet configuration", e);
            throw e;
        }
        
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    @Override
    public void include(
            PortletConfig portletConfig, HttpServletRequest httpServletRequest,
            HttpServletResponse httpServletResponse)
        throws Exception {

        httpServletRequest.setAttribute(
            "configurationActionJSP", "/config.jsp");

        super.include(portletConfig, httpServletRequest, httpServletResponse);
    }
}