package org.gcube.portlets.user.joinvre.service;

import java.util.List;

import org.gcube.portlets.user.joinvre.model.TabbedPage;
import org.gcube.portlets.user.joinvre.model.UserBelonging;
import org.gcube.portlets.user.joinvre.model.VRE;
import org.gcube.portlets.user.joinvre.model.VRECategory;

import com.liferay.portal.kernel.model.User;

/**
 * JoinVRE Service Interface - Migrated from 6.2 to 7.4
 * 
 * @author Massimiliano Assante, ISTI-CNR (original)
 * @author netfarm-m2 (migration to 7.4)
 */
public interface JoinVREService {
	
	/**
	 * Join a VRE
	 * @param vreID the VRE ID to join
	 * @param user the current user
	 * @return the landing page path
	 */
	String joinVRE(Long vreID, User user);
	
	/**
	 * Read invite information
	 * @param inviteId the invite ID
	 * @param siteId the site ID
	 * @return UserInfo containing invite details
	 */
	Object readInvite(String inviteId, long siteId);
	
	/**
	 * Get Terms of Use for a site
	 * @param siteId the site ID
	 * @return Terms of Use content or null if not exists
	 */
	String getTermsOfUse(long siteId);
	
	/**
	 * Check if current site is a tabbed panel
	 * @param groupId the group ID
	 * @return list of tabbed pages or null
	 */
	List<TabbedPage> isTabbedPanel(long groupId);
	
	/**
	 * Get all VREs for the current user
	 * @param user the current user
	 * @return list of VREs
	 */
	List<VRE> getAllVREs(User user);
	
	/**
	 * Get available VREs (public method for JSP compatibility)
	 * @return list of available VREs
	 */
	List<VRE> getAvailableVREs();
	
	/**
	 * Get VRE categories
	 * @return list of VRE categories
	 */
	List<VRECategory> getVRECategories();
	
	/**
	 * Get user belonging information
	 * @param user the current user
	 * @param vreId the VRE ID
	 * @return user belonging status
	 */
	UserBelonging getUserBelonging(User user, long vreId);
	
	/**
	 * Request membership to a VRE
	 * @param user the current user
	 * @param vreId the VRE ID
	 * @param comments membership request comments
	 * @return success status
	 */
	boolean requestMembership(User user, long vreId, String comments);
}