package org.gcube.portlets.user.messages.client.event;

import org.gcube.portlets.user.messages.client.interfaces.EventsTypeEnum;
import org.gcube.portlets.user.messages.client.interfaces.GuiEventInterface;
import org.gcube.portlets.user.messages.shared.MessageModel;

import com.google.gwt.event.shared.GwtEvent;

public class OpenMessageEvent extends GwtEvent<OpenMessageEventHandler> implements GuiEventInterface {
	public static Type<OpenMessageEventHandler> TYPE = new Type<OpenMessageEventHandler>();
	
	private String messageIdentifier = null; //Report template
	private OpenType openType;
	private String messageType;
	
	private MessageModel message;//Added for Massi
	
//	public enum OpenType {OPEN, FORWARD}
	
	public enum OpenType {REPLY, REPLYALL, FORWARD}//Refactor for Massi
	
	public OpenMessageEvent(String messageIdentifier, OpenType openType, String messageType) {
		this.messageIdentifier = messageIdentifier;
		this.openType = openType;
		this.messageType = messageType;
	}

	@Override
	public Type<OpenMessageEventHandler> getAssociatedType() {
		// TODO Auto-generated method stub
		return TYPE;
	}

	@Override
	protected void dispatch(OpenMessageEventHandler handler) {
		handler.onOpenMessage(this);
	}

	public String getMessageIdentifier() {
		return messageIdentifier;
	}

	public OpenType getOpenType() {
		return openType;
	}
	
	public String getOpenTypeToString() {
		return openType.toString();
	}

	public String getMessageType() {
		return messageType;
	}

	@Override
	public EventsTypeEnum getKey() {
		return EventsTypeEnum.REPLY_FORWARD_MESSAGE;
	}

	public MessageModel getMessage() {
		return message;
	}

	public void setMessage(MessageModel message) {
		this.message = message;
	}
	
	
}
