/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.messages.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portlets.user.messages.client.rpc.MessagesService;
import org.gcube.portlets.user.messages.server.GWTMessagesBuilder;
import org.gcube.portlets.user.messages.server.util.SessionUtil;
import org.gcube.portlets.user.messages.shared.MessageModel;
import org.gcube.portlets.user.messages.shared.SessionExpiredException;
import org.gcube.portlets.user.workspaceapplicationhandler.ApplicationReaderFromGenericResource;

public class MessagesServiceImpl
extends RemoteServiceServlet
implements MessagesService {
    public static final String TEST_SCOPE = "/gcube/devsec";
    public static final String TEST_USER = "test.user";
    public static final String TEST_USER_FULLNAME = "Test User";
    public static final String USERNAME_ATTRIBUTE = "username";
    public static boolean withinPortal = false;
    public static Logger _log = Logger.getLogger(MessagesServiceImpl.class);
    private DatabookStore store;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    protected GWTMessagesBuilder getGWTWorkspaceBuilder() {
        return SessionUtil.getGWTWorkspaceBuilder((ASLSession)this.getASLSession());
    }

    public boolean sentToByMessageModel(MessageModel message) throws Exception {
        return false;
    }

    private ASLSession getASLSession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String sessionID = httpSession.getId();
        String user = (String)httpSession.getAttribute(USERNAME_ATTRIBUTE);
        if (user == null) {
            _log.error((Object)" STARTING IN TEST MODE - NO USER FOUND");
            ASLSession session = SessionManager.getInstance().getASLSession(sessionID, TEST_USER);
            session.setScope(TEST_SCOPE);
            return session;
        }
        _log.info((Object)("LIFERAY PORTAL DETECTED user=" + user));
        withinPortal = true;
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public boolean setAllUserMessageNotificationsRead() {
        _log.trace((Object)("setAllUserMessageNotificationsRead withinPortal?" + withinPortal));
        String username = this.getASLSession().getUsername();
        try {
            if (withinPortal) {
                for (Notification notification : this.store.getUnreadNotificationMessagesByUser(this.getASLSession().getUsername())) {
                    this.store.setNotificationRead(notification.getKey());
                    _log.trace((Object)("setNotificationRead for user " + username + " as " + notification.getKey()));
                }
            }
            return true;
        }
        catch (Exception e) {
            _log.error((Object)("While trying to set User notifications Read " + e), (Throwable)e);
            return false;
        }
    }

    protected Workspace getWorkspace() throws Exception {
        try {
            return SessionUtil.getWorkspace((ASLSession)this.getASLSession());
        }
        catch (WorkspaceFolderNotFoundException e) {
            _log.error((Object)("An error occurred in get workspace WorkspaceFolderNotFoundException" + (Object)((Object)e)), (Throwable)e);
            throw new Exception("An error occurred in get user workspace");
        }
        catch (InternalErrorException e) {
            _log.error((Object)("An error occurred in get workspace InternalErrorException" + (Object)((Object)e)), (Throwable)e);
            throw new Exception("An error occurred in get user workspace");
        }
        catch (HomeNotFoundException e) {
            _log.error((Object)("An error occurred in get workspace HomeNotFoundException" + (Object)((Object)e)), (Throwable)e);
            throw new Exception("An error occurred in get user workspace");
        }
        catch (Exception e) {
            _log.error((Object)("An error occurred in get workspace" + e), (Throwable)e);
            throw new Exception("An error occurred in get user workspace");
        }
    }

    public boolean sendToById(List<String> listContactsId, List<String> listAttachmentsId, String subject, String text) throws Exception {
        try {
            Workspace workspace = this.getWorkspace();
            _log.info((Object)"send To");
            _log.trace((Object)"######### SEND TO: ");
            _log.trace((Object)("subject " + subject));
            _log.trace((Object)("body " + text));
            for (String contactId : listContactsId) {
                _log.trace((Object)("contactId " + contactId));
            }
            for (String id : listAttachmentsId) {
                _log.trace((Object)("attachId " + id));
            }
            workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(subject, text, listAttachmentsId, listContactsId);
            return true;
        }
        catch (Exception e) {
            _log.error((Object)"Error in server sendTo ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public List<MessageModel> getAllMessagesReceived() throws Exception {
        if (this.isSessionExpired()) {
            throw new SessionExpiredException();
        }
        try {
            Workspace workspace = this.getWorkspace();
            _log.trace((Object)"get All Messages Received ");
            GWTMessagesBuilder builder = this.getGWTWorkspaceBuilder();
            List listMessages = workspace.getWorkspaceMessageManager().getReceivedMessages();
            return builder.buildGXTListMessageModelForGrid(listMessages, "Received", withinPortal);
        }
        catch (Exception e) {
            _log.error((Object)"Error in server getAllMessagesReceived ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public List<MessageModel> getNewMessagesReceived() throws Exception {
        if (this.isSessionExpired()) {
            throw new SessionExpiredException();
        }
        try {
            _log.trace((Object)"in server getNewMessagesReceived ");
            Workspace workspace = this.getWorkspace();
            int count = workspace.getWorkspaceMessageManager().getMessagesNotOpened();
            ArrayList<MessageModel> listMessageModels = new ArrayList<MessageModel>();
            for (int i = 0; i < count; ++i) {
                listMessageModels.add(new MessageModel());
            }
            return listMessageModels;
        }
        catch (Exception e) {
            _log.error((Object)"Error in server getNewMessagesReceived by messageIdentifier ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public List<MessageModel> getAllMessagesSent() throws Exception {
        if (this.isSessionExpired()) {
            throw new SessionExpiredException();
        }
        try {
            Workspace workspace = this.getWorkspace();
            _log.info((Object)"getAllMessagesSent");
            _log.trace((Object)"get All Messages Sent ");
            GWTMessagesBuilder builder = this.getGWTWorkspaceBuilder();
            List listMessages = workspace.getWorkspaceMessageManager().getSentMessages();
            return builder.buildGXTListMessageModelForGrid(listMessages, "Sent", withinPortal);
        }
        catch (Exception e) {
            _log.error((Object)"Error in server getAllMessagesSent ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public List<MessageModel> searchInSentMessagesByText(String text) throws Exception {
        try {
            Workspace workspace = this.getWorkspace();
            _log.info((Object)"searchInSentMessagesByText");
            GWTMessagesBuilder builder = this.getGWTWorkspaceBuilder();
            List listMessages = workspace.getWorkspaceMessageManager().searchOutMessages(text);
            return builder.buildGXTListMessageModelForGrid(listMessages, "Sent", withinPortal);
        }
        catch (Exception e) {
            _log.error((Object)"Error in server searchInSentMessagesByText ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public List<MessageModel> searchInReceivedMessagesByText(String text) throws Exception {
        try {
            Workspace workspace = this.getWorkspace();
            _log.info((Object)"searchInSentMessagesByText");
            GWTMessagesBuilder builder = this.getGWTWorkspaceBuilder();
            List listMessages = workspace.getWorkspaceMessageManager().searchInMessages(text);
            return builder.buildGXTListMessageModelForGrid(listMessages, "Received", withinPortal);
        }
        catch (Exception e) {
            _log.error((Object)"Error in server searchInSentMessagesByText ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public MessageModel getMessageById(String messageIdentifier, String messageType) throws Exception {
        if (this.isSessionExpired()) {
            throw new SessionExpiredException();
        }
        try {
            Workspace workspace = this.getWorkspace();
            _log.info((Object)("get Message by Id " + messageIdentifier));
            GWTMessagesBuilder builder = this.getGWTWorkspaceBuilder();
            WorkspaceMessage message = null;
            message = messageType.equals("Received") ? workspace.getWorkspaceMessageManager().getReceivedMessage(messageIdentifier) : workspace.getWorkspaceMessageManager().getSentMessage(messageIdentifier);
            List listWorkspaceItems = this.getListWorkspaceItemById(workspace, message.getAttachmentsIds());
            return builder.buildGXTMessageModel(message, listWorkspaceItems, messageType, withinPortal);
        }
        catch (Exception e) {
            _log.error((Object)"Error in server get Message by Id ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    private List<WorkspaceItem> getListWorkspaceItemById(Workspace workspace, List<String> listItemsId) throws ItemNotFoundException, InternalErrorException {
        ArrayList<WorkspaceItem> listWorkspaceItem = new ArrayList<WorkspaceItem>();
        for (String itemId : listItemsId) {
            WorkspaceItem item = workspace.getItem(itemId);
            _log.trace((Object)("Attach name: " + item.getName()));
            _log.trace((Object)("Attach id: " + item.getId()));
            listWorkspaceItem.add(workspace.getItem(itemId));
        }
        return listWorkspaceItem;
    }

    public boolean saveAttachments(String messageIdentifier, String messageType) throws Exception {
        try {
            Workspace workspace = this.getWorkspace();
            _log.info((Object)"save attachments by messageIdentifier");
            _log.trace((Object)(" save attachments by messageIdentifier " + messageIdentifier));
            if (messageType.equals("Sent")) {
                workspace.getWorkspaceMessageManager().getSentMessage(messageIdentifier).saveAttachments(workspace.getRoot().getId());
            } else {
                workspace.getWorkspaceMessageManager().getReceivedMessage(messageIdentifier).saveAttachments(workspace.getRoot().getId());
            }
            return true;
        }
        catch (Exception e) {
            _log.error((Object)"Error in server save attachments by messageIdentifier ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public String saveAttachment(String messageIdentifier, String attachmentId, String messageType) throws Exception {
        try {
            Workspace workspace = this.getWorkspace();
            _log.info((Object)"save attachment by attachmentId");
            _log.trace((Object)(" save attachment by attachmentId " + attachmentId));
            System.out.println("messageIdentifier " + messageIdentifier + " attachmentId " + attachmentId + " messageType " + messageType);
            WorkspaceItem item = messageType.equals("Sent") ? workspace.getWorkspaceMessageManager().getSentMessage(messageIdentifier).saveAttachment(attachmentId, workspace.getRoot().getId()) : workspace.getWorkspaceMessageManager().getReceivedMessage(messageIdentifier).saveAttachment(attachmentId, workspace.getRoot().getId());
            if (item != null) {
                return item.getId();
            }
            return null;
        }
        catch (Exception e) {
            _log.error((Object)"Error in server attachment by attachmentId ", (Throwable)e);
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public boolean saveAttach(String attachId) throws Exception {
        return false;
    }

    public boolean markMessage(String messageIdentifier, String messageType, boolean boolMark, String markType) throws Exception {
        try {
            Workspace workspace = this.getWorkspace();
            _log.trace((Object)(" markMessageAsRead by messageIdentifier " + messageIdentifier + " boolMark " + boolMark + " messageType " + messageType));
            if (messageType.equals("Received")) {
                if (markType.equals("READ")) {
                    workspace.getWorkspaceMessageManager().getReceivedMessage(messageIdentifier).setStatus(boolMark);
                } else if (markType.equals("OPEN")) {
                    workspace.getWorkspaceMessageManager().getReceivedMessage(messageIdentifier).open();
                } else if (markType.equals("BOTH")) {
                    workspace.getWorkspaceMessageManager().getReceivedMessage(messageIdentifier).setStatus(boolMark);
                    workspace.getWorkspaceMessageManager().getReceivedMessage(messageIdentifier).open();
                }
            } else if (markType.equals("READ")) {
                workspace.getWorkspaceMessageManager().getSentMessage(messageIdentifier).setStatus(boolMark);
            } else if (markType.equals("OPEN")) {
                workspace.getWorkspaceMessageManager().getSentMessage(messageIdentifier).open();
            } else if (markType.equals("BOTH")) {
                workspace.getWorkspaceMessageManager().getSentMessage(messageIdentifier).setStatus(boolMark);
                workspace.getWorkspaceMessageManager().getSentMessage(messageIdentifier).open();
            }
            return true;
        }
        catch (Exception e) {
            _log.error((Object)"Error in server markMessageAsRead by messageIdentifier ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public boolean deleteMessage(String messageIdentifier, String messageType) throws Exception {
        try {
            Workspace workspace = this.getWorkspace();
            _log.trace((Object)("deleteMessage by messageIdentifier " + messageIdentifier));
            if (messageType.equals("Received")) {
                workspace.getWorkspaceMessageManager().deleteReceivedMessage(messageIdentifier);
            } else {
                workspace.getWorkspaceMessageManager().deleteSentMessage(messageIdentifier);
            }
            return true;
        }
        catch (Exception e) {
            _log.error((Object)"Error in server deleteMessage by messageIdentifier ", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public String getURLFromApplicationProfile(String identifier) throws Exception {
        String urlPortlet = "";
        ApplicationReaderFromGenericResource app = new ApplicationReaderFromGenericResource();
        try {
            urlPortlet = app.getURLFromApplicationProfile(identifier, this.getASLSession(), this.getThreadLocalRequest().getSession());
        }
        catch (Exception e) {
            _log.error((Object)"getURLFromApplicationProfile", (Throwable)e);
            throw new Exception("Sorry, an error occurred in retrieve application profile, try again");
        }
        return urlPortlet;
    }

    public boolean isSessionExpired() throws Exception {
        _log.trace((Object)"messages session validating...");
        String userUsername = this.getASLSession().getUsername();
        boolean isTestUser = userUsername.compareTo(TEST_USER) == 0;
        _log.trace((Object)("is test.user user: " + isTestUser + " is into portal: " + withinPortal));
        if (isTestUser && withinPortal) {
            _log.error((Object)"workspace session is expired! username is: test.user");
            return true;
        }
        _log.trace((Object)("workspace session is valid! current username is: " + userUsername));
        return false;
    }
}

