package org.gcube.portlets.user.newsfeed.client.event;

import org.gcube.portlets.user.newsfeed.client.templates.TweetTemplate;

import com.google.gwt.event.shared.GwtEvent;



public class AddCommentEvent  extends GwtEvent<AddCommentEventHandler> {
	public static Type<AddCommentEventHandler> TYPE = new Type<AddCommentEventHandler>();
	
	private TweetTemplate owner;
	private String text;
	
	public TweetTemplate getOwner() {
		return owner;
	}
	public String getText() {
		return text;
	}
	public AddCommentEvent(TweetTemplate owner, String text) {
		this.owner = owner;
		this.text = text;
	}

	@Override
	public Type<AddCommentEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(AddCommentEventHandler handler) {
		handler.onAddComment(this);
	}
}
