package org.gcube.portlets.user.newsfeed.client.templates;

import org.gcube.portal.databook.client.GCubeSocialNetworking;
import org.gcube.portal.databook.client.util.Encoder;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portlets.user.newsfeed.client.event.DeleteCommentEvent;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class SingleComment extends Composite {

	private static SingleCommentUiBinder uiBinder = GWT
			.create(SingleCommentUiBinder.class);

	interface SingleCommentUiBinder extends UiBinder<Widget, SingleComment> {
	}
	private static final int MAX_SHOWTEXT_LENGTH = 256;
	
	private boolean isUsers = false;
	private TweetTemplate owner;
	private String myCommentid;
	private Comment myComment;

	@UiField HTMLPanel mainPanel;
	@UiField Image avatarImage;
	@UiField HTML commentText;
	@UiField HTML timeArea;
	@UiField HTML closeImage;
	@UiField HTML editImage;
	@UiField HTML seeMore;

	public SingleComment(Comment toShow, TweetTemplate owner, boolean isUsers) {
		initWidget(uiBinder.createAndBindUi(this));
		this.owner = owner;
		this.isUsers = isUsers;
		this.myComment = toShow;
		myCommentid = toShow.getKey();
		avatarImage.setPixelSize(30, 30);
		avatarImage.setUrl(toShow.getThumbnailURL());	
		
		String commentToShow = toShow.getText();
		if (commentToShow.length() > MAX_SHOWTEXT_LENGTH) {
			commentToShow = commentToShow.substring(0, MAX_SHOWTEXT_LENGTH) + "...";
			seeMore.setHTML("<a class=\"seemore\"> See More </a>");
		}
		
		commentText.setHTML("<a class=\"link\" href=\""+GCubeSocialNetworking.USER_PROFILE_LINK+"?"+
					Encoder.encode(GCubeSocialNetworking.USER_PROFILE_OID)+"="+
					Encoder.encode(toShow.getUserid())+"\">"+toShow.getFullName()+
					"</a> " + commentToShow);
		timeArea.setHTML(DateTimeFormat.getFormat("MMMM dd, h:mm a").format(toShow.getTime()));
		if (isUsers) {
			closeImage.setStyleName("closeImage");
			closeImage.setTitle("Delete");
			editImage.setStyleName("editImage");
			editImage.setTitle("Edit");
		}
	}
	
	@UiHandler("seeMore") 
	void onSeeMoreClick(ClickEvent e) {
		commentText.setHTML("<a class=\"link\" href=\""+GCubeSocialNetworking.USER_PROFILE_LINK+"?"+
					Encoder.encode(GCubeSocialNetworking.USER_PROFILE_OID)+"="+
					Encoder.encode(myComment.getUserid())+"\">"+
					myComment.getFullName()+"</a> " + myComment.getText());
		seeMore.setHTML("");
	}	
	
	

	@UiHandler("closeImage") 
	void onDeleteCommentClick(ClickEvent e) {
		if (isUsers) 
			owner.getEventBus().fireEvent(new DeleteCommentEvent(owner, myCommentid));
	}	

	@UiHandler("editImage") 
	void onEditCommentClick(ClickEvent e) {
		if (isUsers) {
			AddCommentTemplate addComm = new AddCommentTemplate(owner, myComment, mainPanel);
			mainPanel.getElement().setInnerHTML("");
			mainPanel.add(addComm);
		}
	}	


	@UiHandler("commentText")
	public void onHover(MouseOverEvent event) {
		if (isUsers) {
			closeImage.addStyleName("uiCloseButton");
			editImage.addStyleName("uiEditButton");
		}
	}

	@UiHandler("commentText")
	public void onHover(MouseOutEvent event) {
		if (isUsers) {
			closeImage.removeStyleName("uiCloseButton");
			editImage.removeStyleName("uiEditButton");
		}
	}
}
