package org.gcube.portlets.user.newsfeed.server;

import java.util.ArrayList;

import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.portal.databook.shared.Like;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class LikeNotificationsThread implements Runnable {
	private static final Logger _log = LoggerFactory.getLogger(LikeNotificationsThread.class);
	private String commentText;

	private NotificationsManager nm;
	private ArrayList<Like> likes;
	
	
	public LikeNotificationsThread(String commentText, NotificationsManager nm, ArrayList<Like> likes) {
		super();
		this.commentText = commentText;
		this.nm = nm;
		this.likes = likes;
	}

	@Override
	public void run() {
		for (Like fav : likes) {
			boolean result = nm.notifyCommentOnFavorite(fav.getUserid(), fav.getFeedid(), commentText);
			_log.trace("Sending Notification for favorited post comment added to: " + fav.getFullName() + " result?"+ result);
		}

	}
	
	
}
