/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.templates;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portal.databook.client.util.Encoder;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.newsfeed.client.event.AddLikeEvent;
import org.gcube.portlets.user.newsfeed.client.event.DeleteFeedEvent;
import org.gcube.portlets.user.newsfeed.client.event.OpenFeedEvent;
import org.gcube.portlets.user.newsfeed.client.event.SeeCommentsEvent;
import org.gcube.portlets.user.newsfeed.client.event.SeeLikesEvent;
import org.gcube.portlets.user.newsfeed.client.event.StopTimerEvent;
import org.gcube.portlets.user.newsfeed.client.templates.AddCommentTemplate;
import org.gcube.portlets.user.newsfeed.client.templates.LinkPreviewer;
import org.gcube.portlets.user.newsfeed.client.templates.SingleComment;
import org.gcube.portlets.user.newsfeed.client.templates.TweetTemplate;
import org.gcube.portlets.user.newsfeed.shared.EnhancedFeed;

public class TweetTemplate
extends Composite {
    private static TweetTemplateUiBinder uiBinder = (TweetTemplateUiBinder)GWT.create(TweetTemplateUiBinder.class);
    public static final String loading = GWT.getModuleBaseURL() + "../images/loading-comments.gif";
    private static final int MAX_SHOWTEXT_LENGTH = 256;
    private EnhancedFeed myFeed;
    private UserInfo myUserInfo;
    private HandlerManager eventBus;
    private ArrayList<SingleComment> myComments;
    private boolean commentingDisabled = false;
    private boolean commentsFetched = false;
    private int totalComments = 0;
    private HTML showAllComments = new HTML();
    private boolean isAppFeed = false;
    private boolean isUsers = false;
    @UiField
    HTML contentArea;
    @UiField
    HTML seeMore;
    @UiField
    HTML timeArea;
    @UiField
    HTML likeArea;
    @UiField
    HTML commentArea;
    @UiField
    HTML messageArea;
    @UiField
    Image avatarImage;
    @UiField
    HTMLPanel mainHTML;
    @UiField
    HTML likesNo;
    @UiField
    HTML commentsNo;
    @UiField
    VerticalPanel commentsPanel;
    @UiField
    HTML closeImage;
    @UiField
    HTML openImage;
    @UiField
    HTML vreSource;
    @UiField
    VerticalPanel previewPanel;
    @UiField
    Label messageSeparator;

    public TweetTemplate(boolean displaySingle, boolean showTimelineSource, UserInfo myUserInfo, EnhancedFeed myFeed, HandlerManager eventBus) {
        String vreName;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.myUserInfo = myUserInfo;
        this.vreSource.setVisible(false);
        this.myFeed = myFeed;
        this.isAppFeed = myFeed.getFeed().isApplicationFeed();
        Feed feed = myFeed.getFeed();
        if (feed.getUri() != null && feed.getUri().compareTo("") != 0 && feed.getLinkTitle() != null && feed.getLinkTitle().compareTo("") != 0) {
            this.previewPanel.add((Widget)new LinkPreviewer(feed.getLinkTitle(), feed.getLinkDescription(), feed.getLinkHost(), feed.getUriThumbnail(), feed.getUri()));
        }
        this.eventBus = eventBus;
        this.isUsers = myFeed.isUsers();
        this.myComments = new ArrayList();
        if (this.isUsers || myUserInfo.isAdmin()) {
            this.closeImage.setStyleName("closeImage");
            this.closeImage.setTitle(myUserInfo.isAdmin() ? "Delete (Administrator Mode)" : "delete");
        } else {
            this.closeImage.removeFromParent();
        }
        this.openImage.setStyleName("openImage");
        this.openImage.setTitle("Open this feed separately");
        if (myFeed.isLiked()) {
            this.likeArea.setHTML("Favorited");
        } else {
            this.likeArea.setHTML("<a>Favorite</a>");
        }
        this.commentArea.setHTML("<a>Reply</a>");
        String feedText = feed.getDescription();
        String descWithoutHTML = new HTML(feedText).getText();
        if (!feedText.startsWith("<span") && descWithoutHTML.length() > 256 && !displaySingle) {
            feedText = feedText.substring(0, 256) + "...";
            this.seeMore.setHTML("<a class=\"seemore\"> See More </a>");
        }
        if (!this.isAppFeed) {
            this.messageArea.setHTML("<a>Message</a>");
            this.contentArea.setHTML("<a class=\"link\" href=\"/group/data-e-infrastructure-gateway/profile?" + Encoder.encode((String)"userIdentificationParameter") + "=" + Encoder.encode((String)feed.getEntityId()) + "\">" + feed.getFullName() + "</a> " + feedText);
            if (showTimelineSource && feed.getVreid() != null && feed.getVreid().compareTo("") != 0) {
                this.vreSource.setVisible(true);
                vreName = feed.getVreid().substring(feed.getVreid().lastIndexOf("/") + 1);
                this.vreSource.setHTML("<a class=\"link\" style=\"font-size: 10px; white-space: nowrap;\" href=\"/group/" + vreName.toLowerCase() + "\">[" + vreName + "]</a>");
            }
        } else {
            this.contentArea.setHTML("<a class=\"link\" href=\"" + feed.getUri() + "\">" + feed.getFullName() + "</a> " + feedText);
            if (this.isAppFeed) {
                if (myUserInfo.isAdmin()) {
                    this.closeImage.setTitle("Delete this Application feed (Administrator Only)");
                } else {
                    this.closeImage.removeFromParent();
                }
                try {
                    vreName = feed.getVreid().substring(feed.getVreid().lastIndexOf("/") + 1);
                    this.messageArea.setHTML("<a class=\"link\" style=\"white-space: nowrap;\" href=\"" + feed.getUri() + "\"> go App [" + vreName + "]</a>");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.avatarImage.setUrl(feed.getThumbnailURL());
        this.avatarImage.setPixelSize(50, 50);
        try {
            String formattedTime = DateTimeFormat.getFormat((String)"MMMM dd, h:mm a").format(feed.getTime());
            this.timeArea.setHTML(formattedTime);
            if (!feed.getCommentsNo().equals("0")) {
                this.commentsNo.setHTML(feed.getCommentsNo());
                this.commentsNo.setStyleName("comments-number");
                this.commentsNo.setTitle("People commented this.");
            }
            if (!feed.getLikesNo().equals("0")) {
                this.likesNo.setHTML(feed.getLikesNo());
                this.likesNo.setStyleName("likes-number");
                this.likesNo.setTitle("Show People who have Favorited this.");
            }
            this.totalComments = Integer.parseInt(feed.getCommentsNo());
        }
        catch (NumberFormatException e) {
            this.totalComments = 0;
        }
        catch (Exception e) {
            this.timeArea.setHTML("just now");
        }
        this.commentsPanel.setStyleName("commentsPanel");
        if (myFeed.getComments() != null && myFeed.getComments().size() > 0) {
            if (this.totalComments > 2 && !displaySingle) {
                this.showAllComments = this.getShowAllCommentsLink(this.totalComments);
                this.commentsPanel.add((Widget)this.showAllComments);
                this.commentsNo.setStyleName("show-comments-number");
                this.commentsNo.setTitle("Show all Comments");
            }
            for (Comment comment : myFeed.getComments()) {
                this.addComment(new SingleComment(comment, this, comment.getUserid().equals(myUserInfo.getUsername())));
            }
        }
    }

    public TweetTemplate(UserInfo myUserInfo, EnhancedFeed feed, HandlerManager eventBus, boolean hidden) {
        this(false, false, myUserInfo, feed, eventBus);
        this.contentArea.getElement().getParentElement().getParentElement().setClassName("div-table-col content hidden");
    }

    @UiHandler(value={"contentArea"})
    public void onHover(MouseOutEvent event) {
        if (this.isUsers) {
            this.closeImage.removeStyleName("uiCloseButton");
        }
        this.openImage.removeStyleName("uiOpenButton");
    }

    @UiHandler(value={"contentArea"})
    public void onHover(MouseOverEvent event) {
        if (this.isUsers) {
            this.closeImage.addStyleName("uiCloseButton");
            GWT.log((String)"this belong to user");
        }
        this.openImage.addStyleName("uiOpenButton");
    }

    @UiHandler(value={"closeImage"})
    void onDeleteFeedClick(ClickEvent e) {
        if (this.isUsers || this.myUserInfo.isAdmin()) {
            this.eventBus.fireEvent((GwtEvent)new DeleteFeedEvent(this));
        } else {
            GWT.log((String)"not belong to user");
        }
    }

    @UiHandler(value={"openImage"})
    void onOpenFeedClick(ClickEvent e) {
        this.eventBus.fireEvent((GwtEvent)new OpenFeedEvent(this));
    }

    @UiHandler(value={"seeMore"})
    void onSeeMoreClick(ClickEvent e) {
        this.contentArea.setHTML("<a class=\"link\"href=\"/group/data-e-infrastructure-gateway/profile?" + Encoder.encode((String)"userIdentificationParameter") + "=" + Encoder.encode((String)this.myFeed.getFeed().getEntityId()) + "\">" + this.myFeed.getFeed().getFullName() + "</a> " + this.myFeed.getFeed().getDescription());
        this.seeMore.setHTML("");
    }

    @UiHandler(value={"likeArea"})
    void onLikeClick(ClickEvent e) {
        if (!this.likeArea.getText().equals("Favorited")) {
            try {
                this.eventBus.fireEvent((GwtEvent)new StopTimerEvent(true));
                int cur = Integer.parseInt(this.myFeed.getFeed().getLikesNo());
                if (++cur == 1) {
                    this.myFeed.getFeed().setLikesNo("1");
                    this.likesNo.setHTML("1");
                    this.likesNo.setStyleName("likes-number");
                    this.likesNo.setTitle("People who have Favorited this");
                } else {
                    this.myFeed.getFeed().setLikesNo("" + cur);
                    this.likesNo.setHTML("" + cur);
                }
                this.eventBus.fireEvent((GwtEvent)new AddLikeEvent(this, this.myFeed.getFeed().getKey()));
                this.likeArea.setHTML("Favorited");
            }
            catch (NumberFormatException ex) {
                this.likeArea.setHTML("Error on the server");
            }
        }
    }

    @UiHandler(value={"commentArea"})
    void onAddCommentClick(ClickEvent e) {
        if (!this.commentingDisabled) {
            if (!this.commentsFetched && this.totalComments > 2) {
                this.fireSeeComments(true);
            }
            this.showAddCommentForm();
            this.eventBus.fireEvent((GwtEvent)new StopTimerEvent(false));
        } else {
            GWT.log((String)"Commenting disabled");
        }
    }

    @UiHandler(value={"messageArea"})
    void onMessageClick(ClickEvent e) {
        if (!this.isAppFeed) {
            this.eventBus.fireEvent((GwtEvent)new StopTimerEvent(false));
            ArrayList<String> listToLogin = new ArrayList<String>();
            listToLogin.add(this.myFeed.getFeed().getEntityId());
            GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void showAddCommentForm() {
        AddCommentTemplate toAdd = new AddCommentTemplate(this, this.myUserInfo, this.eventBus);
        this.commentsPanel.add((Widget)toAdd);
        this.commentingDisabled = true;
        2 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(10);
    }

    private HTML getShowAllCommentsLink(int commentsNo) {
        HTML toReturn = new HTML("<div class=\"more-comment\"><a class=\"link\" style=\"font-size:11px;\">Show all " + commentsNo + " comments<a/></div>");
        toReturn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return toReturn;
    }

    private void fireSeeComments(boolean commentForm2Add) {
        this.eventBus.fireEvent((GwtEvent)new SeeCommentsEvent(this, commentForm2Add));
    }

    @UiHandler(value={"likesNo"})
    void onSeeLikes(ClickEvent e) {
        this.eventBus.fireEvent((GwtEvent)new SeeLikesEvent(this.myFeed.getFeed().getKey()));
    }

    @UiHandler(value={"commentsNo"})
    void onSeeComments(ClickEvent e) {
        this.fireSeeComments(false);
    }

    public void setcontentAreaStyle(String cssclass) {
        this.contentArea.getElement().getParentElement().getParentElement().setClassName("div-table-col content visible");
    }

    public boolean isCommenting() {
        return this.commentingDisabled;
    }

    public void setCommentingDisabled(boolean commenting) {
        this.commentingDisabled = commenting;
    }

    public String getFeedKey() {
        return this.myFeed.getFeed().getKey();
    }

    public void remove(Widget w) {
        this.mainHTML.remove(w);
    }

    public void addComment(SingleComment comment) {
        this.myComments.add(comment);
        this.commentsPanel.add((Widget)comment);
    }

    public void clearComments() {
        this.myComments.clear();
        this.commentsPanel.clear();
    }

    public void showLoadingComments() {
        this.showAllComments.setHTML("<div class=\"more-comment\"><img style=\"padding-right:15px;\"src=\"" + loading + "\" /></div>");
    }

    public boolean isCommentsFetched() {
        return this.commentsFetched;
    }

    public void setCommentsFetched(boolean commentsFetched) {
        this.commentsFetched = commentsFetched;
    }

    public HandlerManager getEventBus() {
        return this.eventBus;
    }

    public void updateCommentsNumberCount() {
        if (this.myComments.size() == 1) {
            this.commentsNo.setStyleName("comments-number");
            this.commentsNo.setTitle("Persons who have commented this.");
        }
        this.commentsNo.setHTML("" + this.myComments.size());
    }

    public UserInfo getMyUserInfo() {
        return this.myUserInfo;
    }

    public String getMyFeedUserId() {
        return this.myFeed.getFeed().getEntityId();
    }

    public String getMyFeedText() {
        return this.myFeed.getFeed().getDescription();
    }

    public boolean isAppFeed() {
        return this.isAppFeed;
    }

    static /* synthetic */ void access$000(TweetTemplate x0, boolean x1) {
        x0.fireSeeComments(x1);
    }
}

