/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TextArea;
import java.util.ArrayList;
import org.gcube.portlets.user.gcubewidgets.client.elements.Div;
import org.gcube.portlets.user.newsfeed.client.NewsService;
import org.gcube.portlets.user.newsfeed.client.NewsServiceAsync;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;
import org.gcube.portlets.user.newsfeed.client.ui.SuperPosedTextArea;
import org.gcube.portlets.widgets.pickitem.client.dialog.PickItemsDialog;
import org.gcube.portlets.widgets.pickitem.client.events.PickedItemEvent;

public class SuperPosedTextArea
extends TextArea {
    private final NewsServiceAsync newsService = (NewsServiceAsync)GWT.create(NewsService.class);
    private final HandlerManager eventBus = new HandlerManager(null);
    private PickItemsDialog pickUserDlg;
    private Div highlighterDIV;
    public static final int ARROW_UP = 38;
    public static final int ARROW_DOWN = 40;
    private ArrayList<String> mentionedUsers = new ArrayList();
    private String areaId;

    public SuperPosedTextArea(Div highlighterDIV) {
        this.sinkEvents(524288);
        this.sinkEvents(512);
        this.sinkEvents(262144);
        this.sinkEvents(128);
        this.setText("Write a comment, use @ to mention someone");
        this.highlighterDIV = highlighterDIV;
        this.areaId = "postTextArea" + Random.nextInt();
        this.newsService.getOrganizationUsers(NewsFeedPanel.getCurrentScope(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        DOM.setElementAttribute((Element)this.getElement(), (String)"id", (String)this.areaId);
        this.bind();
        2 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(200);
    }

    public static native void myAutoSize(String var0);

    public SuperPosedTextArea(com.google.gwt.dom.client.Element element) {
        super(element);
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        switch (event.getTypeInt()) {
            case 524288: {
                if (!this.getText().equals("Write a comment, use @ to mention someone") && !this.getText().equals("Looks like empty to me!")) break;
                this.setText("");
                this.addStyleName("dark-color");
                this.removeStyleName("error");
                break;
            }
            case 512: {
                this.injectInDiv(this.getText());
                this.pickUserDlg.onKeyUp(event.getKeyCode(), this.getAbsoluteLeft(), this.getAbsoluteTop() + this.getOffsetHeight(), this.getText());
                break;
            }
            case 262144: {
                this.removeSampleText();
                break;
            }
            case 128: {
                if (!this.pickUserDlg.isShowing() || event.getKeyCode() != 38 && event.getKeyCode() != 9 && event.getKeyCode() != 13) break;
                DOM.eventCancelBubble((Event)event, (boolean)true);
                DOM.eventPreventDefault((Event)event);
                return;
            }
        }
    }

    protected void removeSampleText() {
        if (this.getText().equals("Write a comment, use @ to mention someone") || this.getText().equals("Looks like empty to me!")) {
            this.setText("");
            this.addStyleName("darker-color");
            this.removeStyleName("error");
        }
    }

    protected void cleanHighlighterDiv() {
        this.highlighterDIV.getElement().setInnerHTML("");
    }

    private void injectInDiv(String textAreaText) {
        String text = textAreaText.replaceAll("(\r\n|\n)", "<br />");
        text = text.replaceAll("\\s\\s", "&nbsp;&nbsp;");
        for (String mentionedUser : this.mentionedUsers) {
            text = text.replaceAll(mentionedUser, "<span class=\"highlightedUser\">" + mentionedUser + "</span>");
        }
        this.highlighterDIV.getElement().setInnerHTML(text);
    }

    private void bind() {
        this.eventBus.addHandler(PickedItemEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ArrayList<String> getMentionedUsers() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (String mentionedUser : this.mentionedUsers) {
            if (!this.getText().contains(mentionedUser)) continue;
            toReturn.add(mentionedUser);
        }
        GWT.log((String)toReturn.toString());
        return this.mentionedUsers;
    }

    public String getAreaId() {
        return this.areaId;
    }

    static /* synthetic */ PickItemsDialog access$002(SuperPosedTextArea x0, PickItemsDialog x1) {
        x0.pickUserDlg = x1;
        return x0.pickUserDlg;
    }

    static /* synthetic */ HandlerManager access$100(SuperPosedTextArea x0) {
        return x0.eventBus;
    }

    static /* synthetic */ String access$200(SuperPosedTextArea x0) {
        return x0.areaId;
    }

    static /* synthetic */ ArrayList access$300(SuperPosedTextArea x0) {
        return x0.mentionedUsers;
    }

    static /* synthetic */ Div access$400(SuperPosedTextArea x0) {
        return x0.highlighterDIV;
    }
}

