/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.server;

import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portlets.widgets.pickitem.shared.ItemBean;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final Logger _log = LoggerFactory.getLogger(Utils.class);

    public static ArrayList<ItemBean> getOrganizationUsers(String scope, String currUser, boolean withinPortal) {
        ArrayList<ItemBean> portalUsers = new ArrayList<ItemBean>();
        try {
            if (withinPortal) {
                LiferayUserManager um = new LiferayUserManager();
                LiferayGroupManager gm = new LiferayGroupManager();
                ScopeBean sb = new ScopeBean(scope);
                List users = null;
                if (sb.is(ScopeBean.Type.INFRASTRUCTURE)) {
                    users = um.listUsersByGroup(gm.getRootVO().getGroupId());
                } else if (sb.is(ScopeBean.Type.VRE)) {
                    String orgName = scope.substring(scope.lastIndexOf("/") + 1, scope.length());
                    users = um.listUsersByGroup(gm.getGroupId(orgName));
                } else {
                    _log.error("Error, you must be in SCOPE VRE OR INFRASTURCTURE, you are in VO SCOPE returning no users");
                    return portalUsers;
                }
                for (UserModel user : users) {
                    if (user.getScreenName().compareTo("test.user") == 0 || user.getScreenName().compareTo(currUser) == 0) continue;
                    String thumbnailURL = "";
                    User lifeUser = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)user.getScreenName());
                    thumbnailURL = "/image/user_male_portrait?img_id=" + lifeUser.getPortraitId();
                    portalUsers.add(new ItemBean(user.getUserId(), user.getScreenName(), user.getFullname(), thumbnailURL));
                }
            } else {
                portalUsers.add(new ItemBean("12111", "massimiliano.assante", "Test User #1", ""));
                portalUsers.add(new ItemBean("14111", "massimiliano.assante", "Test Second User #2", ""));
                portalUsers.add(new ItemBean("11511", "massimiliano.assante", "Test Third User", ""));
                portalUsers.add(new ItemBean("11611", "massimiliano.assante", "Test Fourth User", ""));
                portalUsers.add(new ItemBean("11711", "massimiliano.assante", "Test Fifth User", ""));
                portalUsers.add(new ItemBean("11811", "massimiliano.assante", "Test Sixth User", ""));
                portalUsers.add(new ItemBean("15811", "massimiliano.assante", "Ninth Testing User", ""));
                portalUsers.add(new ItemBean("15811", "massimiliano.assante", "Eighth Testing User", ""));
                portalUsers.add(new ItemBean("11211", "giogio.giorgi", "Seventh Test User", ""));
                portalUsers.add(new ItemBean("2222", "pino.pinetti", "Tenth Testing User", ""));
            }
        }
        catch (Exception e) {
            _log.error("Error in server get all contacts ", (Throwable)e);
        }
        return portalUsers;
    }

    protected static List<String> getHashTags(String postText) {
        ArrayList<String> hashtags = new ArrayList<String>();
        Pattern MY_PATTERN = Pattern.compile("#(\\w+)");
        Matcher matcher = MY_PATTERN.matcher(postText);
        while (matcher.find()) {
            hashtags.add("#" + matcher.group(1));
        }
        return hashtags;
    }

    protected static String escapeHtmlAndTransformUrl(String html) {
        if (html == null) {
            return null;
        }
        String toReturn = html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        toReturn = toReturn.replaceAll("(\r\n|\n)", " <br/> ");
        toReturn = Utils.transformUrls((String)toReturn);
        toReturn = toReturn.replaceAll("\\s\\s", "&nbsp;&nbsp;");
        return toReturn;
    }

    protected static String transformUrls(String feedText) {
        StringBuilder sb = new StringBuilder();
        String[] parts = feedText.split("\\s");
        int i = 0;
        while (i < parts.length) {
            String toCheck = Utils.getHttpToken((String)parts[i]);
            if (toCheck != null) {
                try {
                    URL url = new URL(toCheck);
                    if (i == 0 && parts.length == 1) {
                        return sb.append("<span style=\"color:gray; font-size:12px;\">shared </span><a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append("a link.").append("</a> ").toString();
                    }
                    sb.append("<a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append(url).append("</a> ");
                }
                catch (MalformedURLException e) {
                    _log.error("MalformedURLException returning... ");
                    return feedText;
                }
            } else {
                sb.append(parts[i]);
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String convertMentionPeopleAnchorHTML(String escapedFeedText, ArrayList<ItemBean> taggedPeople) {
        for (ItemBean tagged : taggedPeople) {
            String taggedHTML = "<a class=\"link\" href=\"/group/data-e-infrastructure-gateway/profile?" + new String(Base64.encodeBase64((byte[])"userIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])tagged.getName().getBytes())) + "\">" + tagged.getAlternativeName() + "</a> ";
            escapedFeedText = escapedFeedText.replace(tagged.getAlternativeName(), taggedHTML);
        }
        return escapedFeedText;
    }

    private static String getHttpToken(String item) {
        if (item.startsWith("http") || item.startsWith("www") || item.startsWith("(www") || item.startsWith("(http")) {
            if (item.startsWith("(")) {
                item = item.substring(1, item.length());
            }
            if (item.endsWith(".") || item.endsWith(")")) {
                item = item.substring(0, item.length() - 1);
            }
            item = item.startsWith("www") ? "http://" + item : item;
            return item;
        }
        return null;
    }
}

