/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.newsfeed.client.ui.LinkPreviewer;
import org.gcube.portlets.widgets.imagepreviewerwidget.client.ui.Carousel;

public class LinkPreviewer
extends Composite {
    private boolean imageRemoved = false;
    @UiField
    HTML titleArea;
    @UiField
    HTML urlText;
    @UiField
    HTML descText;
    @UiField
    Image image;
    private final String fileName;
    private static LinkPreviewUiBinder uiBinder = (LinkPreviewUiBinder)GWT.create(LinkPreviewUiBinder.class);

    public LinkPreviewer(String title, String titleDesc, String host, String linkThumbUrl, String url) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (linkThumbUrl == null || linkThumbUrl.equals("null")) {
            this.image.removeFromParent();
            this.imageRemoved = true;
        } else {
            this.image.setUrl(linkThumbUrl);
            this.image.setWidth("80px");
        }
        this.fileName = title;
        this.titleArea.setHTML("<a class=\"link\" target=\"_blank\" href=\"" + url + "\">" + title + "</a> <span style=\"color: #333;\"> - " + host + "</span>");
        this.urlText.setHTML(url.length() > 70 ? String.valueOf(url.substring(0, 70)) + "..." : url);
        String desc = titleDesc;
        this.descText.setHTML(desc.length() > 256 ? String.valueOf(desc.substring(0, 256)) + "..." : desc);
    }

    public void onImageClickOpenCarousel(Carousel carousel) {
        if (this.imageRemoved) {
            return;
        }
        this.image.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.image.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onFileNameClickOpenCarousel(Carousel carousel) {
        String nameToShow = this.fileName.length() > 40 ? String.valueOf(this.fileName.substring(0, 40)) + "..." : this.fileName;
        this.titleArea.setHTML("<a class=\"link\" >" + nameToShow + "</a>");
        this.titleArea.setTitle(this.fileName);
        this.titleArea.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }
}

