/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.ui;

import com.github.gwtbootstrap.client.ui.Dropdown;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.newsfeed.client.FilterType;
import org.gcube.portlets.user.newsfeed.client.NewsServiceAsync;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;
import org.gcube.portlets.user.newsfeed.client.ui.FilterPanel;

public class FilterPanel
extends Composite {
    private static FilterPanelUiBinder uiBinder = (FilterPanelUiBinder)GWT.create(FilterPanelUiBinder.class);
    protected static final String ERROR_MESSAGE = "Ops! we encountered some problems, server is not responding, please try again in a short while.";
    protected static final String SESSION_EXPIRED = "Your session has expired, please log out and login again";
    NewsFeedPanel caller;
    NewsServiceAsync service;
    @UiField
    NavLink allUpdatesLink;
    @UiField
    NavLink recentCommentsLink;
    @UiField
    Dropdown sortByDD;

    public FilterPanel(NewsFeedPanel caller, NewsServiceAsync newsService) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.caller = caller;
        this.service = newsService;
    }

    public void removeFilterSelected() {
        this.allUpdatesLink.setActive(false);
        this.recentCommentsLink.setActive(false);
    }

    @UiHandler(value={"recentCommentsLink"})
    void onRecentCommentsLinkClick(ClickEvent e) {
        this.allUpdatesLink.setDisabled(false);
        this.recentCommentsLink.setDisabled(true);
        this.sortByDD.setText("newest Comment");
        this.caller.setCurrentFilter(FilterType.RECENT_COMMENTS);
        int loadedPostsInView = this.caller.getAllUpdatesSize() + 1;
        int quantity = loadedPostsInView < 100 ? 100 - loadedPostsInView : loadedPostsInView;
        this.caller.loadMorePosts(quantity, true);
    }

    @UiHandler(value={"allUpdatesLink"})
    void onAllUpdatesClick(ClickEvent e) {
        this.allUpdatesLink.setDisabled(true);
        this.recentCommentsLink.setDisabled(false);
        this.sortByDD.setText("newest \tPost");
        this.caller.setCurrentFilter(FilterType.ALL_UPDATES);
        this.service.getUserSettings((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

