/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.notifications.client.view.templates;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.query.client.GQuery;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portlets.user.gcubewidgets.client.elements.Span;
import org.gcube.portlets.user.notifications.client.view.templates.NotificationPreferenceView;
import org.gcube.portlets.user.notifications.shared.NotificationPreference;
import org.gcube.portlets.widgets.switchbutton.client.SwitchButton;

public class NotificationPreferenceView
extends Composite {
    private static NotificationPreferenceUiBinder uiBinder = (NotificationPreferenceUiBinder)GWT.create(NotificationPreferenceUiBinder.class);
    @UiField
    Span prefType;
    @UiField
    Span prefDesc;
    @UiField
    CheckBox portalCheckbox;
    @UiField
    CheckBox emailCheckbox;
    @UiField
    SwitchButton switchButton;
    NotificationPreference myPreference;

    public NotificationPreferenceView(NotificationPreference toDisplay) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.myPreference = toDisplay;
        this.updateViewValues(toDisplay);
        this.prefType.setHTML(toDisplay.getTypeLabel());
        this.prefDesc.setHTML(toDisplay.getTypeDesc());
        this.switchButton.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateViewValues(NotificationPreference setting) {
        NotificationChannelType[] currChannels = setting.getSelectedChannels();
        if (currChannels == null || currChannels.length == 0) {
            this.setCheckBoxValue(this.portalCheckbox, false);
            this.setCheckBoxValue(this.portalCheckbox, false);
        } else {
            int i = 0;
            while (i < currChannels.length) {
                if (currChannels[i] == NotificationChannelType.PORTAL) {
                    this.setCheckBoxValue(this.portalCheckbox, true);
                }
                if (currChannels[i] == NotificationChannelType.EMAIL) {
                    this.setCheckBoxValue(this.emailCheckbox, true);
                }
                ++i;
            }
        }
        boolean overAll = this.portalCheckbox.getValue() != false || this.emailCheckbox.getValue() != false;
        this.switchButton.setValue(Boolean.valueOf(overAll));
        if (!overAll) {
            GQuery.$((Object)this.portalCheckbox).fadeOut(300, new Function[0]);
            GQuery.$((Object)this.emailCheckbox).fadeOut(300, new Function[0]);
        }
    }

    private void setCheckBoxValue(CheckBox toSet, boolean value) {
        toSet.setValue(Boolean.valueOf(value));
    }

    public NotificationType getNotificationType() {
        return this.myPreference.getType();
    }

    public NotificationChannelType[] getSelectedChannels() {
        if (this.switchButton.getValue().booleanValue()) {
            ArrayList<NotificationChannelType> toReturn = new ArrayList<NotificationChannelType>();
            if (this.portalCheckbox.getValue().booleanValue()) {
                toReturn.add(NotificationChannelType.PORTAL);
            }
            if (this.emailCheckbox.getValue().booleanValue()) {
                toReturn.add(NotificationChannelType.EMAIL);
            }
            return toReturn.toArray(new NotificationChannelType[toReturn.size()]);
        }
        return new NotificationChannelType[0];
    }

    public void setPortalPrefValue(boolean value) {
        this.setCheckBoxValue(this.portalCheckbox, value);
    }

    public void setEmailPrefValue(boolean value) {
        this.setCheckBoxValue(this.emailCheckbox, value);
    }

    static /* synthetic */ void access$0(NotificationPreferenceView notificationPreferenceView, CheckBox checkBox, boolean bl) {
        notificationPreferenceView.setCheckBoxValue(checkBox, bl);
    }
}

