/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.event;

import com.google.gwt.event.shared.GwtEvent;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class ImportOccurrencesEvent extends GwtEvent<ImportOccurrencesEventHandler> {
	
	public static final GwtEvent.Type<ImportOccurrencesEventHandler> TYPE = new Type<ImportOccurrencesEventHandler>();
	private String workspaceItemId;
	private String listOccurrencesName;
	private String description;

	@Override
	public Type<ImportOccurrencesEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(ImportOccurrencesEventHandler handler) {
		handler.onImportOccurrences(this);	
	}
	
	public ImportOccurrencesEvent(String workspaceItemId, String listOccurrencesName, String description) {
		this.workspaceItemId = workspaceItemId;
		this.listOccurrencesName = listOccurrencesName;
		this.description = description;
	}

	public String getWorkspaceItemId() {
		return workspaceItemId;
	}

	public String getListOccurrencesName() {
		return listOccurrencesName;
	}

	public String getDescription() {
		return description;
	}
}
