/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical.form;

import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.FileParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;

import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.ui.Widget;


/**
 * @author ceras
 *
 */
public class FileField extends AbstractField {

	TextField<String> textField = new TextField<String>();
	
	/**
	 * @param parameter
	 */
	public FileField(Parameter parameter) {
		super(parameter);

		FileParameter p = (FileParameter)parameter;
		if (p.getDescription()!=null)
			textField.setTitle(p.getDescription());
		textField.setFieldLabel(p.getName());
		textField.setValue(p.getDefaultValue());
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#getValue()
	 */
	@Override
	public String getValue() {
		return textField.getValue();
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#getComponent()
	 */
	@Override
	public Widget getWidget() {
		return textField;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#isValid()
	 */
	@Override
	public boolean isValid() {
		return false;
	}

}
