/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.AlgorithmParameter;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalComputation;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalFeature;
import org.gcube.data.harmonization.occurrence.impl.model.types.DataType;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementService;
import org.gcube.portlets.user.occurrencemanagement.server.OccurrenceManagementServiceImpl;
import org.gcube.portlets.user.occurrencemanagement.server.service.GxtReconciliationServiceConverter;
import org.gcube.portlets.user.occurrencemanagement.server.service.ReconciliationService;
import org.gcube.portlets.user.occurrencemanagement.server.tabular.OccurrenceManagementDataSourceFactory;
import org.gcube.portlets.user.occurrencemanagement.server.util.SessionUtil;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.EnumParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ObjectParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.OperatorCategory;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.TabularParameter;
import org.gcube.portlets.user.tdw.server.datasource.DataSourceFactory;
import org.gcube.portlets.user.tdw.server.datasource.DataSourceFactoryRegistry;

public class OccurrenceManagementServiceImpl
extends RemoteServiceServlet
implements OccurrenceManagementService {
    public static Logger logger = Logger.getLogger(OccurrenceManagementServiceImpl.class);
    private static final String SEPARATOR = AlgorithmConfiguration.getListSeparator();

    protected ASLSession getASLSession() {
        return SessionUtil.getAslSession((HttpSession)this.getThreadLocalRequest().getSession());
    }

    public void init() throws ServletException {
        super.init();
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Error initializing the db", (Throwable)e);
        }
        DataSourceFactoryRegistry.getInstance().add((DataSourceFactory)new OccurrenceManagementDataSourceFactory());
    }

    public List<JobOccurrencesModel> getListOccurrencesSet(ElaborationType elaborationType, boolean onlyNotCompleted) throws Exception {
        logger.trace((Object)("Get List Occurrences type: " + elaborationType + " onlyNotCompleted: " + onlyNotCompleted));
        System.out.println("Get List Occurrences type: " + elaborationType + " onlyNotCompleted." + onlyNotCompleted);
        ArrayList listJob = new ArrayList();
        try {
            ReconciliationService reconciliationService = SessionUtil.getService((ASLSession)this.getASLSession());
            switch (1.$SwitchMap$org$gcube$portlets$user$occurrencemanagement$shared$ElaborationType[elaborationType.ordinal()]) {
                case 1: {
                    listJob = GxtReconciliationServiceConverter.getImportRequestOccurrencesJob((List)reconciliationService.getDataList(), (boolean)onlyNotCompleted);
                    break;
                }
                case 2: {
                    listJob = GxtReconciliationServiceConverter.getSubmittedOperationOccurrencesJob((List)reconciliationService.getSubmittedOperationList(), (boolean)onlyNotCompleted);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace((Object)e);
            logger.error((Object)("Error on get list occurrences " + e.getMessage()));
            throw new Exception("Error on get list occurrences");
        }
        return listJob;
    }

    public void initServervice() throws Exception {
        try {
            SessionUtil.getService((ASLSession)this.getASLSession());
            SessionUtil.getCsvImportServer((ASLSession)this.getASLSession());
        }
        catch (Exception e) {
            throw new Exception("Error initializing the csv import", e);
        }
    }

    public List<Operator> getListOperator() throws Exception {
        this.initServervice();
        ArrayList<Operator> listOperator = new ArrayList<Operator>();
        try {
            ReconciliationService reconciliationService = SessionUtil.getService((ASLSession)this.getASLSession());
            logger.trace((Object)"Get operators...");
            List listFeatures = reconciliationService.getCapabilities();
            for (StatisticalFeature statisticalFeature : listFeatures) {
                Operator operator = new Operator();
                StatisticalComputation computation = statisticalFeature.getComputation();
                operator.setId(computation.getAlgorithm());
                operator.setName(computation.getAlgorithm());
                operator.setDescription(computation.getDescription());
                OperatorCategory category = new OperatorCategory(computation.getCategory(), "", "");
                operator.setCategory(category);
                List listParameter = statisticalFeature.getParameters();
                ArrayList<Object> operatorParameters = new ArrayList<Object>();
                for (AlgorithmParameter algorithmParameter : listParameter) {
                    DataType smType = algorithmParameter.getType();
                    String paramName = algorithmParameter.getName();
                    String paramDescription = algorithmParameter.getDescription();
                    String defaultValue = algorithmParameter.getDefaultValue();
                    switch (1.$SwitchMap$org$gcube$data$harmonization$occurrence$impl$model$types$DataType$Type[algorithmParameter.getType().getType().ordinal()]) {
                        case 1: {
                            TabularParameter tabularParam = new TabularParameter(paramName, paramDescription);
                            for (String value : smType.getValue()) {
                                tabularParam.addTemplate(value);
                            }
                            operatorParameters.add(tabularParam);
                            break;
                        }
                        case 2: {
                            String objectType = (String)smType.getValue().get(0);
                            ObjectParameter objectParam = new ObjectParameter(paramName, paramDescription, objectType, defaultValue);
                            operatorParameters.add(objectParam);
                            break;
                        }
                        case 3: {
                            List values = smType.getValue();
                            EnumParameter enumParam = new EnumParameter(paramName, paramDescription, values, defaultValue);
                            operatorParameters.add(enumParam);
                            break;
                        }
                        case 4: {
                            String listType = (String)smType.getValue().get(0);
                            ListParameter listParam = new ListParameter(paramName, paramDescription, listType, SEPARATOR);
                            operatorParameters.add(listParam);
                            break;
                        }
                        case 5: {
                            String referredTabularParameterName = (String)smType.getValue().get(0);
                            ColumnParameter columnParam = new ColumnParameter(paramName, paramDescription, referredTabularParameterName, defaultValue);
                            operatorParameters.add(columnParam);
                            break;
                        }
                        case 6: {
                            String referredTabular = (String)smType.getValue().get(0);
                            ColumnListParameter columnListParameter = new ColumnListParameter(paramName, paramDescription, referredTabular, SEPARATOR);
                            operatorParameters.add(columnListParameter);
                        }
                    }
                    operator.setOperatorParameters(operatorParameters);
                }
                listOperator.add(operator);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in getListOperator: ", (Throwable)e);
            throw new Exception("Error in getListOperator");
        }
        return listOperator;
    }

    public String startComputation(Operator operator, String computationTitle, String computationDescription) throws Exception {
        System.out.println("startComputation...");
        System.out.println("Operator: " + operator);
        System.out.println("Category: " + operator.getCategory());
        logger.trace((Object)"startComputation...");
        logger.trace((Object)("Operator: " + operator));
        try {
            ReconciliationService reconciliationService = SessionUtil.getService((ASLSession)this.getASLSession());
            HashMap<String, String> hash = new HashMap<String, String>();
            for (Parameter parameter : operator.getOperatorParameters()) {
                System.out.println("Parameter : " + parameter.getName() + "   value: " + parameter.getValue());
                logger.trace((Object)("Parameter:  " + parameter.getName() + "   value: " + parameter.getValue()));
                hash.put(parameter.getName(), parameter.getValue());
            }
            StatisticalComputation stat = new StatisticalComputation(operator.getId(), operator.getDescription(), operator.getCategory().getId());
            logger.trace((Object)"submit operatiorn...");
            reconciliationService.submitOperation(stat, hash, computationTitle, computationDescription);
            logger.trace((Object)"submit return");
            return "OK";
        }
        catch (Exception e) {
            logger.error((Object)"Error in startComputation ", (Throwable)e);
            throw new Exception("Error in startComputation");
        }
    }

    public Boolean saveSelectedOccurrencePoints(String resourceId, ElaborationType elaborationType, String destinationFolderId, String fileName) throws Exception {
        logger.trace((Object)("saveSelectedOccurrencePoints resourceId " + resourceId + " destinationFolderId: " + destinationFolderId + " fileName: " + fileName));
        System.out.println("saveSelectedOccurrencePoints resourceId " + resourceId + " destinationFolderId: " + destinationFolderId + " fileName: " + fileName);
        File file = null;
        String mimeType = "text/csv";
        try {
            ReconciliationService reconciliationService = SessionUtil.getService((ASLSession)this.getASLSession());
            file = reconciliationService.getResourceAsFile(resourceId, GxtReconciliationServiceConverter.convertToOperationType((ElaborationType)elaborationType));
            logger.trace((Object)("tmp file: " + file.getAbsolutePath()));
            System.out.println("tmp file: " + file.getAbsolutePath());
            ASLSession session = this.getASLSession();
            ScopeProvider.instance.set(session.getScope().toString());
            Workspace workspace = HomeLibrary.getUserWorkspace((String)session.getUsername());
            WorkspaceFolder folder = (WorkspaceFolder)workspace.getItem(destinationFolderId);
            fileName = WorkspaceUtil.getUniqueName((String)fileName, (WorkspaceFolder)folder);
            folder.createExternalFileItem(fileName, "Occurrence points generated files", mimeType, (InputStream)new FileInputStream(file));
            file.delete();
            logger.trace((Object)"Save complete");
            System.out.println("Save complete");
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred saving the generated file into the workspace", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public void deleteResourceById(String resourceId) throws Exception {
        logger.trace((Object)("deleteResourceById resourceId " + resourceId));
        System.out.println("deleteResourceById resourceId " + resourceId);
        try {
            ReconciliationService reconciliationService = SessionUtil.getService((ASLSession)this.getASLSession());
            reconciliationService.deleteResourceById(resourceId);
            logger.trace((Object)("delete resourceId " + resourceId + " OK"));
            System.out.println("delete resourceId " + resourceId + " OK");
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred deleting occurrence", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }
}

