/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.server.service;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.harmonization.occurrence.OccurrenceStreamer;
import org.gcube.data.harmonization.occurrence.Reconciliation;
import org.gcube.data.harmonization.occurrence.impl.ReconciliationImpl;
import org.gcube.data.harmonization.occurrence.impl.model.Computation;
import org.gcube.data.harmonization.occurrence.impl.model.PagedRequestSettings;
import org.gcube.data.harmonization.occurrence.impl.model.Resource;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalComputation;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalFeature;
import org.gcube.data.harmonization.occurrence.impl.model.types.OperationType;
import org.gcube.data.harmonization.occurrence.impl.readers.ParserConfiguration;

public class ReconciliationService {
    private Reconciliation reconciliation;
    private String scope;
    private String username;
    private URI host = URI.create("http://dbtest.next.research-infrastructures.eu:8888");
    public static Logger logger = Logger.getLogger(ReconciliationService.class);

    public ReconciliationService(String scope, ASLSession session) throws Exception {
        try {
            this.scope = scope;
            this.username = session.getUsername();
            ScopeProvider.instance.set(scope.toString());
            logger.trace((Object)"Create ReconciliationService");
            this.reconciliation = new ReconciliationImpl(this.username);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Error on create ReconciliationService " + e.getMessage()));
            throw new Exception("Error on on create ReconciliationService");
        }
    }

    public List<Resource> getDataList() throws Exception {
        return this.reconciliation.getDataSets();
    }

    public List<StatisticalFeature> getCapabilities() throws Exception {
        return this.reconciliation.getCapabilities();
    }

    public void closeConnection() throws Exception {
        this.reconciliation.closeTableConnection();
    }

    public List<Computation> getSubmittedOperationList() throws Exception {
        return this.reconciliation.getSubmittedOperationList();
    }

    public void submitOperation(StatisticalComputation stat, Map<String, String> map, String name, String description) throws Exception {
        this.reconciliation.submitOperation(stat, map, name, description);
    }

    public List<String> openTableInspectionById(String id) throws Exception {
        return this.reconciliation.openTableInspection(id);
    }

    public String getJSONImported(PagedRequestSettings pagedRequestSettings) throws Exception {
        return this.reconciliation.getJSONImported(pagedRequestSettings);
    }

    public String getUrlFromTableId(String tableId) throws Exception {
        return this.reconciliation.getTableUrl(tableId);
    }

    public OccurrenceStreamer importOccurrences(File csvFile, ParserConfiguration parserConfiguration, String fileName, String fileDescription) throws Exception {
        return this.reconciliation.getStreamer(csvFile, parserConfiguration, fileName, fileDescription);
    }

    public File getResourceAsFile(String resourceId, OperationType operationType) throws Exception {
        return this.reconciliation.getResourceAsFile(resourceId, operationType);
    }

    public void deleteResourceById(String resourceId) throws Exception {
        this.reconciliation.removeComputationById(resourceId);
    }
}

