/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.OperatorCategory;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;

public class Operator
implements IsSerializable {
    private String id;
    private String name;
    private String briefDescription;
    private String description;
    private OperatorCategory category;
    private List<Parameter> operatorParameters = new ArrayList();
    private boolean hasImage = false;

    public Operator() {
    }

    public Operator(String id, String briefDescription, String description, OperatorCategory category) {
        this.id = id;
        this.setNameFromId();
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
    }

    public Operator(String id, String briefDescription, String description, OperatorCategory category, boolean hasImage) {
        this.id = id;
        this.setNameFromId();
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
        this.hasImage = hasImage;
    }

    public Operator(String id, String name, String briefDescription, String description, OperatorCategory category) {
        this.id = id;
        this.name = name;
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
    }

    public Operator(String id, String briefDescription, String description, OperatorCategory category, List<Parameter> operatorParameters) {
        this.id = id;
        this.setNameFromId();
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
        this.operatorParameters = operatorParameters;
    }

    public Operator(String id, String name, String briefDescription, String description, OperatorCategory category, List<Parameter> operatorParameters) {
        this.id = id;
        this.name = name;
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
        this.operatorParameters = operatorParameters;
    }

    public Operator(String id, String name, String briefDescription, String description, OperatorCategory category, List<Parameter> operatorParameters, boolean hasImage) {
        this.id = id;
        this.name = name;
        this.briefDescription = briefDescription;
        this.description = description;
        this.category = category;
        this.operatorParameters = operatorParameters;
        this.hasImage = hasImage;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OperatorCategory getCategory() {
        return this.category;
    }

    public void setCategory(OperatorCategory category) {
        this.category = category;
    }

    public List<Parameter> getOperatorParameters() {
        return this.operatorParameters;
    }

    public void setOperatorParameters(List<Parameter> operatorParameters) {
        this.operatorParameters = operatorParameters;
    }

    public void addOperatorParameter(Parameter operatorParameter) {
        this.operatorParameters.add(operatorParameter);
    }

    private void setNameFromId() {
        if (this.id != null) {
            String name = "";
            boolean precUnderscore = true;
            for (int i = 0; i < this.id.length(); ++i) {
                char c = this.id.charAt(i);
                if (c == '_') {
                    precUnderscore = true;
                    name = name + " ";
                    continue;
                }
                name = name + (precUnderscore ? Character.toUpperCase(c) : Character.toLowerCase(c));
                if (!precUnderscore) continue;
                precUnderscore = false;
            }
            this.name = name;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasImage() {
        return this.hasImage;
    }

    public void setHasImage(boolean hasImage) {
        this.hasImage = hasImage;
    }

    public Operator clone() {
        return new Operator(this.id, this.name, this.briefDescription, this.description, this.category, new ArrayList(this.operatorParameters), this.hasImage);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Operator [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", briefDescription=");
        builder.append(this.briefDescription);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", category=");
        builder.append(this.category);
        builder.append(", operatorParameters=");
        builder.append(this.operatorParameters);
        builder.append(", hasImage=");
        builder.append(this.hasImage);
        builder.append("]");
        return builder.toString();
    }
}

