package org.gcube.portlets.user.opengcubeapplication;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.opengcubeapplication.exception.GetUrlFromApplicationProfileException;
import org.gcube.portlets.user.opengcubeapplication.reader.GcubeApplicationReader;
import org.gcube.portlets.user.opengcubeapplication.util.GenericResourcePropertyReader;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class ApplicationReaderFromGenericResource {
	
	protected GCUBELog logger = new GCUBELog(ApplicationReaderFromGenericResource.class);

	public ApplicationReaderFromGenericResource(){
		
	}

	/**
	 * 
	 * @param oid - the oid of the workspace item that must be opened
	 * @param session - the asl session
	 * @param httpSession - the current httpsession
	 * @return
	 * @throws GetUrlFromApplicationProfileException
	 */
	public String getURLFromApplicationProfile(String oid, ASLSession session, HttpSession httpSession) throws GetUrlFromApplicationProfileException {

		String url = "";

		try {

			logger.trace("get URL for item id: " + oid);

			// GET WORKSPACE
			Workspace workspace = HomeLibrary.getUserWorkspace(session);

			// GET ITEM FROM WORKSPACE
			WorkspaceItem item = workspace.getItem(oid);

			// ITEM IS A WorkspaceItemType.FOLDER_ITEM?
			if (item.getType().equals(WorkspaceItemType.FOLDER_ITEM)) {

				GCUBEScope scope = item.getOwner().getScope(); // retrieve user scope
				
				logger.trace("item id has scope: " + scope.getName());
//				System.out.println("item id has scope: " + scope.getName());
				
				FolderItem folderItem = (FolderItem) item;

				//Read property file
				GenericResourcePropertyReader gRead = new GenericResourcePropertyReader();

				GcubeApplicationReader app = new GcubeApplicationReader(folderItem.getFolderItemType().toString(), scope, gRead.getGenericResource(), gRead.getAppId());

				//Rewrite scope into ASL session
				ASLSession newSession = SessionManager.getInstance().getASLSession(httpSession.getId(), session.getUsername());
				newSession.setScope(app.getGcubeApplication().getAppProfile().getScope());
				
				logger.trace("Rewrite scope into ASL session with new scope: " + newSession.getScopeName());
//				System.out.println("Rewrite scope into ASL session with new scope: " + newSession.getScopeName());
				
				setValueInSession(newSession, app.getGcubeApplication().getKeyOID(), oid);

				url = app.getGcubeApplication().getAppProfile().getUrl();
			} else
				throw new GetUrlFromApplicationProfileException(
						"The workspace item with oid: " + oid
								+ " is not a WorkspaceItemType.FOLDER_ITEM");

		} catch (Exception e) {
			logger.error("getURLFromApplicationProfile", e);
			throw new GetUrlFromApplicationProfileException(
					"Sorry, an error occurred in getURLFromApplicationProfile, try again");
		}

		return url;
	}

	/**
	 * 
	 * @param session
	 * @param name
	 * @param value
	 * @throws Exception
	 */
	private void setValueInSession(ASLSession session, String name, String value) throws Exception {

		try {

			session.setAttribute(name, value);
			logger.trace("in scope "+session.getScopeName()+ " set attribute name: " + name+ ", value: " + value);
			// System.out.println("set value in session with name: "+name+", value: "+value);

		} catch (Exception e) {
			logger.error("setValueInSession", e);
			throw new Exception(e.getMessage());
		}
	}
	
	public static void main(String[] args) throws Exception
	{
		String scopeString = "/gcube/devsec/devVRE";
		
//		String scopeString = "/gcube/devNext/NextNext";
		String type = "REPORT_TEMPLATE";
		
		GCUBEScope scope;
		scope = GCUBEScope.getScope(scopeString);

		GenericResourcePropertyReader gRead = new GenericResourcePropertyReader();

		GcubeApplicationReader app = new GcubeApplicationReader(type, scope,gRead.getGenericResource(), gRead.getAppId());
		
		System.out.println(app.getGcubeApplication());
		
		System.out.println(app.getGcubeApplication().getAppProfile());

	}

}
