package org.gcube.portlets.user.opengcubeapplication.reader;

import java.util.List;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.opengcubeapplication.entity.ApplicationProfile;
import org.gcube.portlets.user.opengcubeapplication.exception.ApplicationProfileNotFoundException;
import org.gcube.portlets.user.opengcubeapplication.util.Util;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class ApplicationProfileReader {
	
	protected static final String RESOURCE_PROFILE_BODY_TEXT = "/Resource/Profile/Body/text()";
	protected static final String RESOURCE_PROFILE_BODY_THUMBNAIL_URL_TEXT = "/Resource/Profile/Body/ThumbnailURL/text()";
	protected static final String RESOURCE_PROFILE_BODY_APP_ID_TEXT = "/Resource/Profile/Body/AppId/text()";
	protected static final String RESOURCE_PROFILE_DESCRIPTION_TEXT = "/Resource/Profile/Description/text()";
	protected static final String RESOURCE_PROFILE_NAME_TEXT = "/Resource/Profile/Name/text()";
	
	
	private GCUBEClientLog logger = new GCUBEClientLog(ApplicationProfileReader.class);
	private String secondaryType;
	private String appId;
	private GCUBEScope scope;
	private ApplicationProfile applicationProfile;
	

	/**
	 * 
	 * @param scope - the scope to be searched
	 * @param genericResource - the name of generic resource
	 * @param portletClassName - the AppId of generic resource
	 */
	public ApplicationProfileReader(GCUBEScope scope, String secondaryType, String portletClassName) { 
		this.scope = scope;
		this.secondaryType = secondaryType;
		this.appId = portletClassName;
		this.applicationProfile = readProfileFromInfrastrucure();	
	}

	public ApplicationProfile getApplicationProfile() {
		return applicationProfile;
	}

	/**
	 * this method looks up the applicationProfile profile among the ones available in the infrastructure
	 * @param portletClassName your servlet class name will be used ad unique identifier for your applicationProfile
	 * @return the applicationProfile profile
	 */
	private ApplicationProfile readProfileFromInfrastrucure() {
		try {
			
			ApplicationProfile appProf = new ApplicationProfile();
			ISClient client = GHNContext.getImplementation(ISClient.class);
			GCUBEGenericQuery query = client.getQuery(GCUBEGenericQuery.class);

			String queryString = Util.getGcubeGenericQueryString(secondaryType, appId);

//			System.out.println("queryString: " +queryString);

			query.setExpression(queryString);

			GCUBEScope scope =  this.scope;

			List<XMLResult> appProfile = client.execute(query, scope.getInfrastructure());
			if (appProfile == null || appProfile.size() == 0) 
				throw new ApplicationProfileNotFoundException("Your applicationProfile is not registered in the infrastructure");
			else {
				XMLResult node = appProfile.get(0);
				
//				System.out.println("To string: "+node.toString());
				
				List<String> currValue = null;
				currValue = node.evaluate(RESOURCE_PROFILE_NAME_TEXT);
				if (currValue != null && currValue.size() > 0) {
					appProf.setName(currValue.get(0));
				} 
				else throw new ApplicationProfileNotFoundException("Your applicationProfile NAME was not found in the profile");

				currValue = node.evaluate(RESOURCE_PROFILE_DESCRIPTION_TEXT);
				if (currValue != null && currValue.size() > 0) {
					appProf.setDescription(currValue.get(0));
				} 
				else logger.warn("No Description exists for " + appProf.getName());

				currValue = node.evaluate(RESOURCE_PROFILE_BODY_APP_ID_TEXT);
				if (currValue != null && currValue.size() > 0) {
					appProf.setKey(currValue.get(0));
				}
				else throw new ApplicationProfileNotFoundException("Your applicationProfile ID n was not found in the profile, consider adding <AppId> element in <Body>");

				currValue = node.evaluate(RESOURCE_PROFILE_BODY_THUMBNAIL_URL_TEXT);
				if (currValue != null && currValue.size() > 0) {
					appProf.setImageUrl(currValue.get(0));
				}
				else throw new ApplicationProfileNotFoundException("Your applicationProfile Image Url was not found in the profile, consider adding <ThumbnailURL> element in <Body>");
				currValue = node.evaluate("/Resource/Profile/Body/EndPoint/Scope/text()");
				if (currValue != null && currValue.size() > 0) {
					List<String> scopes = currValue;
					boolean foundUrl = false;
					for (int i = 0; i < scopes.size(); i++) {
						if (currValue.get(i).trim().compareTo(scope.toString()) == 0) {								
							appProf.setUrl(node.evaluate("/Resource/Profile/Body/EndPoint/URL/text()").get(i));
							appProf.setScope(scope.toString());
							foundUrl = true;
							break;
						}						
					}
					if (! foundUrl)
						throw new ApplicationProfileNotFoundException("Your applicationProfile URL was not found in the profile for Scope: " + scope.toString());
				}
				else throw new ApplicationProfileNotFoundException("Your applicationProfile EndPoint was not found in the profile, consider adding <EndPoint><Scope> element in <Body>");
				return appProf;
			}

		} catch (Exception e) {
			logger.error("Error while trying to fetch applicationProfile profile from the infrastructure");
			e.printStackTrace();
			return null;
		} 

	}
}
