package org.gcube.portlets.user.opengcubeapplication.reader;

import java.io.Serializable;
import java.util.List;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.opengcubeapplication.entity.GcubeApplication;
import org.gcube.portlets.user.opengcubeapplication.exception.ApplicationProfileNotFoundException;
import org.gcube.portlets.user.opengcubeapplication.util.Util;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class GcubeApplicationReader implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5254152784210626995L;
	
	protected static final String APPLICATION_PROFILE = "ApplicationProfile";
	protected static final String RESOURCE_PROFILE_BODY_APP_ID_TEXT = "/Resource/Profile/Body/AppId/text()";
	protected static final String RESOURCE_PROFILE_NAME_TEXT = "/Resource/Profile/Name/text()";
	
	
	private GCUBEClientLog logger = new GCUBEClientLog(GcubeApplicationReader.class);
	private String secondaryType;
	private String appId;
	private GCUBEScope scope;
	private GcubeApplication gcubeApplication;
	private String type;
	

	/**
	 * @param type - the FolderItemType to be searched
	 * @param scope - the scope to be searched
	 * @param genericResource - the name of generic resource
	 * @param portletClassName - the AppId of generic resource
	 */
	public GcubeApplicationReader(String type, GCUBEScope scope, String secondaryType, String portletClassName) {
		this.type = type;
		this.scope = scope;
		this.secondaryType = secondaryType;
		this.appId = portletClassName;
		this.gcubeApplication = new GcubeApplication(this.type);
		readGcubeApplicationFromInfrastrucure();
		
		ApplicationProfileReader appProfReader = new ApplicationProfileReader(this.scope, APPLICATION_PROFILE, this.gcubeApplication.getAppId());
		
		this.gcubeApplication.setAppProfile(appProfReader.getApplicationProfile());
		
	}


	public GcubeApplication getGcubeApplication() {
		return gcubeApplication;
	}


	private void readGcubeApplicationFromInfrastrucure() {
		try {
			
			ISClient client = GHNContext.getImplementation(ISClient.class);
			GCUBEGenericQuery query = client.getQuery(GCUBEGenericQuery.class);

			String queryString = Util.getGcubeGenericQueryString(secondaryType, appId);

			query.setExpression(queryString);

			GCUBEScope scope =  this.scope;

			List<XMLResult> appProfile = client.execute(query, scope.getInfrastructure());
			if (appProfile == null || appProfile.size() == 0) 
				throw new ApplicationProfileNotFoundException("Your GcubeApplication is not registered in the infrastructure");
			else {
				XMLResult node = appProfile.get(0);
				
//				System.out.println("To string: "+node.toString());
				
				List<String> currValue = null;
				currValue = node.evaluate(RESOURCE_PROFILE_NAME_TEXT);
				if (currValue != null && currValue.size() > 0) {
					this.gcubeApplication.setName(currValue.get(0));
				} 
				else throw new ApplicationProfileNotFoundException("Your GcubeApplication NAME was not found in the profile");

				currValue = node.evaluate(RESOURCE_PROFILE_BODY_APP_ID_TEXT);
				if (currValue != null && currValue.size() > 0) {
					this.gcubeApplication.setAppId(currValue.get(0));
				}
				else throw new ApplicationProfileNotFoundException("Your GcubeApplication ID n was not found in the profile, consider adding <AppId> element in <Body>");
				
				currValue = node.evaluate("/Resource/Profile/Body/GcubeApps/GcubeApp/Type/text()");
				if (currValue != null && currValue.size() > 0) {
					List<String> types = currValue;
					boolean foundUrl = false;
					for (int i = 0; i < types.size(); i++) {
						if (currValue.get(i).trim().compareTo(type) == 0) {	
							this.gcubeApplication.setAppId(node.evaluate("/Resource/Profile/Body/GcubeApps/GcubeApp/AppId/text()").get(i));
							this.gcubeApplication.setKeyOID(node.evaluate("/Resource/Profile/Body/GcubeApps/GcubeApp/KeyOID/text()").get(i));
							foundUrl = true;
							break;
						}						
					}
					if (! foundUrl)
						throw new ApplicationProfileNotFoundException("Your GcubeApplication Type: "+type+" was not found in the profile");
				}
				else throw new ApplicationProfileNotFoundException("Your GcubeApplication Type was not found in the profile, consider adding <GcubeApp><Type> element in <Body>");
			}

		} catch (Exception e) {
			logger.error("Error while trying to fetch GcubeApplication profile from the infrastructure");
			e.printStackTrace();
		} 

	}
}
