/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.client.form;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import net.eliasbalasis.tibcopagebus4gwt.client.PageBusAdapter;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateService;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateServiceAsync;
import org.gcube.portlets.user.shareupdates.client.form.LinkLoader;
import org.gcube.portlets.user.shareupdates.client.form.LinkPlaceholder;
import org.gcube.portlets.user.shareupdates.client.form.LinkPreviewer;
import org.gcube.portlets.user.shareupdates.client.form.MyTextArea;
import org.gcube.portlets.user.shareupdates.client.form.ShareUpdateForm;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;

public class ShareUpdateForm
extends Composite {
    private final ShareUpdateServiceAsync shareupdateService = (ShareUpdateServiceAsync)GWT.create(ShareUpdateService.class);
    final PageBusAdapter pageBusAdapter = new PageBusAdapter();
    protected static final String SHARE_UPDATE_TEXT = "Share an update or paste a link";
    protected static final String ERROR_UPDATE_TEXT = "Looks like empty to me!";
    private static final String LISTBOX_LEVEL = " - ";
    public static final String loading = String.valueOf(GWT.getModuleBaseURL()) + "../images/avatarLoader.gif";
    public static final String avatar_default = String.valueOf(GWT.getModuleBaseURL()) + "../images/Avatar_default.png";
    private static ShareUpdateFormUiBinder uiBinder = (ShareUpdateFormUiBinder)GWT.create(ShareUpdateFormUiBinder.class);
    private LinkPreviewer myLinkPreviewer;
    private static ShareUpdateForm singleton;
    @UiField
    HTMLPanel mainPanel;
    UserInfo myUserInfo;
    @UiField
    LinkPlaceholder preview;
    @UiField
    Button submitButton;
    @UiField
    Image avatarImage;
    @UiField
    MyTextArea shareTextArea;
    @UiField
    ListBox privacyLevel = new ListBox(false);

    public static ShareUpdateForm get() {
        return singleton;
    }

    public ShareUpdateForm() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        singleton = this;
        this.avatarImage.setUrl(loading);
        this.shareTextArea.setText(SHARE_UPDATE_TEXT);
        this.shareupdateService.getUserSettings((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"shareTextArea"})
    void onShareUpdateClick(ClickEvent e) {
        this.shareTextArea.removeSampleText();
    }

    @UiHandler(value={"submitButton"})
    void onClick(ClickEvent e) {
        this.shareupdateService.getUserSettings((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void postTweet(String textToPost) {
        String toShare = this.escapeHtml(textToPost);
        if (!this.checkTextLength(toShare)) {
            Window.alert((String)"We found a single word containing more than 50 chars and it's not a link, is it meaningful?");
            return;
        }
        this.submitButton.setEnabled(false);
        this.shareTextArea.setEnabled(false);
        String vreId = "";
        if (this.getPrivacyLevel() == PrivacyLevel.SINGLE_VRE) {
            vreId = this.privacyLevel.getValue(this.privacyLevel.getSelectedIndex());
        }
        String linkTitle = "";
        String linkDescription = "";
        String linkUrl = "";
        String linkUrlThumbnail = "";
        String linkHost = "";
        if (this.myLinkPreviewer != null) {
            linkTitle = this.myLinkPreviewer.getLinkTitle();
            linkDescription = this.myLinkPreviewer.getLinkDescription();
            linkUrl = this.myLinkPreviewer.getUrl();
            linkUrlThumbnail = this.myLinkPreviewer.getUrlThumbnail();
            linkHost = this.myLinkPreviewer.getHost();
        }
        this.shareupdateService.share(toShare, FeedType.TWEET, this.getPrivacyLevel(), vreId, linkTitle, linkDescription, linkUrl, linkUrlThumbnail, linkHost, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private PrivacyLevel getPrivacyLevel() {
        String selected = this.privacyLevel.getValue(this.privacyLevel.getSelectedIndex());
        if (selected.compareTo(PrivacyLevel.CONNECTION.toString()) == 0) {
            return PrivacyLevel.CONNECTION;
        }
        if (selected.compareTo(PrivacyLevel.VRES.toString()) == 0) {
            return PrivacyLevel.VRES;
        }
        if (selected.compareTo(PrivacyLevel.PRIVATE.toString()) == 0) {
            return PrivacyLevel.PRIVATE;
        }
        if (selected.compareTo(PrivacyLevel.PORTAL.toString()) == 0) {
            return PrivacyLevel.PORTAL;
        }
        return PrivacyLevel.SINGLE_VRE;
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    protected void checkLink(String textToCheck) {
        if (this.myLinkPreviewer == null) {
            String[] parts;
            String[] stringArray = parts = textToCheck.split("\\s");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.startsWith("http")) {
                    this.preview.add((Widget)new LinkLoader());
                    this.shareupdateService.checkLink(textToCheck, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                    break;
                }
                ++n2;
            }
        } else {
            Window.alert((String)"You cannot post two links, please remove the previous one first.");
        }
    }

    private boolean checkTextLength(String textToCheck) {
        String[] parts;
        String[] stringArray = parts = textToCheck.split("\\s");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (!item.startsWith("http") && item.length() > 50) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void addPreview(LinkPreview result) {
        this.myLinkPreviewer = new LinkPreviewer(this, result);
        this.preview.add((Widget)this.myLinkPreviewer);
    }

    protected void cancelPreview() {
        this.preview.clear();
        this.myLinkPreviewer = null;
    }

    static /* synthetic */ void access$0(ShareUpdateForm shareUpdateForm, String string) {
        shareUpdateForm.postTweet(string);
    }

    static /* synthetic */ void access$1(ShareUpdateForm shareUpdateForm, LinkPreviewer linkPreviewer) {
        shareUpdateForm.myLinkPreviewer = linkPreviewer;
    }

    static /* synthetic */ void access$2(ShareUpdateForm shareUpdateForm, LinkPreview linkPreview) {
        shareUpdateForm.addPreview(linkPreview);
    }
}

