/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.shareupdates.server.ShareUpdateServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadToWorkspaceThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(UploadToWorkspaceThread.class);
    private String username;
    private String fileName;
    private String fileabsolutePathOnServer;

    public UploadToWorkspaceThread(String username, String fileName, String fileabsolutePathOnServer) {
        this.username = username;
        this.fileName = fileName;
        this.fileabsolutePathOnServer = fileabsolutePathOnServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String currScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set("/" + PortalContext.getConfiguration().getInfrastructureName());
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(this.username).getWorkspace();
            _log.info("File to upload=" + this.fileabsolutePathOnServer);
            File file = new File(this.fileabsolutePathOnServer);
            String mimeType = ShareUpdateServiceImpl.getMimeType((File)file, (String)this.fileName);
            FileInputStream fileData = new FileInputStream(file);
            String theId = "";
            _log.info("mimeType=" + mimeType + " fileData null? " + (fileData == null));
            try {
                theId = ws.createExternalFile(this.fileName, "File added automatically by Share Updates", mimeType, (InputStream)fileData, ws.getRoot().getId()).getId();
            }
            catch (NullPointerException exn) {
                _log.warn("null pointer");
                exn.printStackTrace();
            }
            catch (ItemAlreadyExistException ex) {
                _log.warn("fileName " + this.fileName + " exists, appending timestamp");
                theId = ws.createExternalFile(this.fileName + " (" + new Date() + ")", "File added automatically by Share Updates", mimeType, (InputStream)fileData, ws.getRoot().getId()).getId();
                ex.printStackTrace();
            }
            finally {
                ((InputStream)fileData).close();
            }
            ((InputStream)fileData).close();
            _log.debug("Uploaded " + this.fileName + " - Returned Workspace id=" + theId);
            ScopeProvider.instance.set(currScope);
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error("Something wrong while uploading " + this.fileName + " in Workspace " + e.getMessage());
        }
    }
}

