/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server.opengraph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.portlets.user.shareupdates.server.opengraph.MetaElement;
import org.gcube.portlets.user.shareupdates.server.opengraph.OpenGraphNamespace;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

/*
 * Exception performing whole class analysis ignored.
 */
public class OpenGraph {
    private String pageUrl;
    private ArrayList<OpenGraphNamespace> pageNamespaces = new ArrayList();
    private Hashtable<String, ArrayList<MetaElement>> metaAttributes = new Hashtable();
    private String baseType;
    private boolean isImported = false;
    private boolean hasChanged = false;
    public static final String[] REQUIRED_META = new String[]{"title", "type", "image", "url"};
    public static final Hashtable<String, String[]> BASE_TYPES = new Hashtable();

    static {
        BASE_TYPES.put("activity", new String[]{"activity", "sport"});
        BASE_TYPES.put("business", new String[]{"bar", "company", "cafe", "hotel", "restaurant"});
        BASE_TYPES.put("group", new String[]{"cause", "sports_league", "sports_team"});
        BASE_TYPES.put("organization", new String[]{"band", "government", "non_profit", "school", "university"});
        BASE_TYPES.put("person", new String[]{"actor", "athlete", "author", "director", "musician", "politician", "profile", "public_figure"});
        BASE_TYPES.put("place", new String[]{"city", "country", "landmark", "state_province"});
        BASE_TYPES.put("product", new String[]{"album", "book", "drink", "food", "game", "movie", "product", "song", "tv_show"});
        BASE_TYPES.put("website", new String[]{"blog", "website", "article"});
    }

    public OpenGraph() {
    }

    public OpenGraph(String url, boolean ignoreSpecErrors, URLConnection siteConnection) throws IOException, Exception {
        this();
        TagNode[] metaData;
        String inputLine;
        this.isImported = true;
        Charset charset = OpenGraph.getConnectionCharset((URLConnection)siteConnection);
        BufferedReader dis = new BufferedReader(new InputStreamReader(siteConnection.getInputStream(), charset));
        StringBuffer headContents = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            if (inputLine.contains("</head>")) {
                inputLine = inputLine.substring(0, inputLine.indexOf("</head>") + 7);
                inputLine = inputLine.concat("<body></body></html>");
                headContents.append(String.valueOf(inputLine) + "\r\n");
                break;
            }
            headContents.append(String.valueOf(inputLine) + "\r\n");
        }
        String headContentsStr = headContents.toString();
        HtmlCleaner cleaner = new HtmlCleaner();
        TagNode pageData = cleaner.clean(headContentsStr);
        boolean hasOGspec = false;
        TagNode headElement = pageData.findElementByName("head", true);
        if (headElement.hasAttribute("prefix")) {
            String namespaceData = headElement.getAttributeByName("prefix");
            Pattern pattern = Pattern.compile("(([A-Za-z0-9_]+):\\s+(http:\\/\\/ogp.me\\/ns(\\/\\w+)*#))\\s*");
            Matcher matcher = pattern.matcher(namespaceData);
            while (matcher.find()) {
                String prefix = matcher.group(2);
                String documentURI = matcher.group(3);
                this.pageNamespaces.add(new OpenGraphNamespace(prefix, documentURI));
                if (!prefix.equals("og")) continue;
                hasOGspec = true;
            }
        }
        if (!hasOGspec) {
            this.pageNamespaces.add(new OpenGraphNamespace("og", "http:// ogp.me/ns#"));
        }
        Object[] objectArray = metaData = pageData.getElementsByName("meta", true);
        int n = metaData.length;
        int matcher = 0;
        while (matcher < n) {
            TagNode metaElement = objectArray[matcher];
            for (OpenGraphNamespace namespace : this.pageNamespaces) {
                String target = null;
                if (metaElement.hasAttribute("property")) {
                    target = "property";
                } else if (metaElement.hasAttribute("name")) {
                    target = "name";
                }
                if (target == null || !metaElement.getAttributeByName(target).startsWith(String.valueOf(namespace.getPrefix()) + ":")) continue;
                this.setProperty(namespace, metaElement.getAttributeByName(target), metaElement.getAttributeByName("content"));
                break;
            }
            ++matcher;
        }
        if (!ignoreSpecErrors) {
            objectArray = REQUIRED_META;
            n = REQUIRED_META.length;
            matcher = 0;
            while (matcher < n) {
                TagNode req = objectArray[matcher];
                if (!this.metaAttributes.containsKey(req)) {
                    throw new Exception("Does not conform to Open Graph protocol");
                }
                ++matcher;
            }
        }
        this.baseType = null;
        String currentType = this.getContent("type");
        URL realURL = siteConnection.getURL();
        this.pageUrl = realURL.toExternalForm();
    }

    public static Charset getConnectionCharset(URLConnection connection) {
        String charsetName;
        String contentType = null;
        try {
            contentType = connection.getContentType();
        }
        catch (Exception e) {
            return Charset.defaultCharset();
        }
        if (contentType != null && contentType.length() > 0 && (charsetName = OpenGraph.extractCharsetName((String)(contentType = contentType.toLowerCase()))) != null && charsetName.length() > 0) {
            try {
                return Charset.forName(charsetName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Charset.defaultCharset();
    }

    private static String extractCharsetName(String contentType) {
        String[] mediaTypes = contentType.split(":");
        if (mediaTypes.length > 0) {
            String[] params;
            String[] stringArray = params = mediaTypes[0].split(";");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String each = stringArray[n2];
                if ((each = each.trim()).startsWith("charset=")) {
                    return each.substring(8).trim();
                }
                ++n2;
            }
        }
        return null;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public String getContent(String property) {
        if (this.metaAttributes.containsKey(property) && ((ArrayList)this.metaAttributes.get(property)).size() > 0) {
            return ((MetaElement)((ArrayList)this.metaAttributes.get(property)).get(0)).getContent();
        }
        return null;
    }

    public MetaElement[] getProperties() {
        ArrayList allElements = new ArrayList();
        for (ArrayList collection : this.metaAttributes.values()) {
            allElements.addAll(collection);
        }
        return allElements.toArray(new MetaElement[allElements.size()]);
    }

    public MetaElement[] getProperties(String property) {
        if (this.metaAttributes.containsKey(property)) {
            ArrayList target = (ArrayList)this.metaAttributes.get(property);
            return target.toArray(new MetaElement[target.size()]);
        }
        return null;
    }

    public String getOriginalUrl() {
        return this.pageUrl;
    }

    public String[] toHTML() {
        ArrayList<String> returnHTML = new ArrayList<String>();
        boolean index = false;
        for (ArrayList elements : this.metaAttributes.values()) {
            for (MetaElement element : elements) {
                returnHTML.add("<meta property=\"" + element.getNamespace() + ":" + element.getProperty() + "\" content=\"" + element.getContent() + "\" />");
            }
        }
        return (String[])returnHTML.toArray();
    }

    public String[] toXHTML() {
        ArrayList<String> returnHTML = new ArrayList<String>();
        boolean index = false;
        for (ArrayList elements : this.metaAttributes.values()) {
            for (MetaElement element : elements) {
                returnHTML.add("<meta name=\"" + element.getNamespace().getPrefix() + ":" + element.getProperty() + "\" content=\"" + element.getContent() + "\" />");
            }
        }
        return (String[])returnHTML.toArray();
    }

    public void setProperty(OpenGraphNamespace namespace, String property, String content) {
        if (!this.pageNamespaces.contains(namespace)) {
            this.pageNamespaces.add(namespace);
        }
        property = property.replaceAll(String.valueOf(namespace.getPrefix()) + ":", "");
        MetaElement element = new MetaElement(namespace, property, content);
        if (!this.metaAttributes.containsKey(property)) {
            this.metaAttributes.put(property, new ArrayList());
        }
        ((ArrayList)this.metaAttributes.get(property)).add(element);
    }

    public void removeProperty(String property) {
        this.metaAttributes.remove(property);
    }

    public Hashtable<String, ArrayList<MetaElement>> exposeTable() {
        return this.metaAttributes;
    }

    public boolean isFromWeb() {
        return this.isImported;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }
}

