/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.sun.net.ssl.HttpsURLConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.gcube.portlets.user.shareupdates.server.ShareUpdateServiceImpl;
import org.gcube.portlets.user.shareupdates.server.metaseeker.MetaSeeker;
import org.gcube.portlets.user.shareupdates.server.opengraph.OpenGraph;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlparser.beans.StringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextTransfromUtils {
    private static Logger _log = LoggerFactory.getLogger(ShareUpdateServiceImpl.class);

    private static String createDescriptionFromContent(String link) {
        StringBean sb = new StringBean();
        sb.setURL(link);
        sb.setLinks(false);
        String description = sb.getStrings();
        description = description.length() > 256 ? description.substring(0, 256) + "..." : description;
        return description;
    }

    protected static ArrayList<String> getImagesWithCleaner(URL pageURL) throws IOException {
        String inputLine;
        ArrayList<String> images = new ArrayList<String>();
        URLConnection conn = pageURL.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        Charset charset = OpenGraph.getConnectionCharset((URLConnection)conn);
        BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer headContents = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            headContents.append(inputLine + "\r\n");
        }
        HtmlCleaner cleaner = new HtmlCleaner();
        String headContentsStr = headContents.toString();
        TagNode pageData = cleaner.clean(headContentsStr);
        TagNode[] imgs = pageData.getElementsByName("img", true);
        int upTo = imgs.length > 15 ? 15 : imgs.length;
        for (int i = 0; i < upTo; ++i) {
            if (!imgs[i].hasAttribute("src")) continue;
            String imageUrl = TextTransfromUtils.getImageUrlFromSrcAttribute((URL)pageURL, (String)imgs[i].getAttributeByName("src"));
            _log.trace("[FOUND image] " + imageUrl);
            if (imageUrl.endsWith(".gif") || imageUrl.endsWith(".GIF")) {
                _log.trace("[Gif image] SKIP " + imageUrl);
                continue;
            }
            images.add(imageUrl);
        }
        return images;
    }

    protected static String getImageUrlFromSrcAttribute(URL pageURL, String srcAttr) {
        String imageUrl = srcAttr;
        _log.trace("imageUrl=" + imageUrl);
        if (imageUrl.startsWith("http") || imageUrl.startsWith("//")) {
            _log.trace("Direct link case");
            return imageUrl;
        }
        if (imageUrl.startsWith("/")) {
            _log.trace("Absolute Path case");
            imageUrl = pageURL.getProtocol() + "://" + pageURL.getHost() + imageUrl;
        } else if (imageUrl.startsWith("../")) {
            _log.trace("Relative Path case");
            String imageFolder = pageURL.toString().substring(0, pageURL.toString().lastIndexOf("/"));
            imageUrl = imageFolder + "/" + imageUrl;
        } else if (!imageUrl.contains("/") || !imageUrl.startsWith("/")) {
            String imageFolder;
            _log.trace("probably in the same folder");
            String checkedURL = pageURL.toString();
            if (!checkedURL.endsWith("/")) {
                checkedURL = checkedURL + "/";
            }
            if ((imageFolder = pageURL.toString().substring(0, pageURL.toString().lastIndexOf("/"))).compareToIgnoreCase("http:/") == 0 || imageFolder.compareToIgnoreCase("https:/") == 0) {
                imageFolder = pageURL.toString();
            }
            imageUrl = imageFolder + "/" + imageUrl;
        } else if (!imageUrl.startsWith("http")) {
            _log.trace("In the root");
            imageUrl = pageURL.toExternalForm().endsWith("/") ? pageURL.toExternalForm() + imageUrl : pageURL.toExternalForm() + "/" + imageUrl;
        }
        return imageUrl;
    }

    protected static LinkPreview getInfoFromHTML(URLConnection connection, URL pageUrl, String link, String host) throws Exception {
        LinkPreview toReturn = null;
        String title = "";
        String description = "";
        URLConnection conn = pageUrl.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        MetaSeeker ms = null;
        try {
            title = TextTransfromUtils.getTitleFromHeader((URL)pageUrl);
            _log.trace("Found Title=" + title);
            ms = new MetaSeeker(connection, pageUrl);
            description = ms.getContent("description") != null && !ms.getContent("description").isEmpty() ? ms.getContent("description") : TextTransfromUtils.createDescriptionFromContent((String)link);
            ArrayList images = new ArrayList();
            images = TextTransfromUtils.getImagesWithCleaner((URL)pageUrl);
            toReturn = new LinkPreview(title, description, link, host, images);
        }
        catch (Exception e) {
            _log.error("[MANUAL-PARSE] Something wrong with the meta seeker returning ... ");
            e.printStackTrace();
            return toReturn;
        }
        return toReturn;
    }

    private static String getTitleFromHeader(URL pageURL) throws IOException {
        String headContentsStr;
        HtmlCleaner cleaner;
        TagNode pageData;
        TagNode[] title;
        String inputLine;
        URLConnection conn = pageURL.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        Charset charset = OpenGraph.getConnectionCharset((URLConnection)conn);
        BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer headContents = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            if (inputLine.contains("</head>")) {
                inputLine = inputLine.substring(0, inputLine.indexOf("</head>") + 7);
                inputLine = inputLine.concat("<body></body></html>");
                headContents.append(inputLine + "\r\n");
                break;
            }
            headContents.append(inputLine + "\r\n");
        }
        if ((title = (pageData = (cleaner = new HtmlCleaner()).clean(headContentsStr = headContents.toString())).getElementsByName("title", true)) != null && title.length > 0 && title[0].getChildren().size() > 0) {
            String theTitle = title[0].getChildren().get(0).toString();
            _log.trace("theTitle: " + theTitle);
            return theTitle;
        }
        return "No-title";
    }

    protected static String replaceAmpersand(String toReplace) {
        String toReturn = toReplace.replaceAll("&amp;", "&");
        return toReturn;
    }

    protected static void trustAllHTTPSConnections() {
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)sc.getSocketFactory());
        }
        catch (Exception e) {
            System.out.println("Error" + e);
        }
    }
}

