/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.socialprofile.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portal.databook.client.util.Encoder;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.socialprofile.client.SocialService;
import org.gcube.portlets.user.socialprofile.client.SocialServiceAsync;
import org.gcube.portlets.user.socialprofile.client.ui.DisplayProfile;

public class DisplayProfile
extends Composite {
    protected static final String HEADLINE_TEXT = "Professional Headline";
    protected static final String HEADLINE_ERROR = "Your Headline please";
    protected static final String ISTI_TEXT = "Company";
    protected static final String ISTI_ERROR = "Your Company please";
    private static DisplayProfileUiBinder uiBinder = (DisplayProfileUiBinder)GWT.create(DisplayProfileUiBinder.class);
    public static final String avatar_default = String.valueOf(GWT.getModuleBaseURL()) + "../images/Avatar_default.png";
    public static final String loading = String.valueOf(GWT.getModuleBaseURL()) + "../images/avatarLoader.gif";
    public static final String savingImage = String.valueOf(GWT.getModuleBaseURL()) + "../images/saving.gif";
    public static final String GET_OID_PARAMETER = "oid";
    private final SocialServiceAsync socialService = (SocialServiceAsync)GWT.create(SocialService.class);
    @UiField
    HTMLPanel mainPanel;
    @UiField
    Image avatarImage;
    @UiField
    HTML userFullName;
    @UiField
    TextBox headlineBox;
    @UiField
    TextBox institutionBox;
    @UiField
    HTML editHeadline;
    @UiField
    HTML editIsti;
    @UiField
    HTML headlineLabel;
    @UiField
    HTML institutionLabel;
    @UiField
    Image savingHeadline;
    @UiField
    Button saveHead;
    @UiField
    Button cancelHead;
    @UiField
    Button saveIsti;
    @UiField
    Button cancelIsti;
    @UiField
    Button messageButton;
    private String currHeadLine;
    private String currInstitution;
    private UserInfo myUserInfo;

    public DisplayProfile() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.avatarImage.setUrl(loading);
        this.mainPanel.addStyleName("framed");
        this.savingHeadline.setUrl(savingImage);
        this.socialService.getUserContext(this.getUserToShowId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"editHeadline"})
    void onEditHeadlineClick(ClickEvent e) {
        this.headlineLabel.setVisible(false);
        this.headlineBox.setText(this.headlineLabel.getText());
        this.headlineBox.addStyleName("edit");
        this.headlineBox.setVisible(true);
        this.headlineBox.setFocus(true);
        this.headlineBox.selectAll();
        this.editHeadline.setVisible(false);
        this.saveHead.setVisible(true);
        this.cancelHead.setVisible(true);
    }

    @UiHandler(value={"editIsti"})
    void onEditInstitutionClick(ClickEvent e) {
        this.institutionLabel.setVisible(false);
        this.institutionBox.setText(this.institutionLabel.getText());
        this.institutionBox.addStyleName("edit");
        this.institutionBox.setVisible(true);
        this.institutionBox.setFocus(true);
        this.institutionBox.selectAll();
        this.editIsti.setVisible(false);
        this.saveIsti.setVisible(true);
        this.cancelIsti.setVisible(true);
    }

    @UiHandler(value={"cancelHead"})
    void onCancelHeadlineClick(ClickEvent e) {
        this.cancelHeadline();
    }

    @UiHandler(value={"cancelIsti"})
    void onCancelIstiClick(ClickEvent e) {
        this.cancelInsti();
    }

    @UiHandler(value={"saveHead"})
    void onSaveHeadlineClick(ClickEvent e) {
        String toShare = this.escapeHtml(this.headlineBox.getText());
        if (toShare.equals("") || toShare.equals(HEADLINE_TEXT) || toShare.equals(HEADLINE_ERROR)) {
            this.headlineBox.setText(HEADLINE_ERROR);
        } else {
            this.currHeadLine = toShare;
            this.saveHead.setVisible(false);
            this.cancelHead.setVisible(false);
            this.savingHeadline.setVisible(true);
            this.socialService.saveHeadline(this.currHeadLine, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @UiHandler(value={"saveIsti"})
    void onSaveInstitutionClick(ClickEvent e) {
        String toShare = this.escapeHtml(this.institutionBox.getText());
        if (toShare.equals("") || toShare.equals(ISTI_TEXT) || toShare.equals(ISTI_ERROR)) {
            this.institutionBox.setText(ISTI_ERROR);
        } else {
            this.currInstitution = toShare;
            this.saveIsti.setVisible(false);
            this.cancelIsti.setVisible(false);
            this.savingHeadline.setVisible(true);
            this.socialService.saveIsti(this.currInstitution, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @UiHandler(value={"messageButton"})
    void onSendPrivateMessageClick(ClickEvent e) {
        ArrayList<String> listToLogin = new ArrayList<String>();
        listToLogin.add(this.getUserToShowId());
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cancelHeadline() {
        this.editHeadline.setVisible(true);
        this.saveHead.setVisible(false);
        this.cancelHead.setVisible(false);
        this.headlineBox.setVisible(false);
        this.headlineLabel.setVisible(true);
    }

    private void cancelInsti() {
        this.editIsti.setVisible(true);
        this.saveIsti.setVisible(false);
        this.cancelIsti.setVisible(false);
        this.institutionBox.setVisible(false);
        this.institutionLabel.setVisible(true);
    }

    private String getUserToShowId() {
        String encodedOid = Encoder.encode((String)"userIdentificationParameter");
        String encodedUserId = Window.Location.getParameter((String)encodedOid);
        return Encoder.decode((String)encodedUserId);
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    static /* synthetic */ void access$0(DisplayProfile displayProfile, UserInfo userInfo) {
        displayProfile.myUserInfo = userInfo;
    }

    static /* synthetic */ UserInfo access$1(DisplayProfile displayProfile) {
        return displayProfile.myUserInfo;
    }

    static /* synthetic */ String access$2(DisplayProfile displayProfile) {
        return displayProfile.getUserToShowId();
    }

    static /* synthetic */ void access$3(DisplayProfile displayProfile, String string) {
        displayProfile.currHeadLine = string;
    }

    static /* synthetic */ void access$4(DisplayProfile displayProfile) {
        displayProfile.cancelHeadline();
    }

    static /* synthetic */ String access$5(DisplayProfile displayProfile) {
        return displayProfile.currHeadLine;
    }

    static /* synthetic */ String access$6(DisplayProfile displayProfile) {
        return displayProfile.currInstitution;
    }
}

