/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.portlets.user.speciesdiscovery.server.asl.SessionUtil;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.GisLayerJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.OccurrenceJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.OccurrenceRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.ResultRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonomyJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonomyRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.SessionExpired;

/*
 * Exception performing whole class analysis ignored.
 */
public class DaoSession {
    protected static final String PROPERTY_CATALINA_HOME = "catalina.home";
    protected static final String CATALINA_HOME = "CATALINA_HOME";
    protected static final String PERSISTENCE_H2DBSPECIES_H2 = "persistence/h2dbspecies/h2";
    public static Logger logger = Logger.getLogger(DaoSession.class);
    private static final String JDBCDRIVER = "jdbc:h2:";

    public static boolean checkASLSession(ASLSession session) throws SessionExpired {
        if (session == null) {
            String error = "ASL session is null!!!!";
            logger.error((Object)error);
            throw new SessionExpired(error);
        }
        String username = session.getUsername();
        String scope = session.getScopeName();
        if (username == null || username.isEmpty()) {
            String error = "Username is null or empty, throwing session expired exception";
            logger.error((Object)error);
            throw new SessionExpired(error);
        }
        if (scope == null || scope.isEmpty()) {
            String error = "Scope is null or empty, throwing session expired exception";
            logger.error((Object)error);
            throw new SessionExpired(error);
        }
        logger.trace((Object)("Session is valid: [username: " + username + ", scope: " + scope + "]"));
        return true;
    }

    public static String getUsernameScopeValue(String username, String scope) throws SessionExpired {
        scope = scope.replaceAll("/", "");
        username = username.replaceAll("\\.", "");
        return username + scope;
    }

    public static String getTomcatFolder() {
        String catalinaHome;
        String string = catalinaHome = System.getenv("CATALINA_HOME") != null ? System.getenv("CATALINA_HOME") : System.getProperty("catalina.home");
        if (catalinaHome == null || catalinaHome.isEmpty()) {
            logger.error((Object)"CATALINA_HOME ENVIROMENT NOT FOUND -  RETURNED / PATH");
        }
        return catalinaHome.endsWith("/") ? catalinaHome : catalinaHome + "/";
    }

    public static String getConnectionUrl(ASLSession session) throws SessionExpired {
        DaoSession.checkASLSession((ASLSession)session);
        return "jdbc:h2:" + DaoSession.getTomcatFolder() + "persistence/h2dbspecies/h2" + DaoSession.getUsernameScopeValue((String)session.getUsername(), (String)session.getScopeName()) + ";create=true";
    }

    public static void initSessionDaoObjects(ASLSession session) throws DatabaseServiceException {
        try {
            DaoSession.getTaxonDAO((ASLSession)session);
            DaoSession.getResultRowDAO((ASLSession)session);
            DaoSession.getTaxonomyDAO((ASLSession)session);
            DaoSession.getOccurrencesJobDAO((ASLSession)session);
            DaoSession.getTaxonomyJobDAO((ASLSession)session);
            DaoSession.getGisLayersJobDAO((ASLSession)session);
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred on init DB: ", (Throwable)e);
            e.printStackTrace();
            throw new DatabaseServiceException("initializing species database");
        }
    }

    public static EntityManager newEntityManager(ASLSession session) throws SessionExpired, Exception {
        return DaoSession.getEntityManagerFactory((ASLSession)session).createEntityManager();
    }

    public static EntityManagerFactory getEntityManagerFactory(ASLSession session) throws SessionExpired, Exception {
        EntityManagerFactory factory = SessionUtil.getEntityManagerFactory((ASLSession)session);
        if (factory == null) {
            factory = DaoSession.createEntityManagerFactory((ASLSession)session);
            SessionUtil.setEntityManagerFactory((ASLSession)session, (EntityManagerFactory)factory);
        }
        return factory;
    }

    public static OccurrenceJobPersistence getOccurrencesJobDAO(ASLSession session) throws SessionExpired, Exception {
        DaoSession.checkASLSession((ASLSession)session);
        OccurrenceJobPersistence occurrencesJobDao = SessionUtil.getCurrentDaoOccurrencesJob((ASLSession)session);
        if (occurrencesJobDao == null) {
            occurrencesJobDao = DaoSession.initOccurrencesJobsDao((ASLSession)session);
            SessionUtil.setCurrentEJBOccurrencesJob((ASLSession)session, (OccurrenceJobPersistence)occurrencesJobDao);
        }
        return occurrencesJobDao;
    }

    public static GisLayerJobPersistence getGisLayersJobDAO(ASLSession session) throws SessionExpired, Exception {
        DaoSession.checkASLSession((ASLSession)session);
        GisLayerJobPersistence gisLayerJobDao = SessionUtil.getCurrentGisLayersJob((ASLSession)session);
        if (gisLayerJobDao == null) {
            gisLayerJobDao = DaoSession.initGisLayerJobsDao((ASLSession)session);
            SessionUtil.setCurrentEJBGisLayerJob((ASLSession)session, (GisLayerJobPersistence)gisLayerJobDao);
        }
        return gisLayerJobDao;
    }

    private static GisLayerJobPersistence initGisLayerJobsDao(ASLSession session) throws SessionExpired, Exception {
        GisLayerJobPersistence gisLayerJobP = new GisLayerJobPersistence(DaoSession.getEntityManagerFactory((ASLSession)session));
        SessionUtil.setCurrentEJBGisLayerJob((ASLSession)session, (GisLayerJobPersistence)gisLayerJobP);
        return gisLayerJobP;
    }

    public static TaxonomyJobPersistence getTaxonomyJobDAO(ASLSession session) throws SessionExpired, Exception {
        DaoSession.checkASLSession((ASLSession)session);
        TaxonomyJobPersistence taxonomyJobPeristence = SessionUtil.getCurrentDAOTaxonomyJob((ASLSession)session);
        if (taxonomyJobPeristence == null) {
            taxonomyJobPeristence = DaoSession.initTaxonomyJobsDao((ASLSession)session);
            SessionUtil.setCurrentDAOTaxonomyJob((ASLSession)session, (TaxonomyJobPersistence)taxonomyJobPeristence);
        }
        return taxonomyJobPeristence;
    }

    public static EntityManagerFactory createEntityManagerFactory(ASLSession session) throws SessionExpired, Exception {
        DaoSession.checkASLSession((ASLSession)session);
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            properties.put("javax.persistence.jdbc.url", DaoSession.getConnectionUrl((ASLSession)session));
        }
        catch (Exception e) {
            logger.error((Object)("error on get connection url " + e), (Throwable)e);
            DaoSession.checkASLSession((ASLSession)session);
            properties.put("javax.persistence.jdbc.url", "jdbc:h2:" + DaoSession.getTomcatFolder() + "/temp/h2dbspecies/h2" + DaoSession.getUsernameScopeValue((String)session.getUsername(), (String)session.getScopeName()) + ";create=true");
        }
        return Persistence.createEntityManagerFactory((String)"SPD_PERSISTENCE_FACTORY", properties);
    }

    public static OccurrenceJobPersistence initOccurrencesJobsDao(ASLSession session) throws SessionExpired, Exception {
        return DaoSession.createOccurrencesJobDao((String)session.getUsername(), (String)session.getScopeName(), (ASLSession)session);
    }

    public static TaxonomyJobPersistence initTaxonomyJobsDao(ASLSession session) throws Exception {
        TaxonomyJobPersistence occurrenceJobPersistence = new TaxonomyJobPersistence(DaoSession.getEntityManagerFactory((ASLSession)session));
        SessionUtil.setCurrentDAOTaxonomyJob((ASLSession)session, (TaxonomyJobPersistence)occurrenceJobPersistence);
        return occurrenceJobPersistence;
    }

    public static OccurrenceJobPersistence createOccurrencesJobDao(String username, String scope, ASLSession session) throws SessionExpired, Exception {
        OccurrenceJobPersistence occurrenceJobPersistence = new OccurrenceJobPersistence(DaoSession.getEntityManagerFactory((ASLSession)session));
        SessionUtil.setCurrentEJBOccurrencesJob((ASLSession)session, (OccurrenceJobPersistence)occurrenceJobPersistence);
        return occurrenceJobPersistence;
    }

    public static ResultRowPersistence initResultRowDao(ASLSession session) throws Exception {
        ResultRowPersistence resultRowPersistence = new ResultRowPersistence(DaoSession.getEntityManagerFactory((ASLSession)session));
        SessionUtil.setCurrentEJBResultRow((ASLSession)session, (ResultRowPersistence)resultRowPersistence);
        return resultRowPersistence;
    }

    public static OccurrenceRowPersistence getOccurrenceDAO(ASLSession session) throws SessionExpired, Exception {
        DaoSession.checkASLSession((ASLSession)session);
        OccurrenceRowPersistence occurrenceEJB = SessionUtil.getCurrentEJBOccurrence((ASLSession)session);
        if (occurrenceEJB == null) {
            occurrenceEJB = DaoSession.initOccurrenceDao((ASLSession)session);
            SessionUtil.setCurrentEJBOccurrence((ASLSession)session, (OccurrenceRowPersistence)occurrenceEJB);
        }
        return occurrenceEJB;
    }

    public static TaxonRowPersistence initTaxonDao(ASLSession session) throws SessionExpired, Exception {
        TaxonRowPersistence taxonRowPersistence = new TaxonRowPersistence(DaoSession.getEntityManagerFactory((ASLSession)session));
        SessionUtil.setCurrentEJBTaxonRow((ASLSession)session, (TaxonRowPersistence)taxonRowPersistence);
        return taxonRowPersistence;
    }

    private static OccurrenceRowPersistence initOccurrenceDao(ASLSession session) throws Exception {
        OccurrenceRowPersistence occurrenceRowPersistence = new OccurrenceRowPersistence(DaoSession.getEntityManagerFactory((ASLSession)session));
        SessionUtil.setCurrentEJBOccurrence((ASLSession)session, (OccurrenceRowPersistence)occurrenceRowPersistence);
        return occurrenceRowPersistence;
    }

    public static TaxonRowPersistence getTaxonDAO(ASLSession session) throws SessionExpired, Exception {
        DaoSession.checkASLSession((ASLSession)session);
        TaxonRowPersistence taxonDao = SessionUtil.getCurrentEJBTaxonRow((ASLSession)session);
        if (taxonDao == null) {
            taxonDao = DaoSession.initTaxonDao((ASLSession)session);
            SessionUtil.setCurrentEJBTaxonRow((ASLSession)session, (TaxonRowPersistence)taxonDao);
        }
        return taxonDao;
    }

    public static TaxonomyRowPersistence getTaxonomyDAO(ASLSession session) throws SessionExpired, Exception {
        DaoSession.checkASLSession((ASLSession)session);
        logger.trace((Object)"In getTaxonomyDAO...");
        TaxonomyRowPersistence taxonItemDAO = SessionUtil.getCurrentEJBTaxonomyItem((ASLSession)session);
        if (taxonItemDAO == null) {
            taxonItemDAO = DaoSession.initTaxonomyItemDao((ASLSession)session, (String)"taxonomyrow");
            SessionUtil.setCurrentEJBTaxonomyItem((ASLSession)session, (TaxonomyRowPersistence)taxonItemDAO);
        }
        return taxonItemDAO;
    }

    private static TaxonomyRowPersistence initTaxonomyItemDao(ASLSession session, String tableName) throws Exception {
        TaxonomyRowPersistence taxonomyRP = new TaxonomyRowPersistence(DaoSession.getEntityManagerFactory((ASLSession)session));
        SessionUtil.setCurrentEJBTaxonomyItem((ASLSession)session, (TaxonomyRowPersistence)taxonomyRP);
        return taxonomyRP;
    }

    public static ResultRowPersistence getResultRowDAO(ASLSession session) throws SessionExpired, Exception {
        DaoSession.checkASLSession((ASLSession)session);
        logger.trace((Object)"In getResultRowDAO...");
        ResultRowPersistence resultRowEJB = SessionUtil.getCurrentEJBResultRow((ASLSession)session);
        if (resultRowEJB == null) {
            resultRowEJB = DaoSession.initResultRowDao((ASLSession)session);
            SessionUtil.setCurrentEJBResultRow((ASLSession)session, (ResultRowPersistence)resultRowEJB);
        }
        return resultRowEJB;
    }
}

