/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.advancedsearch;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelEnum;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelInterface;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceCapability;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class UnfoldFilter
implements AdvancedSearchPanelInterface {
    private Button btnResetAllFilters = new Button("Reset Filters");
    private ContentPanel unfoldFilterPanel = new ContentPanel();
    private CheckBoxGroup checkGroup = new CheckBoxGroup();
    private static Comparator<DataSourceModel> COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;

    public ContentPanel getPanel() {
        this.btnResetAllFilters.setStyleName("button-hyperlink");
        return this.unfoldFilterPanel;
    }

    public UnfoldFilter() {
        this.init();
    }

    private void init() {
        this.unfoldFilterPanel.setHeaderVisible(false);
        this.unfoldFilterPanel.setBodyBorder(false);
        this.unfoldFilterPanel.setLayout((Layout)new FitLayout());
        this.unfoldFilterPanel.setStyleAttribute("marginLeft", "10px");
        this.unfoldFilterPanel.setStyleAttribute("marginRight", "10px");
        this.unfoldFilterPanel.setStyleAttribute("padding", "5px");
        Text text = new Text("Unfold the taxa group by: ");
        text.setStyleAttribute("margin-left", "5px");
        text.setStyleAttribute("margin-right", "5px");
        HorizontalPanel hp = new HorizontalPanel();
        hp.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        hp.add((Widget)text);
        hp.add((Widget)this.checkGroup);
        this.unfoldFilterPanel.add((Widget)hp);
    }

    public String getName() {
        return AdvancedSearchPanelEnum.UNFOLD.getLabel();
    }

    public void resetAdvancedFields() {
    }

    public ArrayList<DataSourceModel> getAvailablePlugIn() {
        return null;
    }

    public void loadDataSource(List<DataSourceModel> result) {
        Collections.sort(result, COMPARATOR);
        if (result != null) {
            for (DataSourceModel dsm : result) {
                System.out.println("Data Source name " + dsm.getName());
                CheckBox check = null;
                for (DataSourceCapability dsc : dsm.getListCapabilities()) {
                    System.out.println("\tData Source capability name: " + dsc.getCapability().getName());
                    if (dsc.getCapability().getName().compareTo(SpeciesCapability.UNFOLD.getName()) != 0) continue;
                    check = this.createCheckBox(dsm, dsc.getCapability().getName());
                    System.out.println("added check " + dsm.getName() + " for UNFOLD");
                    this.checkGroup.add((Field)check);
                }
            }
        }
    }

    private CheckBox createCheckBox(DataSourceModel dsm, String property) {
        CheckBox check = new CheckBox();
        check.setBoxLabel(dsm.getName());
        check.setValueAttribute(dsm.getName());
        check.setData("capability", (Object)dsm);
        check.setToolTip(new ToolTipConfig(dsm.getDescription()));
        return check;
    }

    public List<DataSourceModel> getCheckedGroupList() {
        ArrayList<DataSourceModel> listDS = new ArrayList<DataSourceModel>();
        List values = new ArrayList();
        if (this.checkGroup.getValues().size() > 0) {
            values = this.checkGroup.getValues();
        }
        for (CheckBox checkBox : values) {
            if (!checkBox.isEnabled()) continue;
            listDS.add(new DataSourceModel(checkBox.getValueAttribute(), checkBox.getValueAttribute()));
        }
        if (listDS.size() == 0) {
            return null;
        }
        return listDS;
    }

    public void activeChecks(boolean bool) {
        this.checkGroup.reset();
        this.checkGroup.setEnabled(bool);
    }
}

