/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.ClassificationClient;
import org.gcube.data.spd.client.proxies.ExecutorClient;
import org.gcube.data.spd.client.proxies.ManagerClient;
import org.gcube.data.spd.client.proxies.OccurrenceClient;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.Coordinate;
import org.gcube.data.spd.model.PluginDescription;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.exceptions.InvalidQueryException;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.model.products.ResultElement;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.service.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.model.service.exceptions.UnsupportedPluginException;
import org.gcube.data.spd.model.service.types.CompleteJobStatus;
import org.gcube.data.spd.model.service.types.MetadataDetails;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.portlets.user.speciesdiscovery.server.service.QueryBuilder;
import org.gcube.portlets.user.speciesdiscovery.server.service.SpeciesService;
import org.gcube.portlets.user.speciesdiscovery.server.service.StorageUrlIsEmpty;
import org.gcube.portlets.user.speciesdiscovery.server.service.StreamIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.server.util.StorageUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceCapability;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceRepositoryInfo;
import org.gcube.portlets.user.speciesdiscovery.shared.InvalidJobIdException;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class SpeciesService {
    protected Logger logger = Logger.getLogger(SpeciesService.class);
    protected String scope;
    protected ManagerClient call;
    protected OccurrenceClient occurrencesCall;
    protected ClassificationClient classificationCall;
    protected ExecutorClient executorCall;
    protected String lastQuery = "";

    public SpeciesService() throws Exception {
        System.out.println("CALLING MANAGER ");
        this.call = (ManagerClient)AbstractPlugin.manager().withTimeout(3, TimeUnit.MINUTES).build();
        this.executorCall = (ExecutorClient)AbstractPlugin.executor().withTimeout(3, TimeUnit.MINUTES).build();
        this.occurrencesCall = (OccurrenceClient)AbstractPlugin.occurrences().withTimeout(3, TimeUnit.MINUTES).build();
        this.classificationCall = (ClassificationClient)AbstractPlugin.classification().withTimeout(3, TimeUnit.MINUTES).build();
    }

    public SpeciesService(String scope, boolean instanceOnlyOccurrence) throws Exception {
        this.scope = scope;
        if (instanceOnlyOccurrence) {
            System.out.println("CALLING OCCURRENCE MANAGER ");
            this.occurrencesCall = (OccurrenceClient)AbstractPlugin.occurrences().withTimeout(3, TimeUnit.MINUTES).build();
        }
    }

    public CloseableIterator<ResultElement> searchByFilters(String searchTerm, SearchType searchType, SearchFilters searchFilters) throws SearchServiceException {
        this.logger.trace((Object)("searchByFilters searchTerm: " + searchTerm + " usearchFilters: " + searchFilters));
        try {
            this.logger.trace((Object)"query building...");
            String query = QueryBuilder.buildQuery((String)searchTerm, (SearchType)searchType, (SearchFilters)searchFilters);
            this.logger.trace((Object)("query build - OK " + query));
            return this.searchByQuery(query);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<TaxonomyItem> retrieveTaxonomyById(List<String> ids) throws SearchServiceException {
        this.logger.trace((Object)"retrieveTaxonomyById...");
        try {
            Stream stream = this.classificationCall.getTaxaByIds(ids);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<TaxonomyItem> retrieveSynonymsById(String id) throws SearchServiceException {
        this.logger.trace((Object)"retrieveSynonymsById...");
        try {
            Stream stream = this.classificationCall.getSynonymsById(id);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<ResultElement> searchByQuery(String query) throws SearchServiceException {
        this.logger.trace((Object)("search by Query - query is: " + query));
        try {
            this.lastQuery = query;
            this.logger.trace((Object)"call species service search...");
            Stream stream = this.call.search(query);
            return new StreamIterator(stream);
        }
        catch (UnsupportedPluginException e2) {
            this.lastQuery = "Invalid query";
            String error = "Error calling the Species Service: plugin usupported";
            this.logger.error((Object)("Error calling the Species Service: " + e2.getMessage()), (Throwable)e2);
            throw new SearchServiceException(error);
        }
        catch (InvalidQueryException e1) {
            this.lastQuery = "Invalid query";
            String error = "Error calling the Species Service: query syntax is not valid";
            this.logger.error((Object)("Error calling the Species Service: " + e1.getMessage()), (Throwable)e1);
            throw new SearchServiceException(error);
        }
        catch (Exception e) {
            this.lastQuery = "Invalid query";
            String error = "Error calling the Species Service: an error occurred contacting the service";
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException(error);
        }
    }

    public Stream<ResultElement> searchByQuery2(String query) throws SearchServiceException {
        this.logger.trace((Object)("searchByQuery query: " + query));
        try {
            this.logger.trace((Object)"call species service search...");
            System.out.println("call species service search...");
            return this.call.search(query);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public List<DataSourceModel> getPlugins() throws SearchServiceException {
        this.logger.trace((Object)"getPlugins...");
        try {
            ArrayList<DataSourceModel> listDsModel = new ArrayList<DataSourceModel>();
            System.out.println("setting scope " + this.scope);
            List plugin = this.call.getPluginsDescription();
            if (plugin != null) {
                this.logger.trace((Object)("*****PluginDescription is NOT null - length: " + plugin.size()));
                for (int i = 0; i < plugin.size(); ++i) {
                    PluginDescription pluginDescription = (PluginDescription)plugin.get(i);
                    ArrayList<DataSourceCapability> datasourceCapabilities = new ArrayList<DataSourceCapability>();
                    Map pluginCapabilities = pluginDescription.getSupportedCapabilities();
                    this.logger.info((Object)("getCapabilities for plugin: " + pluginDescription.getName()));
                    for (Map.Entry pluginCapability : pluginCapabilities.entrySet()) {
                        Capabilities capability = (Capabilities)pluginCapability.getKey();
                        this.logger.info((Object)("capability name: " + capability.name()));
                        ArrayList datasourceProperties = new ArrayList();
                        this.logger.info((Object)("capability value: " + pluginCapability.getValue()));
                        for (Conditions condition : (List)pluginCapability.getValue()) {
                            datasourceProperties.addAll(this.getFilterCapabilityFromProperties(condition));
                        }
                        datasourceCapabilities.add(new DataSourceCapability(this.getGxtCapabilityValueFromCapability(capability), datasourceProperties));
                    }
                    RepositoryInfo rep = pluginDescription.getInfo();
                    DataSourceRepositoryInfo dsInfo = new DataSourceRepositoryInfo();
                    if (rep != null) {
                        dsInfo.setLogoUrl(rep.getLogoUrl());
                        dsInfo.setPageUrl(rep.getPageReferenceUrl());
                        dsInfo.setProperties(this.getPropertiesFromRepositoryInfoType(rep));
                        dsInfo.setDescription(rep.getDescription());
                        this.logger.trace((Object)("DataSourceRepositoryInfo :" + dsInfo));
                    }
                    listDsModel.add(new DataSourceModel(pluginDescription.getName(), pluginDescription.getName(), pluginDescription.getDescription(), datasourceCapabilities, dsInfo));
                }
            } else {
                this.logger.trace((Object)"*****PluginDescription is null");
            }
            return listDsModel;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new SearchServiceException("loading the data sources");
        }
    }

    private Map<String, String> getPropertiesFromRepositoryInfoType(RepositoryInfo rep) {
        HashMap<String, String> mapProperties = new HashMap<String, String>();
        if (rep.getProperties() == null) {
            this.logger.trace((Object)"*****Properties From RepositoryInfoType is null");
            return mapProperties;
        }
        for (Map.Entry property : rep.getProperties().entrySet()) {
            mapProperties.put((String)property.getKey(), (String)property.getValue());
        }
        return mapProperties;
    }

    private List<SpeciesCapability> getFilterCapabilityFromProperties(Conditions property) {
        if (property == null) {
            this.logger.info((Object)"Conditions is null");
            return Collections.singletonList(SpeciesCapability.UNKNOWN);
        }
        switch (1.$SwitchMap$org$gcube$data$spd$model$Conditions[property.ordinal()]) {
            case 1: {
                return Arrays.asList(SpeciesCapability.FROMDATE, SpeciesCapability.TODATE);
            }
            case 2: {
                return Arrays.asList(SpeciesCapability.UPPERBOUND, SpeciesCapability.LOWERBOUND);
            }
        }
        return Collections.singletonList(SpeciesCapability.UNKNOWN);
    }

    private SpeciesCapability getGxtCapabilityValueFromCapability(Capabilities capability) {
        switch (1.$SwitchMap$org$gcube$data$spd$model$util$Capabilities[capability.ordinal()]) {
            case 1: {
                return SpeciesCapability.TAXONOMYITEM;
            }
            case 2: {
                return SpeciesCapability.NAMESMAPPING;
            }
            case 3: {
                return SpeciesCapability.RESULTITEM;
            }
            case 4: {
                return SpeciesCapability.SYNONYMS;
            }
            case 5: {
                return SpeciesCapability.UNFOLD;
            }
        }
        return SpeciesCapability.UNKNOWN;
    }

    protected Coordinate convertCoordinate(org.gcube.portlets.user.speciesdiscovery.shared.Coordinate coordinate) {
        return new Coordinate((double)coordinate.getLatitude(), (double)coordinate.getLongitude());
    }

    public CloseableIterator<OccurrencePoint> getOccurrencesByKeys(List<String> keys) throws SearchServiceException {
        try {
            this.logger.trace((Object)("Calling occurrencesCall passing keys: " + keys));
            if (this.occurrencesCall == null) {
                this.logger.warn((Object)"occurrencesCall is null, instancing again...");
                this.occurrencesCall = (OccurrenceClient)AbstractPlugin.occurrences().withTimeout(3, TimeUnit.MINUTES).build();
            }
            Stream stream = this.occurrencesCall.getByKeys(keys);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<OccurrencePoint> getOccurrencesByIds(List<String> ids) throws SearchServiceException {
        try {
            Stream stream = this.occurrencesCall.getByIds(ids);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public String generateGisLayerFromOccurrenceKeys(List<String> occurrenceKeys, String layerTitle, String layerDescr, String author, String credits) throws SearchServiceException {
        try {
            ExecutorClient creator = (ExecutorClient)AbstractPlugin.executor().build();
            Stream keyStream = Streams.convert(occurrenceKeys);
            MetadataDetails details = new MetadataDetails(layerTitle, layerDescr, layerTitle, author, credits, new String[0]);
            return creator.createLayer(keyStream, details);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CompleteJobStatus getGisLayerByJobId(String serverJobId) throws InvalidJobIdException, Exception {
        try {
            ExecutorClient creator = (ExecutorClient)AbstractPlugin.executor().build();
            this.logger.debug((Object)("ExecutorClient is null: " + (creator == null)));
            this.logger.debug((Object)("Get status for job Id: " + serverJobId));
            return creator.getStatus(serverJobId);
        }
        catch (InvalidIdentifierException e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()));
            throw new InvalidJobIdException("Invalid job id: " + serverJobId);
        }
        catch (Exception e) {
            throw new Exception("Service exception: ", e);
        }
    }

    public String getGisLayerResultLinkByJobId(String serverJobId) throws InvalidJobIdException {
        try {
            ExecutorClient creator = (ExecutorClient)AbstractPlugin.executor().build();
            return creator.getResultLink(serverJobId);
        }
        catch (InvalidIdentifierException e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new InvalidJobIdException("Invalid job id: " + serverJobId);
        }
    }

    public void cancelGisLayerByJobId(String serverJobId) {
        try {
            ExecutorClient creator = (ExecutorClient)AbstractPlugin.executor().build();
            creator.removeJob(serverJobId);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
        }
    }

    public StreamIterator<TaxonomyItem> getTaxonChildrenByParentId(String parentId) throws Exception {
        try {
            Stream items = this.classificationCall.getTaxonChildrenById(parentId);
            return new StreamIterator(items);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CompleteJobStatus getTaxonomyJobById(String jobId) {
        CompleteJobStatus status = null;
        try {
            status = this.executorCall.getStatus(jobId);
        }
        catch (InvalidIdentifierException e) {
            this.logger.error((Object)"Error on service for get job by Id - InvalidIdentifierException");
            status = null;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for get job by Id: " + e.getMessage()), (Throwable)e);
            status = null;
        }
        return status;
    }

    public InputStream getTaxonomyJobFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        try {
            String url = this.executorCall.getResultLink(jobIdentifier);
            if (url == null || url.isEmpty()) {
                this.logger.error((Object)("URL returned by species service is: " + url));
                throw new StorageUrlIsEmpty();
            }
            this.logger.trace((Object)("URL returned by species service is: " + url));
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public InputStream getTaxonomyJobErrorFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        try {
            String url = this.executorCall.getErrorLink(jobIdentifier);
            if (url == null || url.isEmpty()) {
                this.logger.error((Object)("URL returned by species service is: " + url));
                throw new StorageUrlIsEmpty();
            }
            this.logger.trace((Object)("URL returned by species service is: " + url));
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving error file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public boolean isAvailableTaxonomyJobErrorFileById(String jobIdentifier) throws Exception {
        try {
            String url = this.executorCall.getErrorLink(jobIdentifier);
            return url != null && !url.isEmpty();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in is Available Taxonomy JobError File: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in is Available Taxonomy JobError File: " + e.getMessage());
        }
    }

    public String createTaxonomyJobForDWCAByChildren(String taxonomyId) throws Exception {
        try {
            return this.executorCall.createDwCAByChildren(taxonomyId);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createTaxonomyJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createTaxonomyJob: " + e.getMessage());
        }
    }

    public String createTaxonomyJobForDWCAByIds(List<String> ids) throws Exception {
        try {
            Stream keysStream = Streams.convert(ids);
            return this.executorCall.createDwCAByIds(keysStream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createTaxonomyJobForDWCA: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createTaxonomyJobForDWCA: " + e.getMessage());
        }
    }

    public void cancelTaxonomyJobById(String jobIdentifier) {
        try {
            this.executorCall.removeJob(jobIdentifier);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for remove job: " + e.getMessage()), (Throwable)e);
        }
    }

    public CompleteJobStatus getOccurrenceJobById(String jobId) {
        try {
            return this.executorCall.getStatus(jobId);
        }
        catch (InvalidIdentifierException e) {
            this.logger.error((Object)"Error on service for get job by Id - InvalidIdentifierException");
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for get job by Id: " + e.getMessage()));
            return null;
        }
    }

    public String createOccurrenceCSVJob(Stream<String> streamKey) throws Exception {
        try {
            return this.executorCall.createCSV(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceCSVJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceCSVJob: " + e.getMessage());
        }
    }

    public String createOccurrenceDARWINCOREJob(Stream<String> streamKey) throws Exception {
        try {
            return this.executorCall.createDarwincoreFromOccurrenceKeys(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceDARWINCOREJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceDARWINCOREJob: " + e.getMessage());
        }
    }

    public String createOccurrenceCSVOpenModellerJob(Stream<String> streamKey) throws Exception {
        try {
            return this.executorCall.createCSVforOM(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceCSVOpenModellerJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceCSVOpenModellerJob: " + e.getMessage());
        }
    }

    public void cancelOccurrenceJobById(String jobIdentifier) {
        try {
            this.executorCall.removeJob(jobIdentifier);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for remove job: " + e.getMessage()), (Throwable)e);
        }
    }

    public InputStream getOccurrenceJobFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        try {
            String url = this.executorCall.getResultLink(jobIdentifier);
            this.logger.trace((Object)("URL returned by species service is: " + url));
            if (url == null || url.isEmpty()) {
                this.logger.error((Object)("URL returned by species service is: " + url));
                throw new StorageUrlIsEmpty();
            }
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public InputStream getOccurrenceJobErrorFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        try {
            String url = this.executorCall.getErrorLink(jobIdentifier);
            this.logger.trace((Object)("URL returned by species service is: " + url));
            if (url == null || url.isEmpty()) {
                this.logger.error((Object)("URL returned by species service is: " + url));
                throw new StorageUrlIsEmpty();
            }
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public boolean isAvailableOccurrenceJobErrorFileById(String jobIdentifier) throws Exception {
        try {
            String url = this.executorCall.getErrorLink(jobIdentifier);
            return url != null && !url.isEmpty();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in is Available Occurrence JobError File: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in is Available Occurrence JobError File: " + e.getMessage());
        }
    }

    public String getLastQuery() {
        return this.lastQuery;
    }
}

