/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.session;

import java.io.Closeable;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.speciesdiscovery.server.session.FetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;

public class Fetcher<T extends FetchingElement>
implements Runnable,
Closeable {
    protected Logger logger = Logger.getLogger(Fetcher.class);
    protected final int MAX_CONSECUTIVE_ATTEMPTS_ON_NULL = 2;
    protected FetchingBuffer<T> buffer;
    protected CloseableIterator<T> source;
    protected boolean complete = false;

    public Fetcher(CloseableIterator<T> source, FetchingBuffer<T> buffer) {
        this.source = source;
        this.complete = false;
        this.buffer = buffer;
    }

    public CloseableIterator<T> getSource() {
        return this.source;
    }

    public void setSource(CloseableIterator<T> source) {
        this.source = source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        FetchingElement next = null;
        int count = 0;
        int countNullItems = 0;
        try {
            while (this.source != null && this.source.hasNext() && !this.complete) {
                try {
                    next = (FetchingElement)this.source.next();
                    if (next != null) {
                        this.logger.debug((Object)("item " + count++ + " fetch new row: " + next.getId()));
                        this.buffer.add(next);
                        countNullItems = 0;
                        continue;
                    }
                    this.logger.warn((Object)("fetch new row is null!! Number of null value/s: " + ++countNullItems));
                    if (2 != countNullItems) continue;
                    this.logger.warn((Object)"Fetched 2 null rows, MAX ATTEMPTS reached, complete fetch true and closing stream!!");
                    this.silentClose();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error in source.next() " + e.getMessage()), (Throwable)e);
                    this.silentClose();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in add row " + e.getMessage()), (Throwable)e);
            this.silentClose();
        }
        if (this.source == null) {
            this.logger.warn((Object)"exit because source iterator is null");
        }
        this.logger.trace((Object)"exit fetch run - complete true");
        this.complete = true;
    }

    protected void silentClose() {
        try {
            this.close();
        }
        catch (IOException e) {
            this.logger.error((Object)"Error during silent close", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.logger.info((Object)"Fetcher closing iterator!!");
        this.complete = true;
        this.source.close();
    }

    public boolean isComplete() {
        return this.complete;
    }
}

