/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;

public class TaxonRowPersistence
extends AbstractPersistence<Taxon> {
    public TaxonRowPersistence(EntityManagerFactory factory) {
        super(factory);
    }

    public int removeAll() throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        int removed = 0;
        try {
            try {
                em.getTransaction().begin();
                removed = em.createQuery("DELETE FROM Taxon").executeUpdate();
                em.getTransaction().commit();
                this.logger.trace((Object)("DELETE FROM Taxon " + removed + " items"));
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in removeAll: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return removed;
    }

    public List<Taxon> getList() throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Taxon> listTaxon = new ArrayList();
        try {
            try {
                Query query = em.createQuery("select t from Taxon t");
                listTaxon = query.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in Taxon - removeAll: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxon;
    }

    public List<Taxon> getList(int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Taxon> listTaxon = new ArrayList();
        try {
            try {
                Query query = em.createQuery("select t from Taxon t");
                query.setFirstResult(startIndex);
                query.setMaxResults(offset);
                listTaxon = query.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in Taxon - getList: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxon;
    }

    public int countItems() throws DatabaseServiceException {
        return this.getList().size();
    }

    public Taxon getItemByKey(Integer id) throws DatabaseServiceException {
        Taxon row;
        block7: {
            this.logger.trace((Object)("getItemByKey id:  " + id));
            EntityManager em = super.createNewManager();
            row = null;
            try {
                try {
                    row = (Taxon)em.getReference(Taxon.class, (Object)id);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error in Taxon - getItemByKey: " + e.getMessage()), (Throwable)e);
                    em.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                em.close();
                throw throwable;
            }
            em.close();
        }
        if (row != null) {
            this.logger.trace((Object)("getItemByKey return row id:  " + row.getId()));
        } else {
            this.logger.trace((Object)"getItemByKey return null");
        }
        return row;
    }

    public List<Taxon> executeCriteriaQuery(CriteriaQuery<Object> criteriaQuery) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Taxon> listTaxon = new ArrayList();
        try {
            try {
                TypedQuery query = em.createQuery(criteriaQuery);
                listTaxon = query.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in Taxon - executeCriteriaQuery: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxon;
    }

    public CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException {
        return this.createNewManager().getCriteriaBuilder();
    }

    public Root<Taxon> rootFrom(CriteriaQuery<Object> cq) {
        return cq.from(Taxon.class);
    }

    public List<Taxon> getList(Map<String, String> filterMap, int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Taxon> listTaxon = new ArrayList();
        try {
            try {
                String queryString = "select t from Taxon t";
                if (filterMap != null && filterMap.size() > 0) {
                    queryString = String.valueOf(queryString) + " where ";
                    for (String param : filterMap.keySet()) {
                        String value = filterMap.get(param);
                        queryString = String.valueOf(queryString) + " t." + param + "=" + value;
                        queryString = String.valueOf(queryString) + "AND";
                    }
                    queryString = queryString.substring(0, queryString.lastIndexOf("AND"));
                }
                Query query = em.createQuery(queryString);
                listTaxon = query.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in Taxon - getList: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxon;
    }

    public List<Taxon> executeTypedQuery(CriteriaQuery<Object> cq, int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Taxon> listTaxon = new ArrayList();
        try {
            try {
                TypedQuery typedQuery = em.createQuery(cq);
                if (startIndex > -1) {
                    typedQuery.setFirstResult(startIndex);
                }
                if (offset > -1) {
                    typedQuery.setMaxResults(offset);
                }
                listTaxon = typedQuery.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in Taxon - executeTypedQuery: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxon;
    }

    public int deleteItemByIdField(String idField) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        int removed = 0;
        try {
            try {
                em.getTransaction().begin();
                removed = em.createQuery("DELETE FROM Taxon t WHERE t.id='" + idField + "'").executeUpdate();
                em.getTransaction().commit();
                this.logger.trace((Object)("Item " + idField + " was deleted from Taxon"));
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in Taxon deleteJobById: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return removed;
    }
}

