/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;

public class TaxonomyRowPersistence
extends AbstractPersistence<TaxonomyRow> {
    public TaxonomyRowPersistence(EntityManagerFactory factory) {
        super(factory);
    }

    public int removeAll() throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        int removed = 0;
        try {
            try {
                em.getTransaction().begin();
                removed = em.createQuery("DELETE FROM TaxonomyRow").executeUpdate();
                em.getTransaction().commit();
                this.logger.trace((Object)("DELETE FROM TaxonomyRow " + removed + " items"));
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in TaxonomyRow - removeAll: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return removed;
    }

    public List<TaxonomyRow> getList() throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<TaxonomyRow> listTaxonomy = new ArrayList();
        try {
            try {
                Query query = em.createQuery("select t from TaxonomyRow t");
                listTaxonomy = query.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in TaxonomyRow - getList: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxonomy;
    }

    public int countItems() throws DatabaseServiceException {
        HashMap<String, String> filterAndMap = new HashMap<String, String>();
        filterAndMap.put("isParent", "false");
        return this.getList(filterAndMap, -1, -1).size();
    }

    public TaxonomyRow getItemByKey(Integer id) throws DatabaseServiceException {
        TaxonomyRow row;
        block7: {
            this.logger.trace((Object)("getItemByKey id:  " + id));
            EntityManager em = super.createNewManager();
            row = null;
            try {
                try {
                    row = (TaxonomyRow)em.getReference(TaxonomyRow.class, (Object)id);
                }
                catch (Exception e) {
                    this.logger.error((Object)"An error occurred in TaxonomyRow - getItemByKey ", (Throwable)e);
                    em.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                em.close();
                throw throwable;
            }
            em.close();
        }
        if (row != null) {
            this.logger.trace((Object)("getItemByKey return row:  " + row.getId() + ", service id: " + row.getServiceId()));
        } else {
            this.logger.trace((Object)"getItemByKey return null");
        }
        return row;
    }

    public List<TaxonomyRow> executeCriteriaQuery(CriteriaQuery<Object> criteriaQuery) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<TaxonomyRow> listTaxonomyRow = new ArrayList();
        try {
            try {
                TypedQuery query = em.createQuery(criteriaQuery);
                listTaxonomyRow = query.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)"An error occurred in TaxonomyRow - executeCriteriaQuery ", (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxonomyRow;
    }

    public CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException {
        return this.createNewManager().getCriteriaBuilder();
    }

    public Root<TaxonomyRow> rootFrom(CriteriaQuery<Object> cq) {
        return cq.from(TaxonomyRow.class);
    }

    public List<TaxonomyRow> getList(int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        List<Object> listTaxonomyRow = new ArrayList<TaxonomyRow>();
        try {
            try {
                Query query = em.createQuery("select t from TaxonomyRow t");
                query.setFirstResult(startIndex);
                query.setMaxResults(offset);
                listTaxonomyRow = query.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)"An error occurred in TaxonomyRow - get List ", (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxonomyRow;
    }

    public List<TaxonomyRow> getList(Map<String, String> filterMap, int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        List<Object> listTaxonomyRow = new ArrayList<TaxonomyRow>();
        try {
            try {
                String queryString = "select t from TaxonomyRow t";
                if (filterMap != null && filterMap.size() > 0) {
                    queryString = String.valueOf(queryString) + " where ";
                    for (String param : filterMap.keySet()) {
                        String value = filterMap.get(param);
                        queryString = String.valueOf(queryString) + " t." + param + "=" + value;
                        queryString = String.valueOf(queryString) + "AND";
                    }
                    queryString = queryString.substring(0, queryString.lastIndexOf("AND"));
                }
                Query query = em.createQuery(queryString);
                if (startIndex > -1) {
                    query.setFirstResult(startIndex);
                }
                if (offset > -1) {
                    query.setMaxResults(offset);
                }
                listTaxonomyRow = query.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)"An error occurred in TaxonomyRow - get List ", (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listTaxonomyRow;
    }

    public List<TaxonomyRow> executeTypedQuery(CriteriaQuery cq, int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        List<Object> listOJ = new ArrayList<TaxonomyRow>();
        try {
            try {
                TypedQuery typedQuery = em.createQuery(cq);
                if (startIndex > -1) {
                    typedQuery.setFirstResult(startIndex);
                }
                if (offset > -1) {
                    typedQuery.setMaxResults(offset);
                }
                listOJ = typedQuery.getResultList();
            }
            catch (Exception e) {
                this.logger.error((Object)"An error occurred in TaxonomyRow - executeTypedQuery ", (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return listOJ;
    }

    public int deleteItemByIdField(String idField) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        int removed = 0;
        try {
            try {
                em.getTransaction().begin();
                removed = em.createQuery("DELETE FROM TaxonomyRow t WHERE t.id='" + idField + "'").executeUpdate();
                em.getTransaction().commit();
                this.logger.trace((Object)("Item " + idField + " was deleted from TaxonomyRow"));
            }
            catch (Exception e) {
                this.logger.error((Object)("Error in TaxonomyRow deleteJobById: " + e.getMessage()), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return removed;
    }
}

