/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.Occurrence;

public class OccurrenceRowPersistence
extends AbstractPersistence<Occurrence> {
    protected CriteriaBuilder criteriaBuilder;
    protected CriteriaQuery<Object> criteriaQuery;
    protected Root<Occurrence> rootFrom;
    protected GCUBELog logger = new GCUBELog(OccurrenceRowPersistence.class);

    public OccurrenceRowPersistence(EntityManagerFactory factory) throws DatabaseServiceException {
        super(factory);
        this.criteriaBuilder = super.createNewManager().getCriteriaBuilder();
    }

    public Root<Occurrence> rootFrom(CriteriaQuery<Object> cq) {
        return cq.from(Occurrence.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Occurrence> getList() throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Occurrence> listResultRow = new ArrayList();
        try {
            Query query = em.createQuery("select t from Occurrence t");
            listResultRow = query.getResultList();
        }
        finally {
            em.close();
        }
        return listResultRow;
    }

    public int countItems() throws DatabaseServiceException {
        return this.getList().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Occurrence> executeCriteriaQuery(CriteriaQuery<Object> criteriaQuery) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Occurrence> listResultRow = new ArrayList();
        try {
            TypedQuery query = em.createQuery(criteriaQuery);
            listResultRow = query.getResultList();
        }
        finally {
            em.close();
        }
        return listResultRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Occurrence getItemByKey(Integer id) throws DatabaseServiceException {
        this.logger.trace((Object)("getItemByKey id:  " + id));
        EntityManager em = super.createNewManager();
        Occurrence row = null;
        try {
            row = (Occurrence)em.getReference(Occurrence.class, (Object)id);
        }
        finally {
            em.close();
        }
        if (row != null) {
            this.logger.trace((Object)("getItemByKey return row:  " + row.getId() + ", service id: " + row.getServiceId()));
        } else {
            this.logger.trace((Object)"getItemByKey return null");
        }
        return row;
    }

    public CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException {
        return this.createNewManager().getCriteriaBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAll() throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        int removed = 0;
        try {
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM Occurrence").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("DELETE FROM Occurrence " + removed + " items"));
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in removeAll: " + e.getMessage()), (Throwable)e);
        }
        finally {
            em.close();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Occurrence> getList(int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Occurrence> listOccurrence = new ArrayList();
        try {
            Query query = em.createQuery("select t from Occurrence t");
            query.setFirstResult(startIndex);
            query.setMaxResults(offset);
            listOccurrence = query.getResultList();
        }
        finally {
            em.close();
        }
        return listOccurrence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Occurrence> getList(Map<String, String> filterMap, int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Occurrence> listOccurrence = new ArrayList();
        try {
            String queryString = "select t from Occurrence t";
            if (filterMap != null && filterMap.size() > 0) {
                queryString = queryString + " where ";
                for (String param : filterMap.keySet()) {
                    String value = filterMap.get(param);
                    queryString = queryString + " t." + param + "=" + value;
                    queryString = queryString + "AND";
                }
                queryString = queryString.substring(0, queryString.lastIndexOf("AND"));
            }
            Query query = em.createQuery(queryString);
            if (startIndex > -1) {
                query.setFirstResult(startIndex);
            }
            if (offset > -1) {
                query.setMaxResults(offset);
            }
            listOccurrence = query.getResultList();
        }
        finally {
            em.close();
        }
        return listOccurrence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Occurrence> executeTypedQuery(CriteriaQuery<Object> cq, int startIndex, int offset) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        ArrayList<Occurrence> listOJ = new ArrayList();
        try {
            TypedQuery typedQuery = em.createQuery(cq);
            if (startIndex > -1) {
                typedQuery.setFirstResult(startIndex);
            }
            if (offset > -1) {
                typedQuery.setMaxResults(offset);
            }
            listOJ = typedQuery.getResultList();
        }
        finally {
            em.close();
        }
        return listOJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteItemByIdField(String idField) throws DatabaseServiceException {
        EntityManager em = super.createNewManager();
        int removed = 0;
        try {
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM Occurrence t WHERE t.id='" + idField + "'").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("Item " + idField + " was deleted from Occurrence"));
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in Occurrence deleteJobById: " + e.getMessage()), (Throwable)e);
        }
        finally {
            em.close();
        }
        return removed;
    }
}

