/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.client.proxies.Executor;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.client.proxies.Occurrence;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.Coordinate;
import org.gcube.data.spd.model.PluginDescription;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.exceptions.InvalidQueryException;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.model.products.ResultElement;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.stubs.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.stubs.exceptions.UnsupportedPluginException;
import org.gcube.data.spd.stubs.types.Status;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.portlets.user.speciesdiscovery.server.service.QueryBuilder;
import org.gcube.portlets.user.speciesdiscovery.server.service.StorageUrlIsEmpty;
import org.gcube.portlets.user.speciesdiscovery.server.service.StreamIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.IteratorPointInfo;
import org.gcube.portlets.user.speciesdiscovery.server.util.StorageUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceCapability;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceRepositoryInfo;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class SpeciesService {
    protected Logger logger = Logger.getLogger(SpeciesService.class);
    protected GCUBEScope scope;
    protected ASLSession session;
    protected Manager call;
    protected Occurrence occurrencesCall;
    protected Classification classificationCall;
    protected Executor executorCall;
    protected String lastQuery = "";
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$spd$model$Conditions;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$spd$model$util$Capabilities;

    public SpeciesService(GCUBEScope scope, ASLSession session) throws Exception {
        this(scope);
        this.session = session;
    }

    public SpeciesService(GCUBEScope scope) throws Exception {
        this.scope = scope;
        ScopeProvider.instance.set(scope.toString());
        System.out.println("CALLING MANAGER ");
        this.call = (Manager)AbstractPlugin.manager().withTimeout(3, TimeUnit.MINUTES).build();
        this.executorCall = (Executor)AbstractPlugin.executor().withTimeout(3, TimeUnit.MINUTES).build();
        this.occurrencesCall = (Occurrence)AbstractPlugin.occurrence().withTimeout(3, TimeUnit.MINUTES).build();
        this.classificationCall = (Classification)AbstractPlugin.classification().withTimeout(3, TimeUnit.MINUTES).build();
    }

    public SpeciesService(GCUBEScope scope, boolean instanceOnlyOccurrence) throws Exception {
        this.scope = scope;
        if (instanceOnlyOccurrence) {
            ScopeProvider.instance.set(scope.toString());
            System.out.println("CALLING OCCURRENCE MANAGER ");
            this.occurrencesCall = (Occurrence)AbstractPlugin.occurrence().withTimeout(3, TimeUnit.MINUTES).build();
        }
    }

    public CloseableIterator<ResultElement> searchByFilters(String searchTerm, SearchType searchType, SearchFilters searchFilters) throws SearchServiceException {
        this.logger.trace((Object)("searchByFilters searchTerm: " + searchTerm + " usearchFilters: " + searchFilters));
        try {
            this.logger.trace((Object)"query building...");
            String query = QueryBuilder.buildQuery((String)searchTerm, (SearchType)searchType, (SearchFilters)searchFilters);
            this.logger.trace((Object)("query build - OK " + query));
            return this.searchByQuery(query);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<TaxonomyItem> retrieveTaxonomyById(Stream<String> streamIds) throws SearchServiceException {
        this.logger.trace((Object)"retrieveTaxonomyById...");
        try {
            ScopeProvider.instance.set(this.scope.toString());
            Stream stream = this.classificationCall.getTaxaByIds(streamIds);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<TaxonomyItem> retrieveSynonymsById(String id) throws SearchServiceException {
        this.logger.trace((Object)"retrieveSynonymsById...");
        try {
            ScopeProvider.instance.set(this.scope.toString());
            Stream stream = this.classificationCall.getSynonymsById(id);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<ResultElement> searchByQuery(String query) throws SearchServiceException {
        this.logger.trace((Object)("search by Query - query is: " + query));
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.lastQuery = query;
            this.logger.trace((Object)"call species service search...");
            Stream stream = this.call.search(query);
            return new StreamIterator(stream);
        }
        catch (UnsupportedPluginException e2) {
            this.lastQuery = "Invalid query";
            String error = "Error calling the Species Service: plugin usupported";
            this.logger.error((Object)("Error calling the Species Service: " + e2.getMessage()), (Throwable)e2);
            throw new SearchServiceException(error);
        }
        catch (InvalidQueryException e1) {
            this.lastQuery = "Invalid query";
            String error = "Error calling the Species Service: query syntax is not valid";
            this.logger.error((Object)("Error calling the Species Service: " + e1.getMessage()), (Throwable)e1);
            throw new SearchServiceException(error);
        }
        catch (Exception e) {
            this.lastQuery = "Invalid query";
            String error = "Error calling the Species Service: an error occurred contacting the service";
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException(error);
        }
    }

    public Stream<ResultElement> searchByQuery2(String query) throws SearchServiceException {
        this.logger.trace((Object)("searchByQuery query: " + query));
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.logger.trace((Object)"call species service search...");
            System.out.println("call species service search...");
            return this.call.search(query);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public List<DataSourceModel> getPlugins() throws SearchServiceException {
        this.logger.trace((Object)"getPlugins...");
        try {
            ArrayList<DataSourceModel> listDsModel = new ArrayList<DataSourceModel>();
            ScopeProvider.instance.set(this.scope.toString());
            System.out.println("setting scope " + this.scope);
            List plugin = this.call.getPluginsDescription();
            if (plugin != null) {
                this.logger.trace((Object)("*****PluginDescription is NOT null - length: " + plugin.size()));
                int i = 0;
                while (i < plugin.size()) {
                    PluginDescription pluginDescription = (PluginDescription)plugin.get(i);
                    ArrayList<DataSourceCapability> datasourceCapabilities = new ArrayList<DataSourceCapability>();
                    Map pluginCapabilities = pluginDescription.getSupportedCapabilities();
                    this.logger.trace((Object)("getCapabilities for..." + pluginDescription.getName()));
                    for (Map.Entry pluginCapability : pluginCapabilities.entrySet()) {
                        Capabilities capability = (Capabilities)pluginCapability.getKey();
                        ArrayList datasourceProperties = new ArrayList();
                        for (Conditions condition : (List)pluginCapability.getValue()) {
                            datasourceProperties.addAll(this.getFilterCapabilityFromProperties(condition));
                        }
                        datasourceCapabilities.add(new DataSourceCapability(this.getGxtCapabilityValueFromCapability(capability), datasourceProperties));
                    }
                    RepositoryInfo rep = pluginDescription.getInfo();
                    DataSourceRepositoryInfo dsInfo = new DataSourceRepositoryInfo();
                    if (rep != null) {
                        dsInfo.setLogoUrl(rep.getLogoUrl());
                        dsInfo.setPageUrl(rep.getPageReferenceUrl());
                        dsInfo.setProperties(this.getPropertiesFromRepositoryInfoType(rep));
                        dsInfo.setDescription(rep.getDescription());
                        this.logger.trace((Object)("DataSourceRepositoryInfo :" + dsInfo));
                    }
                    listDsModel.add(new DataSourceModel(pluginDescription.getName(), pluginDescription.getName(), pluginDescription.getDescription(), datasourceCapabilities, dsInfo));
                    ++i;
                }
            } else {
                this.logger.trace((Object)"*****PluginDescription is null");
            }
            return listDsModel;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new SearchServiceException("loading the data sources");
        }
    }

    private Map<String, String> getPropertiesFromRepositoryInfoType(RepositoryInfo rep) {
        HashMap<String, String> mapProperties = new HashMap<String, String>();
        if (rep.getProperties() == null) {
            this.logger.trace((Object)"*****Properties From RepositoryInfoType is null");
            return mapProperties;
        }
        for (Map.Entry property : rep.getProperties().entrySet()) {
            mapProperties.put((String)property.getKey(), (String)property.getValue());
        }
        return mapProperties;
    }

    /*
     * Exception decompiling
     */
    private List<SpeciesCapability> getFilterCapabilityFromProperties(Conditions property) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private SpeciesCapability getGxtCapabilityValueFromCapability(Capabilities capability) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Coordinate convertCoordinate(org.gcube.portlets.user.speciesdiscovery.shared.Coordinate coordinate) {
        return new Coordinate((double)coordinate.getLatitude(), (double)coordinate.getLongitude());
    }

    public CloseableIterator<OccurrencePoint> getOccurrencesByKeys(List<String> keys) throws SearchServiceException {
        try {
            Stream keysStream = Streams.convert(keys);
            ScopeProvider.instance.set(this.scope.toString());
            Stream stream = this.occurrencesCall.getByKeys(keysStream);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public CloseableIterator<OccurrencePoint> getOccurrencesByIds(List<String> ids) throws SearchServiceException {
        try {
            Stream idsStream = Streams.convert(ids);
            ScopeProvider.instance.set(this.scope.toString());
            Stream stream = this.occurrencesCall.getByIds(idsStream);
            return new StreamIterator(stream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public String generateMapFromOccurrencePoints(IteratorPointInfo streamKey) throws SearchServiceException {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.occurrencesCall.createLayer((Stream)streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException("Error calling the Species Service: " + e.getMessage());
        }
    }

    public StreamIterator<TaxonomyItem> getTaxonChildrenByParentId(String parentId) throws Exception {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            Stream items = this.classificationCall.getTaxonChildrenById(parentId);
            return new StreamIterator(items);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error calling the Species Service: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error calling the Species Service: " + e.getMessage());
        }
    }

    public Status getTaxonomyJobById(String jobId) {
        ScopeProvider.instance.set(this.scope.toString());
        Status status = null;
        try {
            status = this.executorCall.getStatus(jobId);
        }
        catch (InvalidIdentifierException e) {
            this.logger.error((Object)"Error on service for get job by Id - InvalidIdentifierException");
            status = null;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for get job by Id: " + e.getMessage()), (Throwable)e);
            status = null;
        }
        return status;
    }

    public InputStream getTaxonomyJobFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        ScopeProvider.instance.set(this.scope.toString());
        try {
            String url = this.executorCall.getResultLink(jobIdentifier);
            if (url == null || url.isEmpty()) {
                this.logger.error((Object)("URL returned by species service is: " + url));
                throw new StorageUrlIsEmpty();
            }
            this.logger.trace((Object)("URL returned by species service is: " + url));
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public InputStream getTaxonomyJobErrorFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        ScopeProvider.instance.set(this.scope.toString());
        try {
            String url = this.executorCall.getErrorLink(jobIdentifier);
            if (url == null || url.isEmpty()) {
                this.logger.error((Object)("URL returned by species service is: " + url));
                throw new StorageUrlIsEmpty();
            }
            this.logger.trace((Object)("URL returned by species service is: " + url));
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving error file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public boolean isAvailableTaxonomyJobErrorFileById(String jobIdentifier) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        try {
            String url = this.executorCall.getErrorLink(jobIdentifier);
            return url != null && !url.isEmpty();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in is Available Taxonomy JobError File: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in is Available Taxonomy JobError File: " + e.getMessage());
        }
    }

    public String createTaxonomyJobForDWCAByChildren(String taxonomyId) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        try {
            return this.executorCall.createDwCAByChildren(taxonomyId);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createTaxonomyJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createTaxonomyJob: " + e.getMessage());
        }
    }

    public String createTaxonomyJobForDWCAByIds(List<String> ids) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        try {
            Stream keysStream = Streams.convert(ids);
            return this.executorCall.createDwCAByIds(keysStream);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createTaxonomyJobForDWCA: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createTaxonomyJobForDWCA: " + e.getMessage());
        }
    }

    public void cancelTaxonomyJobById(String jobIdentifier) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.executorCall.removeJob(jobIdentifier);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for remove job: " + e.getMessage()), (Throwable)e);
        }
    }

    public Status getOccurrenceJobById(String jobId) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.executorCall.getStatus(jobId);
        }
        catch (InvalidIdentifierException e) {
            this.logger.error((Object)"Error on service for get job by Id - InvalidIdentifierException");
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for get job by Id: " + e.getMessage()));
            return null;
        }
    }

    public String createOccurrenceCSVJob(Stream<String> streamKey) throws Exception {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.executorCall.createCSV(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceCSVJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceCSVJob: " + e.getMessage());
        }
    }

    public String createOccurrenceDARWINCOREJob(Stream<String> streamKey) throws Exception {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.executorCall.createDarwincoreFromOccurrenceKeys(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceDARWINCOREJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceDARWINCOREJob: " + e.getMessage());
        }
    }

    public String createOccurrenceCSVOpenModellerJob(Stream<String> streamKey) throws Exception {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            return this.executorCall.createCSVforOM(streamKey);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in createOccurrenceCSVOpenModellerJob: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in createOccurrenceCSVOpenModellerJob: " + e.getMessage());
        }
    }

    public void cancelOccurrenceJobById(String jobIdentifier) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            this.executorCall.removeJob(jobIdentifier);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on service for remove job: " + e.getMessage()), (Throwable)e);
        }
    }

    public InputStream getOccurrenceJobFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        ScopeProvider.instance.set(this.scope.toString());
        try {
            String url = this.executorCall.getResultLink(jobIdentifier);
            this.logger.trace((Object)("URL returned by species service is: " + url));
            if (url == null || url.isEmpty()) {
                this.logger.error((Object)("URL returned by species service is: " + url));
                throw new StorageUrlIsEmpty();
            }
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public InputStream getOccurrenceJobErrorFileById(String jobIdentifier) throws Exception {
        InputStream is = null;
        ScopeProvider.instance.set(this.scope.toString());
        try {
            String url = this.executorCall.getErrorLink(jobIdentifier);
            this.logger.trace((Object)("URL returned by species service is: " + url));
            if (url == null || url.isEmpty()) {
                this.logger.error((Object)("URL returned by species service is: " + url));
                throw new StorageUrlIsEmpty();
            }
            is = StorageUtil.getInputStreamByStorageClient((String)url);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error saving file: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error saving file: " + e.getMessage());
        }
        return is;
    }

    public boolean isAvailableOccurrenceJobErrorFileById(String jobIdentifier) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        try {
            String url = this.executorCall.getErrorLink(jobIdentifier);
            return url != null && !url.isEmpty();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in is Available Occurrence JobError File: " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in is Available Occurrence JobError File: " + e.getMessage());
        }
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$spd$model$Conditions() {
        if ($SWITCH_TABLE$org$gcube$data$spd$model$Conditions != null) {
            return $SWITCH_TABLE$org$gcube$data$spd$model$Conditions;
        }
        int[] nArray = new int[Conditions.values().length];
        try {
            nArray[Conditions.COORDINATE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Conditions.DATE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$spd$model$Conditions = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$spd$model$util$Capabilities() {
        if ($SWITCH_TABLE$org$gcube$data$spd$model$util$Capabilities != null) {
            return $SWITCH_TABLE$org$gcube$data$spd$model$util$Capabilities;
        }
        int[] nArray = new int[Capabilities.values().length];
        try {
            nArray[Capabilities.Classification.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Capabilities.Expansion.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Capabilities.NamesMapping.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Capabilities.Occurrence.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Capabilities.Unfold.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$spd$model$util$Capabilities = nArray;
        return nArray;
    }
}

