/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.windowdetail;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.WindowListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchEvent;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.GridField;
import org.gcube.portlets.user.speciesdiscovery.client.util.OccurencesGridFields;
import org.gcube.portlets.user.speciesdiscovery.client.util.Util;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSourceManager;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamPagingLoader;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamPagingToolBar;
import org.gcube.portlets.user.speciesdiscovery.client.windowdetail.DetailsFiller;
import org.gcube.portlets.user.speciesdiscovery.client.windowdetail.ResultRowDetailsFiller;
import org.gcube.portlets.user.speciesdiscovery.client.windowdetail.TaxonomyRowDetailsFiller;
import org.gcube.portlets.user.speciesdiscovery.client.windowdetail.ViewDetailsWindow;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class ViewDetailsWindow
extends Window {
    protected final ViewDetailsWindow INSTANCE;
    protected StreamPagingLoader loader;
    protected int count = 0;
    private ContentPanel container = new ContentPanel();
    private TabPanel tabPanel = new TabPanel();
    private TabItem tabItemOccrs = new TabItem("Occurrence points");
    private TabItem tabItemDetails = new TabItem("Details");
    private ContentPanel panelDetails = new ContentPanel();
    private ContentPanel panelOccurrences = new ContentPanel();
    private int width = 900;
    private int height = 600;
    private int widthPanelOccurrences = 1200;
    private int heightPanelOccurrences = this.height - 70;
    public static final String FIVEPX = "5px";
    private ToolBar toolbarOccurrences;
    private DataSourceManager dataSourceManager;
    private ToolBar toolbarTaxonomy;
    private boolean isSearchByCommonName = false;
    private Timer timerGetCountOfOccurrences;
    private DetailsFiller detailsFiller;
    private SearchEvent lastSearchEvent;

    public ViewDetailsWindow(SearchEvent lastSearchEvent) {
        this.INSTANCE = this;
        this.setCollapsible(false);
        this.setMaximizable(true);
        this.dataSourceManager = DataSourceManager.getInstance();
        this.lastSearchEvent = lastSearchEvent;
        if (lastSearchEvent.getType().equals((Object)SearchType.BY_COMMON_NAME)) {
            this.isSearchByCommonName = true;
        }
        this.container.setHeaderVisible(false);
        this.container.setBodyBorder(false);
        this.container.setLayout((Layout)new FitLayout());
        this.setSize(this.width, this.height);
        this.setPlain(true);
        this.setModal(false);
        this.setBlinkModal(false);
        this.setHeading("View Details");
        this.setLayout((Layout)new FitLayout());
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addListener(Events.Resize, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabPanel = new TabPanel();
        this.tabPanel.setBorders(false);
        if (lastSearchEvent.getResultType().getName().compareTo(SpeciesCapability.RESULTITEM.getName()) == 0) {
            this.toolbarOccurrences = this.createToolbarOccurrences();
            this.createTabItemDisplayResultItem();
        } else if (lastSearchEvent.getResultType().getName().compareTo(SpeciesCapability.TAXONOMYITEM.getName()) == 0) {
            this.toolbarTaxonomy = this.createToolbarTaxonomy();
            this.cretateTabItemDisplayTaxonomyItem();
        }
        this.container.add((Widget)this.tabPanel, (LayoutData)new FitData(4));
        this.add((Component)this.container);
        this.show();
    }

    protected void windowResize(int width, int height) {
        if (width > this.widthPanelOccurrences) {
            this.panelOccurrences.setWidth(width - 20);
        } else {
            this.panelOccurrences.setWidth(this.widthPanelOccurrences);
        }
        if (height > this.heightPanelOccurrences) {
            this.panelOccurrences.setHeight(height - 70);
        } else {
            this.panelOccurrences.setHeight(this.heightPanelOccurrences);
        }
    }

    private void cretateTabItemDisplayTaxonomyItem() {
        this.tabItemDetails.setScrollMode(Style.Scroll.AUTO);
        ContentPanel cpDetailsTaxonomy = new ContentPanel();
        cpDetailsTaxonomy.setHeaderVisible(false);
        cpDetailsTaxonomy.setBodyBorder(false);
        cpDetailsTaxonomy.add((Widget)this.panelDetails);
        cpDetailsTaxonomy.setTopComponent((Component)this.toolbarTaxonomy);
        this.tabItemDetails.add((Widget)cpDetailsTaxonomy);
        this.panelDetails.setHeaderVisible(false);
        this.panelDetails.setBodyBorder(false);
        this.panelDetails.setStyleAttribute("padding-left", FIVEPX);
        this.panelDetails.setStyleAttribute("padding-right", FIVEPX);
        this.panelDetails.setStyleAttribute("padding-bottom", FIVEPX);
        this.panelDetails.setStyleAttribute("margin-left", FIVEPX);
        this.panelDetails.setStyleAttribute("margin-right", FIVEPX);
        this.panelDetails.setStyleAttribute("margin-bottom", FIVEPX);
        this.tabItemDetails.add((Widget)this.panelDetails);
        this.setFocusWidget((Widget)this.getButtonBar().getItem(0));
        this.tabItemDetails.mask("Loading...", "x-mask-loading");
        this.enableToolbarTaxonomy(false);
        this.loadStructuresAndFillingPage(SpeciesCapability.TAXONOMYITEM);
        this.tabPanel.add(this.tabItemDetails);
    }

    private void createTabItemDisplayResultItem() {
        this.tabItemOccrs.setToolTip(new ToolTipConfig("Show Occurrences", "Shows occurences points from selected results."));
        this.tabItemDetails.setScrollMode(Style.Scroll.AUTO);
        this.panelDetails.setHeaderVisible(false);
        this.panelDetails.setBodyBorder(false);
        this.panelDetails.setStyleAttribute("padding", FIVEPX);
        this.panelDetails.setStyleAttribute("margin", FIVEPX);
        this.panelOccurrences.setHeaderVisible(false);
        this.panelOccurrences.setBodyBorder(false);
        this.panelOccurrences.setScrollMode(Style.Scroll.AUTO);
        this.panelOccurrences.setSize(this.widthPanelOccurrences, this.heightPanelOccurrences);
        this.panelOccurrences.setLayout((Layout)new FitLayout());
        this.panelOccurrences.setTopComponent((Component)this.toolbarOccurrences);
        this.tabItemDetails.add((Widget)this.panelDetails);
        this.tabItemOccrs.add((Widget)this.panelOccurrences);
        this.setFocusWidget((Widget)this.getButtonBar().getItem(0));
        this.createOccurrencesWindow();
        this.tabItemDetails.mask("Loading...", "x-mask-loading");
        this.enableToolbarOccurrence(false);
        this.loadStructuresAndFillingPage(SpeciesCapability.RESULTITEM);
        this.tabPanel.add(this.tabItemDetails);
        this.tabPanel.add(this.tabItemOccrs);
    }

    private void enableToolbarOccurrence(boolean bool) {
        this.toolbarOccurrences.setEnabled(bool);
    }

    private void enableToolbarTaxonomy(boolean bool) {
        this.toolbarTaxonomy.setEnabled(bool);
    }

    public void loadStructuresAndFillingPage(SpeciesCapability capability) {
        if (capability.getName().compareTo(SpeciesCapability.RESULTITEM.getName()) == 0) {
            ResultRowDetailsFiller resultRowFiller = new ResultRowDetailsFiller(this.tabItemDetails, this.toolbarOccurrences, this.panelDetails, this.lastSearchEvent);
            resultRowFiller.loadStructuresAndFillingPage();
            this.detailsFiller = resultRowFiller;
        } else if (capability.getName().compareTo(SpeciesCapability.TAXONOMYITEM.getName()) == 0) {
            TaxonomyRowDetailsFiller taxonomyFiller = new TaxonomyRowDetailsFiller(this.tabItemDetails, this.toolbarTaxonomy, this.tabPanel, this.panelDetails, this.lastSearchEvent);
            taxonomyFiller.loadStructuresAndFillingPage();
            this.detailsFiller = taxonomyFiller;
        }
    }

    public ToolBar createToolbarTaxonomy() {
        ToolBar toolbar = new ToolBar();
        Button btnTaxonomyMenu = new Button("Save Taxonomy Items");
        Menu formatSubMenu = new Menu();
        btnTaxonomyMenu.setMenu(formatSubMenu);
        btnTaxonomyMenu.setScale(Style.ButtonScale.SMALL);
        btnTaxonomyMenu.setIconAlign(Style.IconAlign.TOP);
        btnTaxonomyMenu.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        btnTaxonomyMenu.setToolTip(new ToolTipConfig("Save Taxonomy Items", "Save taxonomy items from selected results."));
        MenuItem darwinCoreArchiveItem = new MenuItem("Darwin Core Archive");
        darwinCoreArchiveItem.setToolTip(new ToolTipConfig("Saves in Darwin Core Archive format"));
        darwinCoreArchiveItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        formatSubMenu.add((Component)darwinCoreArchiveItem);
        toolbar.add((Component)btnTaxonomyMenu);
        return toolbar;
    }

    public ToolBar createToolbarOccurrences() {
        ToolBar toolbar = new ToolBar();
        Button btnShowInGisViewer = new Button("Show in Gis Viewer");
        btnShowInGisViewer.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGisProducts()));
        btnShowInGisViewer.setToolTip(new ToolTipConfig("Show in Gis Viewer", "Show occurences points from selected results in a Gis Viewer Map."));
        btnShowInGisViewer.setScale(Style.ButtonScale.SMALL);
        btnShowInGisViewer.setIconAlign(Style.IconAlign.TOP);
        btnShowInGisViewer.setArrowAlign(Style.ButtonArrowAlign.BOTTOM);
        btnShowInGisViewer.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button btnOccurrencesMenu = new Button("Save Occurrences");
        Menu formatSubMenu = new Menu();
        btnOccurrencesMenu.setMenu(formatSubMenu);
        btnOccurrencesMenu.setScale(Style.ButtonScale.SMALL);
        btnOccurrencesMenu.setIconAlign(Style.IconAlign.TOP);
        btnOccurrencesMenu.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        btnOccurrencesMenu.setToolTip(new ToolTipConfig("Save Occurrences", "Save occurences points from selected results."));
        MenuItem csvFormatItem = new MenuItem("CSV");
        csvFormatItem.setToolTip(new ToolTipConfig("Saves in CSV file format"));
        csvFormatItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        formatSubMenu.add((Component)csvFormatItem);
        Menu csvTypeMenu = new Menu();
        MenuItem csvStandard = new MenuItem("plain CSV");
        csvStandard.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        MenuItem csvStandardByDataSource = new MenuItem("plain CSV (by Data Source)");
        csvStandardByDataSource.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        MenuItem csvOpenModeller = new MenuItem("openModeller CSV");
        csvOpenModeller.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        MenuItem csvOpenModellerByDataSource = new MenuItem("openModeller CSV (by Data Source)");
        csvOpenModellerByDataSource.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        csvTypeMenu.add((Component)csvStandard);
        csvTypeMenu.add((Component)csvStandardByDataSource);
        csvTypeMenu.add((Component)csvOpenModeller);
        csvTypeMenu.add((Component)csvOpenModellerByDataSource);
        csvFormatItem.setSubMenu(csvTypeMenu);
        MenuItem darwinCoreFormatItem = new MenuItem("Darwin Core");
        darwinCoreFormatItem.setToolTip(new ToolTipConfig("Saves in Darwin Core file format"));
        darwinCoreFormatItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        formatSubMenu.add((Component)darwinCoreFormatItem);
        toolbar.add((Component)btnOccurrencesMenu);
        toolbar.add((Component)new SeparatorToolItem());
        toolbar.add((Component)btnShowInGisViewer);
        return toolbar;
    }

    protected void initLoader() {
        this.loader = new StreamPagingLoader(25);
        this.loader.setDataSource(this.dataSourceManager.getDataSourceByResultType(SpeciesCapability.OCCURRENCESPOINTS));
    }

    public void createOccurrencesWindow() {
        ArrayList<ColumnConfig> config = new ArrayList<ColumnConfig>();
        for (OccurencesGridFields field : OccurencesGridFields.values()) {
            config.add(Util.createColumnConfig((GridField)field, (int)150));
        }
        ColumnModel cm = new ColumnModel(config);
        this.initLoader();
        Grid grid = new Grid(this.loader.getStore(), cm);
        grid.setBorders(true);
        grid.getView().setEmptyText("No results");
        StreamPagingToolBar toolBar = new StreamPagingToolBar();
        toolBar.bind(this.loader);
        this.panelOccurrences.setBottomComponent((Component)toolBar);
        this.panelOccurrences.add((Widget)grid);
    }

    public void loadOccurences() {
        Log.trace((String)"Loading occurrences");
        this.count = 0;
        this.dataSourceManager.setExpectedOccurencePoints(Integer.valueOf(this.count));
        SpeciesDiscovery.taxonomySearchService.retrieveOccurencesFromSelection((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void pollingGetCountOfOcccurrences(int allItems) {
        this.toolbarOccurrences.add((Component)new SeparatorToolItem());
        Label labelLoading = new Label("loading 0 of " + allItems);
        labelLoading.setStyleAttribute("paddingLeft", "20px");
        labelLoading.setData("count", (Object)new Integer(0));
        this.toolbarOccurrences.add((Component)labelLoading);
        this.timerGetCountOfOccurrences = new /* Unavailable Anonymous Inner Class!! */;
        this.timerGetCountOfOccurrences.scheduleRepeating(2500);
        Log.trace((String)"run timerGetCountOfOccurrences");
    }

    private void stopTimerGetCountOfOccurrences(int delay) {
        Log.trace((String)"stop timerGetCountOfOccurrences");
        13 timer = new /* Unavailable Anonymous Inner Class!! */;
        timer.schedule(delay);
    }

    protected void onHide() {
        super.onHide();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Button createButtonSaveAsHtml() {
        ToolBar toolbar = new ToolBar();
        Button btnExportAsHtml = new Button("Export As Html");
        btnExportAsHtml.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        btnExportAsHtml.setToolTip(new ToolTipConfig("Show in Gis Viewer", "Show occurences points from selected results in a Gis Viewer Map."));
        btnExportAsHtml.setScale(Style.ButtonScale.SMALL);
        btnExportAsHtml.setIconAlign(Style.IconAlign.TOP);
        btnExportAsHtml.setArrowAlign(Style.ButtonArrowAlign.BOTTOM);
        btnExportAsHtml.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return btnExportAsHtml;
    }

    private String getCssStyles() {
        return ".button-hyperlink .x-btn-text {cursor: pointer !important;cursor: hand !important;border: none !important;/* Disable the button-style */background-color: transparent !important;background: none !important;background-image: none !important;padding: 0px !important;color: #4784C3 !important;font-size: 10px;font-family: Serif, \"Times New Roman\", Georgia,;text-decoration: underline !important;}.button-hyperlink .x-btn-tl,.button-hyperlink.x-btn-tr,.button-hyperlink .x-btn-tc,.button-hyperlink .x-btn-ml,.button-hyperlink .x-btn-mr,.button-hyperlink .x-btn-mc,.button-hyperlink .x-btn-bl,.button-hyperlink .x-btn-br,.button-hyperlink .x-btn-bc{background-image: none !important;background: none !important;}.button-hyperlink .x-btn-small .x-btn-mr, .button-hyperlink .x-btn-small .x-btn-ml,.button-hyperlink .x-btn-small .x-btn-mc,.button-hyperlink .x-btn-small .x-btn-br,.button-hyperlink .x-btn-small .x-btn-bl,.button-hyperlink .x-btn-small .x-btn-bc,.button-hyperlink .x-btn-small .x-btn-tc,.button-hyperlink .x-btn-small .x-btn-tr,.button-hyperlink .x-btn-small .x-btn-tl{background-image: none !important;background: none !important;}.button-hyperlink .x-btn-tl i,.button-hyperlink .x-btn-tr i,.button-hyperlink .x-btn-tc i,.button-hyperlink .x-btn-ml i,.button-hyperlink .x-btn-mr i,.button-hyperlink .x-btn-mc i,.button-hyperlink .x-btn-bl i,.button-hyperlink .x-btn-br i,.button-hyperlink .x-btn-bc i{font-size: 0px;}table.imagetable {font-family: verdana,arial,sans-serif;font-size:10px;border: 1px solid #e3e3e3;background-color: #f2f2f2;width: 100%;border-radius: 6px;-webkit-border-radius: 6px;-moz-border-radius: 6px;}table.imagetable .title {background:#b5cfd2;border-width: 1px;width: 30%;padding: 8px;border-style: solid;border-color: #999999;}table.imagetable td {background:#dcddc0;border-width: 1px;padding: 8px;border-style: solid;border-color: #999999;}table.imagetable th {height: 35px;font-weight: bold;font-size: 12px;}";
    }

    static /* synthetic */ Timer access$000(ViewDetailsWindow x0) {
        return x0.timerGetCountOfOccurrences;
    }

    static /* synthetic */ void access$100(ViewDetailsWindow x0, int x1) {
        x0.stopTimerGetCountOfOccurrences(x1);
    }

    static /* synthetic */ boolean access$200(ViewDetailsWindow x0) {
        return x0.isSearchByCommonName;
    }

    static /* synthetic */ SearchEvent access$300(ViewDetailsWindow x0) {
        return x0.lastSearchEvent;
    }

    static /* synthetic */ DetailsFiller access$400(ViewDetailsWindow x0) {
        return x0.detailsFiller;
    }

    static /* synthetic */ DataSourceManager access$500(ViewDetailsWindow x0) {
        return x0.dataSourceManager;
    }

    static /* synthetic */ TabItem access$600(ViewDetailsWindow x0) {
        return x0.tabItemOccrs;
    }

    static /* synthetic */ void access$700(ViewDetailsWindow x0, int x1) {
        x0.pollingGetCountOfOcccurrences(x1);
    }

    static /* synthetic */ ToolBar access$800(ViewDetailsWindow x0) {
        return x0.toolbarOccurrences;
    }

    static /* synthetic */ String access$900(ViewDetailsWindow x0) {
        return x0.getCssStyles();
    }

    static /* synthetic */ ContentPanel access$1000(ViewDetailsWindow x0) {
        return x0.panelDetails;
    }
}

