/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.SearchBorderLayoutPanel;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesSearchFormPanel;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelManager;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchCompleteEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchStartedEvent;
import org.gcube.portlets.user.speciesdiscovery.client.filterresult.ResultFilterPanelManager;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class SpeciesSearchFormPanel
extends ContentPanel {
    protected static final String EXSEARCH = "e.g. sarda sarda, solea solea";
    protected Button buttSimpleSearch;
    protected Button buttSimpleExample;
    protected SimpleComboBox<String> searchType;
    protected SimpleComboBox<String> searchTypeResults;
    protected EventBus eventBus;
    protected TextField<String> searchField;
    private boolean isActiveAdvanced = false;
    private HorizontalPanel hpAdvancedSearchLinks = new HorizontalPanel();
    private final Html htmlLabelAdvs = new Html("Advanced Option");
    private HorizontalPanel horizontalQueryPanel = new HorizontalPanel();
    public static final int NORTHHEIGHT = 150;
    private List<ToggleButton> tabItemList = new ArrayList();
    private AdvancedSearchPanelManager advSearchPanelsManager = AdvancedSearchPanelManager.getInstance();
    private final int DEFAULTLINKPANELTHEIGHT = 22;
    public TextArea textArea = new TextArea();
    private SEARCHTYPE currentSearchType = SEARCHTYPE.SIMPLE;
    private com.extjs.gxt.ui.client.widget.button.Button buttSearchBy = new com.extjs.gxt.ui.client.widget.button.Button("Text query");
    private static final String SEARCHBYQUERY = "Text query";
    private static final String SEARCHBYSIMPLE = "Simple query";
    private HorizontalPanel simpleSearchPanel = new HorizontalPanel();
    private HorizontalPanel querySeachPanel = new HorizontalPanel();
    protected Button buttQuerySearch;
    protected Button buttQueryExample;
    protected CheckBox checkValidateOccurrences = new CheckBox();

    public SpeciesSearchFormPanel(EventBus eventBus) {
        this.eventBus = eventBus;
        this.bind();
        this.horizontalQueryPanel.setStyleAttribute("margin-left", "10px");
        this.horizontalQueryPanel.setStyleAttribute("margin-top", "15px");
        this.htmlLabelAdvs.setStyleAttribute("font-size", "11px");
        this.htmlLabelAdvs.setStyleAttribute("margin-left", "10px");
        this.buttSearchBy.setStyleName("button-hyperlink");
        this.buttSearchBy.setStyleAttribute("margin-left", "5px");
        this.setLayout((Layout)new FlowLayout());
        this.setFrame(false);
        this.setHeaderVisible(false);
        this.setBorders(false);
        this.initComboSearchType();
        this.initComboSearchTypeResult();
        this.init();
        this.switchSearchType(SEARCHTYPE.SIMPLE);
        this.add((Component)this.advSearchPanelsManager.getPanel());
    }

    private void initComboSearchType() {
        this.searchType = new SimpleComboBox();
        this.searchType.add(Arrays.asList("Scientific name", "Common name"));
        this.searchType.setEditable(false);
        this.searchType.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.searchType.setSimpleValue((Object)"Scientific name");
        this.searchType.addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initComboSearchTypeResult() {
        this.searchTypeResults = new SimpleComboBox();
        this.searchTypeResults.add(Arrays.asList(SpeciesCapability.RESULTITEM.getName(), SpeciesCapability.TAXONOMYITEM.getName()));
        this.searchTypeResults.setEditable(false);
        this.searchTypeResults.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.searchTypeResults.setSimpleValue((Object)SpeciesCapability.RESULTITEM.getName());
        this.searchTypeResults.addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public SpeciesCapability getSelectedCapability() {
        return this.getCapability((String)((SimpleComboValue)this.searchTypeResults.getValue()).getValue());
    }

    private SpeciesCapability getCapability(String value) {
        if (value.compareTo(SpeciesCapability.TAXONOMYITEM.getName()) == 0) {
            return SpeciesCapability.TAXONOMYITEM;
        }
        if (value.compareTo(SpeciesCapability.RESULTITEM.getName()) == 0) {
            return SpeciesCapability.RESULTITEM;
        }
        if (value.compareTo(SpeciesCapability.NAMESMAPPING.getName()) == 0) {
            return SpeciesCapability.NAMESMAPPING;
        }
        if (value.compareTo(SpeciesCapability.SYNONYMS.getName()) == 0) {
            return SpeciesCapability.SYNONYMS;
        }
        if (value.compareTo(SpeciesCapability.UNFOLD.getName()) == 0) {
            return SpeciesCapability.UNFOLD;
        }
        return SpeciesCapability.UNKNOWN;
    }

    private SearchType getSearchType(String value) {
        if (value.compareTo("Scientific name") == 0) {
            return SearchType.BY_SCIENTIFIC_NAME;
        }
        if (value.compareTo("Common name") == 0) {
            return SearchType.BY_COMMON_NAME;
        }
        return SearchType.BY_SCIENTIFIC_NAME;
    }

    public void switchSearchType(SEARCHTYPE searchType) {
        this.currentSearchType = searchType;
        if (searchType.equals((Object)SEARCHTYPE.SIMPLE)) {
            this.querySeachPanel.setVisible(false);
            this.simpleSearchPanel.setVisible(true);
            this.buttSearchBy.setText(SEARCHBYQUERY);
            this.hpAdvancedSearchLinks.setEnabled(true);
        } else if (searchType.equals((Object)SEARCHTYPE.FULLTEXT)) {
            this.simpleSearchPanel.setVisible(false);
            this.querySeachPanel.setVisible(true);
            this.buttSearchBy.setText(SEARCHBYSIMPLE);
            this.hpAdvancedSearchLinks.setEnabled(false);
            this.activeAdvancedSearch(false);
        }
    }

    protected void init() {
        this.horizontalQueryPanel.setBorders(false);
        this.horizontalQueryPanel.setSize(1150, 33);
        this.searchTypeResults.setStyleAttribute("margin-right", "10px");
        this.initSimpleSearchPanel();
        this.initQuerySearchPanel();
        this.createAdvancedSeachLinks();
        this.horizontalQueryPanel.add((Widget)this.simpleSearchPanel);
        this.horizontalQueryPanel.add((Widget)this.querySeachPanel);
        this.buttSearchBy.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.horizontalQueryPanel.add((Widget)this.buttSearchBy);
        this.add((Component)this.horizontalQueryPanel);
        this.add((Component)this.hpAdvancedSearchLinks);
    }

    private void initQuerySearchPanel() {
        this.querySeachPanel.setSpacing(5);
        this.buttQuerySearch = new Button("Search");
        this.buttQuerySearch.setStyleName("wizardButton");
        this.buttQuerySearch.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.buttQueryExample = new Button("Example", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.buttQueryExample.setStyleName("wizardButton");
        this.textArea.setSize(450, 37);
        this.textArea.setEmptyText("Write a query");
        this.textArea.setStyleAttribute("margin-right", "5px");
        this.querySeachPanel.add((Widget)this.textArea);
        com.extjs.gxt.ui.client.widget.button.Button buttQueryInfo = new com.extjs.gxt.ui.client.widget.button.Button();
        buttQueryInfo.setStyleAttribute("margin-right", "15px");
        buttQueryInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getHelpIcon()));
        buttQueryInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.querySeachPanel.add((Widget)buttQueryInfo);
        this.querySeachPanel.add((Widget)this.buttQuerySearch);
        this.querySeachPanel.add((Widget)this.buttQueryExample);
    }

    private void initSimpleSearchPanel() {
        this.simpleSearchPanel.setSpacing(5);
        this.simpleSearchPanel.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        VerticalPanel vtPanel = new VerticalPanel();
        HorizontalPanel hpPanel = new HorizontalPanel();
        hpPanel.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        Text textSearch = new Text("Search:");
        textSearch.setStyleAttribute("margin-left", "5px");
        textSearch.setStyleAttribute("margin-right", "5px");
        hpPanel.add((Widget)textSearch);
        hpPanel.add((Widget)this.searchTypeResults);
        Text textBy = new Text("By:");
        textBy.setStyleAttribute("margin-left", "5px");
        textBy.setStyleAttribute("margin-right", "5px");
        hpPanel.add((Widget)textBy);
        hpPanel.add((Widget)this.searchType);
        Text textTerm = new Text("Term:");
        textTerm.setStyleAttribute("margin-left", "10px");
        textTerm.setStyleAttribute("margin-right", "5px");
        hpPanel.add((Widget)textTerm);
        this.searchField = new TextField();
        this.searchField.setStyleAttribute("margin-left", "0px");
        this.searchField.setStyleAttribute("margin-right", "10px");
        this.searchField.setEmptyText(EXSEARCH);
        this.searchField.setWidth(300);
        this.searchField.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        hpPanel.add((Widget)this.searchField);
        this.checkValidateOccurrences.setBoxLabel("validate occurrences");
        this.checkValidateOccurrences.setValueAttribute("validate occurrences");
        this.checkValidateOccurrences.setStyleAttribute("margin-right", "10px");
        this.buttSimpleSearch = new Button("Search");
        this.buttSimpleSearch.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.buttSimpleSearch.setStyleName("wizardButton");
        hpPanel.add((Widget)this.buttSimpleSearch);
        this.buttSimpleExample = new Button("Example", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.buttSimpleExample.setStyleName("wizardButton");
        hpPanel.add((Widget)this.buttSimpleExample);
        HorizontalPanel hpPanelExpand = new HorizontalPanel();
        hpPanelExpand.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        hpPanelExpand.setStyleAttribute("margin-top", "10px");
        Text textExpand = new Text("Expand with synonyms: ");
        textExpand.setStyleAttribute("margin-left", "5px");
        textExpand.setStyleAttribute("margin-right", "5px");
        vtPanel.add((Widget)hpPanel);
        this.simpleSearchPanel.add((Widget)vtPanel);
    }

    public boolean getValueCheckValidateOcccurrences() {
        return this.checkValidateOccurrences.getValue();
    }

    public void setValueCheckValidateOcccurrences(boolean bool) {
        this.checkValidateOccurrences.setValue(Boolean.valueOf(bool));
    }

    public void setVisibleCheckValidateOcccurrences(boolean bool) {
        this.checkValidateOccurrences.setVisible(bool);
    }

    public void activeButtonSearch(boolean bool) {
        this.buttSimpleSearch.setEnabled(bool);
    }

    private void createAdvancedSeachLinks() {
        this.hpAdvancedSearchLinks.setVerticalAlign(Style.VerticalAlignment.MIDDLE);
        this.hpAdvancedSearchLinks.setStyleAttribute("marginLeft", "15px");
        this.hpAdvancedSearchLinks.setStyleAttribute("marginRight", "15px");
        this.hpAdvancedSearchLinks.setStyleAttribute("marginTop", "5px");
        this.hpAdvancedSearchLinks.setStyleAttribute("border-bottom", "thin solid #99BBE8;");
        this.hpAdvancedSearchLinks.setStyleAttribute("background-color", "#EFF5FB");
        this.hpAdvancedSearchLinks.add((Widget)this.htmlLabelAdvs);
        this.hpAdvancedSearchLinks.setHeight(22);
        for (String advPanel : this.advSearchPanelsManager.getListAdvancedSearchPanels()) {
            ToggleButton butt = new ToggleButton(advPanel);
            butt.setToggleGroup("tab");
            butt.setSize(100, -1);
            butt.setStyleAttribute("marginLeft", "20px");
            butt.setId(advPanel);
            butt.setStyleName("button-hyperlink");
            butt.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getArrowRight()));
            this.tabItemList.add(butt);
            butt.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.hpAdvancedSearchLinks.add((Widget)butt);
        }
    }

    private void activeAdvancedSearch(boolean bool) {
        if (bool) {
            SearchBorderLayoutPanel.getInstance().updateNorthSize(150);
        } else {
            SearchBorderLayoutPanel.getInstance().updateNorthSize(77);
        }
    }

    protected void search() {
        String searchTerm = (String)this.searchField.getValue();
        if (this.buttSimpleSearch.isEnabled() && searchTerm != null && searchTerm.length() != 0) {
            this.search(searchTerm, (Number)this.advSearchPanelsManager.getUpperBoundLatitudeField().getValue(), (Number)this.advSearchPanelsManager.getUpperBoundLongitudeField().getValue(), (Number)this.advSearchPanelsManager.getLowerBoundLatitudeField().getValue(), (Number)this.advSearchPanelsManager.getLowerBoundLongitudeField().getValue(), (Date)this.advSearchPanelsManager.getFromDate().getValue(), (Date)this.advSearchPanelsManager.getToDate().getValue(), this.advSearchPanelsManager.getCheckedDataSources(), ResultFilterPanelManager.getInstance().getGroupByRank(), this.advSearchPanelsManager.getCurrentSelectedCapability(), this.advSearchPanelsManager.getCheckedDataSourceForSynonyms(), this.advSearchPanelsManager.getCheckedDataSourceForUnfold());
        } else {
            Info.display((String)"No search term specified", (String)"There is not search term specified");
        }
    }

    protected void search(String searchTerm, Number upperBoundLongitude, Number upperBoundLatitude, Number lowerBoundLongitude, Number lowerBoundLatitude, Date fromDate, Date toDate, List<DataSourceModel> listDataSources, String groupRank, SpeciesCapability resultType, List<DataSourceModel> listDataSourceForSynonyms, List<DataSourceModel> listDataSourceForUnfold) {
        this.mask("Searching...");
        SearchType type = null;
        if ("Scientific name".equals(this.searchType.getSimpleValue())) {
            type = SearchType.BY_SCIENTIFIC_NAME;
        }
        if ("Common name".equals(this.searchType.getSimpleValue())) {
            type = SearchType.BY_COMMON_NAME;
        }
        SearchEvent event = new SearchEvent(type, searchTerm, upperBoundLongitude, upperBoundLatitude, lowerBoundLongitude, lowerBoundLatitude, fromDate, toDate, listDataSources, groupRank, resultType, listDataSourceForSynonyms, listDataSourceForUnfold);
        this.eventBus.fireEvent((GwtEvent)event);
    }

    protected void searchByQuery(String query) {
        if (query != null && query.length() != 0) {
            SearchEvent event = new SearchEvent(SearchType.BY_QUERY, query);
            this.eventBus.fireEvent((GwtEvent)event);
        } else {
            Info.display((String)"No query specified", (String)"There is not query specified");
        }
    }

    protected void bind() {
        this.eventBus.addHandler(SearchStartedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(SearchCompleteEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void enableSearch() {
        this.buttSimpleSearch.setEnabled(true);
    }

    protected void disableSearch() {
        this.buttSimpleSearch.setEnabled(false);
    }

    static /* synthetic */ SearchType access$000(SpeciesSearchFormPanel x0, String x1) {
        return x0.getSearchType(x1);
    }

    static /* synthetic */ SpeciesCapability access$100(SpeciesSearchFormPanel x0, String x1) {
        return x0.getCapability(x1);
    }

    static /* synthetic */ SEARCHTYPE access$200(SpeciesSearchFormPanel x0) {
        return x0.currentSearchType;
    }

    static /* synthetic */ boolean access$302(SpeciesSearchFormPanel x0, boolean x1) {
        x0.isActiveAdvanced = x1;
        return x0.isActiveAdvanced;
    }

    static /* synthetic */ AdvancedSearchPanelManager access$400(SpeciesSearchFormPanel x0) {
        return x0.advSearchPanelsManager;
    }

    static /* synthetic */ boolean access$300(SpeciesSearchFormPanel x0) {
        return x0.isActiveAdvanced;
    }

    static /* synthetic */ void access$500(SpeciesSearchFormPanel x0, boolean x1) {
        x0.activeAdvancedSearch(x1);
    }

    static /* synthetic */ List access$600(SpeciesSearchFormPanel x0) {
        return x0.tabItemList;
    }
}

