/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.advancedsearch;

import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelEnum;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelInterface;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceCapability;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class DataSourceFilter
implements AdvancedSearchPanelInterface {
    private ContentPanel dataPanel = new ContentPanel();
    private Button btnResetAllFilters = new Button("Reset Filters");
    private CheckBoxGroup checkGroup = new CheckBoxGroup();
    private CheckBoxGroup checkGroupOccurrences = new CheckBoxGroup();
    private CheckBoxGroup checkGroupClassification = new CheckBoxGroup();
    private HashMap<String, DataSourceModel> hashMapDataSourceClassification = new HashMap();
    private HashMap<String, DataSourceModel> hashMapDataSourceOccurrences = new HashMap();
    private static Comparator<DataSourceModel> COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;

    public DataSourceFilter() {
        this.initDataSourceFilter();
        this.addListners();
        this.btnResetAllFilters.setStyleName("button-hyperlink");
    }

    private void initDataSourceFilter() {
        this.dataPanel.setHeaderVisible(false);
        this.dataPanel.setBodyBorder(false);
        this.dataPanel.setLayout((Layout)new FitLayout());
        this.dataPanel.setStyleAttribute("marginLeft", "10px");
        this.dataPanel.setStyleAttribute("marginRight", "10px");
        this.dataPanel.setStyleAttribute("padding", "5px");
        VerticalPanel vp = new VerticalPanel();
        HorizontalPanel hp1 = new HorizontalPanel();
        HorizontalPanel hp2 = new HorizontalPanel();
        Anchor htmlSource = new Anchor("Occurences Sources: ", true);
        htmlSource.setStyleName("margin-occurrence-link");
        htmlSource.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Anchor htmlSource2 = new Anchor("Classification Sources: ", true);
        htmlSource2.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        htmlSource2.setStyleName("margin-occurrence-link");
        hp1.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        hp2.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        hp1.add((Widget)htmlSource);
        hp2.add((Widget)htmlSource2);
        hp1.add((Widget)this.checkGroupOccurrences);
        hp2.add((Widget)this.checkGroupClassification);
        vp.add((Widget)hp1);
        vp.add((Widget)hp2);
        this.dataPanel.add((Widget)vp);
    }

    private void addListners() {
        this.btnResetAllFilters.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void resetAdvancedFields() {
        List listChecks = this.checkGroup.getAll();
        for (Field item : listChecks) {
            CheckBox checkBox = (CheckBox)item;
            checkBox.reset();
        }
    }

    public ContentPanel getPanel() {
        return this.dataPanel;
    }

    public String getName() {
        return AdvancedSearchPanelEnum.DATASOURCE.getLabel();
    }

    public List<DataSourceModel> getCheckedGroupList() {
        ArrayList<DataSourceModel> listDS = new ArrayList<DataSourceModel>();
        List<CheckBox> values = new ArrayList();
        if (this.checkGroup.getValues().size() > 0) {
            values = this.checkGroup.getValues();
        } else {
            List listChecks = this.checkGroup.getAll();
            for (Field field : listChecks) {
                values.add((CheckBox)field);
            }
        }
        for (CheckBox checkBox : values) {
            if (!checkBox.isEnabled()) continue;
            listDS.add(new DataSourceModel(checkBox.getValueAttribute(), checkBox.getValueAttribute()));
        }
        if (listDS.size() == 0) {
            return null;
        }
        return listDS;
    }

    public void loadDataSource(List<DataSourceModel> result) {
        Collections.sort(result, COMPARATOR);
        if (result != null) {
            for (DataSourceModel dsm : result) {
                System.out.println("Data Source name " + dsm.getName());
                CheckBox check = null;
                for (DataSourceCapability dsc : dsm.getListCapabilities()) {
                    System.out.println("\tData Source capability name: " + dsc.getCapability().getName());
                    if (dsc.getCapability().getName().compareTo(SpeciesCapability.RESULTITEM.getName()) == 0) {
                        check = this.createCheckBox(dsm, SpeciesCapability.RESULTITEM.getName());
                        this.checkGroupOccurrences.add((Field)check);
                        this.hashMapDataSourceOccurrences.put(dsm.getName(), dsm);
                        System.out.println("\t\t added check " + dsm.getName() + " to checkGroupOccurences " + dsc.getCapability().getName());
                        this.checkGroup.add((Field)check);
                    }
                    if (dsc.getCapability().getName().compareTo(SpeciesCapability.TAXONOMYITEM.getName()) != 0) continue;
                    check = this.createCheckBox(dsm, SpeciesCapability.TAXONOMYITEM.getName());
                    this.checkGroupClassification.add((Field)check);
                    this.hashMapDataSourceClassification.put(dsm.getName(), dsm);
                    System.out.println("\t\t added check " + dsm.getName() + " to checkGroupClassification " + dsc.getCapability().getName());
                    this.checkGroup.add((Field)check);
                }
            }
            this.setVisibility();
        }
    }

    private void setVisibility() {
        if (this.checkGroup.getAll().size() == 0) {
            this.checkGroup.setVisible(false);
        }
    }

    public void enableCheckByCapability(SpeciesCapability capability) {
        this.setEnableAllCheck(false, this.checkGroupClassification);
        this.setEnableAllCheck(false, this.checkGroupOccurrences);
        this.setCheckByCapability(true, capability);
    }

    private void setCheckByCapability(boolean enable, SpeciesCapability capability) {
        if (capability.getName().compareTo(SpeciesCapability.TAXONOMYITEM.getName()) == 0) {
            this.setEnableAllCheck(enable, this.checkGroupClassification);
            this.setValueAllCheck(enable, this.checkGroupClassification);
        } else if (capability.getName().compareTo(SpeciesCapability.RESULTITEM.getName()) == 0) {
            this.setEnableAllCheck(enable, this.checkGroupOccurrences);
            this.setValueAllCheck(enable, this.checkGroupOccurrences);
        }
    }

    public void setValueAllCheck(boolean checkValue, CheckBoxGroup checksGroup) {
        List listChecks = checksGroup.getAll();
        for (Field item : listChecks) {
            CheckBox check = (CheckBox)item;
            check.setValue(Boolean.valueOf(checkValue));
        }
    }

    public void setEnableAllCheck(boolean checkValue, CheckBoxGroup checksGroup) {
        List listChecks = checksGroup.getAll();
        for (Field item : listChecks) {
            CheckBox check = (CheckBox)item;
            check.setEnabled(checkValue);
        }
    }

    private CheckBox createCheckBox(DataSourceModel dsm, String property) {
        CheckBox check = new CheckBox();
        check.setBoxLabel(dsm.getName());
        check.setValueAttribute(dsm.getName());
        check.setData("capability", (Object)dsm);
        check.setToolTip(new ToolTipConfig(dsm.getDescription()));
        return check;
    }

    public ArrayList<DataSourceModel> getAvailablePlugIn() {
        return null;
    }

    public HashMap<String, DataSourceModel> getHashMapDataSourceClassification() {
        return this.hashMapDataSourceClassification;
    }

    public HashMap<String, DataSourceModel> getHashMapDataSourceOccurrences() {
        return this.hashMapDataSourceOccurrences;
    }

    static /* synthetic */ HashMap access$000(DataSourceFilter x0) {
        return x0.hashMapDataSourceOccurrences;
    }

    static /* synthetic */ HashMap access$100(DataSourceFilter x0) {
        return x0.hashMapDataSourceClassification;
    }
}

