/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.Product;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.TaxonomyInterface;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.portlets.user.speciesdiscovery.server.service.ResultItemConverter;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Converter;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class ResultItemConverter
implements Converter<ResultItem, ResultRow> {
    protected Logger logger = Logger.getLogger(ResultItemConverter.class);
    protected int id = 0;
    protected ASLSession session;

    public ResultItemConverter(ASLSession session) {
        this.session = session;
    }

    public ResultRow convert(ResultItem input) throws Exception {
        ResultRow row = new ResultRow(this.id++);
        row.setServiceId(input.getId());
        List listProperties = input.getProperties();
        if (listProperties != null) {
            for (ElementProperty elementProperty : listProperties) {
                row.getProperties().add(new ItemParameter(elementProperty.getName(), elementProperty.getValue()));
            }
            row.setExistsProperties(true);
        }
        if (input.getAuthor() != null && !input.getAuthor().isEmpty()) {
            row.setAuthor(input.getAuthor());
        } else {
            row.setAuthor("not found");
        }
        if (input.getCredits() != null && !input.getCredits().isEmpty()) {
            row.setCredits(input.getCredits());
        } else {
            row.setCredits("not found");
        }
        if (input.getLsid() != null && !input.getLsid().isEmpty()) {
            row.setLsid(input.getLsid());
        } else {
            row.setLsid("not found");
        }
        if (input.getProvider() != null && !input.getProvider().isEmpty()) {
            row.setDataSourceId(input.getProvider());
            row.setDataSourceName(input.getProvider());
        } else {
            row.setDataSourceId("Provider Id not found");
            row.setDataSourceName("Provider Name not found");
        }
        if (input.getDataSet() != null) {
            DataSet dataSet = input.getDataSet();
            if (dataSet.getCitation() == null || dataSet.getCitation().isEmpty()) {
                row.setDataSetCitation("Citation Id not found");
            } else {
                row.setDataSetCitation(dataSet.getCitation());
            }
            if (dataSet.getId() == null || dataSet.getId().isEmpty()) {
                row.setDataSetId("Data Set Id not found");
            } else {
                row.setDataSetId(dataSet.getId());
            }
            if (dataSet.getName() == null || dataSet.getName().isEmpty()) {
                row.setDataSetName("Data Set Name not found");
            } else {
                row.setDataSetName(dataSet.getName());
            }
            if (input.getDataSet().getDataProvider() != null) {
                DataProvider dataProvider = dataSet.getDataProvider();
                if (dataProvider.getId() == null || dataProvider.getId().isEmpty()) {
                    row.setDataProviderId("Data Provider Id not found");
                } else {
                    row.setDataProviderId(dataProvider.getId());
                }
                if (dataProvider.getName() == null || dataProvider.getName().isEmpty()) {
                    row.setDataProviderName("Data Provider not found");
                } else {
                    row.setDataProviderName(dataProvider.getName());
                }
            }
        }
        if (input.getCommonNames() != null) {
            for (org.gcube.data.spd.model.CommonName commonName : input.getCommonNames()) {
                CommonName com = new CommonName(commonName.getName(), commonName.getLanguage(), row.getId());
                row.getCommonNames().add(com);
                row.setExistsCommonName(true);
            }
        }
        if (input.getProducts() != null) {
            for (Product product : input.getProducts()) {
                switch (1.$SwitchMap$org$gcube$data$spd$model$products$Product$ProductType[product.getType().ordinal()]) {
                    case 1: {
                        row.setOccurencesCount(product.getCount());
                        row.setOccurencesKey(product.getKey());
                    }
                }
            }
        }
        row.setMatchingTaxon(this.convertTaxon((TaxonomyInterface)input));
        row.setBaseTaxonValue(NormalizeString.lowerCaseUpFirstChar((String)this.getBaseTaxonValue("Kingdom", (TaxonomyInterface)input)));
        row.setMatchingCredits(input.getCredits());
        return row;
    }

    private String getBaseTaxonValue(String rank, TaxonomyInterface taxon) {
        while (taxon != null) {
            if (taxon.getRank() != null && taxon.getRank().equalsIgnoreCase(rank)) {
                return taxon.getRank();
            }
            taxon = taxon.getParent();
        }
        return "Unknown";
    }

    protected List<Taxon> convertTaxon(TaxonomyInterface taxon) {
        ArrayList<Taxon> listTaxon = new ArrayList<Taxon>();
        int count = 0;
        while (taxon != null) {
            Taxon tax = new Taxon(count++, taxon.getScientificName(), taxon.getCitation(), NormalizeString.lowerCaseUpFirstChar((String)taxon.getRank()));
            listTaxon.add(tax);
            taxon = taxon.getParent();
        }
        return listTaxon;
    }
}

