/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.job;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.log4j.Logger;
import org.gcube.data.spd.stubs.types.NodeStatus;
import org.gcube.data.spd.stubs.types.Status;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonomyJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.util.DateUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.JobTaxonomyModel;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyJob;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaxonomyJobUtil {
    public static final String COMPLETED = "COMPLETED";
    public static final String FAILED = "FAILED";
    public static final String RUNNING = "RUNNING";
    public static final String PENDING = "PENDING";
    protected static Logger logger = Logger.getLogger(TaxonomyJobUtil.class);

    public static JobTaxonomyModel convertJob(TaxonomyJob job, Status statusResponse, TaxonomyJobPersistence speciesJobDao) throws SQLException {
        String status = statusResponse.getStatus();
        DownloadState downloadState = null;
        long endTime = 0L;
        downloadState = TaxonomyJobUtil.getDownloadState((String)status);
        logger.trace((Object)("download state: " + downloadState));
        if (downloadState == null) {
            return null;
        }
        boolean onSaving = true;
        ArrayList<JobTaxonomyModel> listChildJob = new ArrayList<JobTaxonomyModel>();
        if (statusResponse.getSubNodes() != null) {
            for (NodeStatus nodeStatus : statusResponse.getSubNodes()) {
                DownloadState downloadStateChildren = TaxonomyJobUtil.getDownloadState((String)nodeStatus.getStatus());
                if (!downloadStateChildren.equals((Object)DownloadState.COMPLETED)) {
                    onSaving = false;
                }
                listChildJob.add(new JobTaxonomyModel(UUID.randomUUID().toString(), nodeStatus.getScientificName(), downloadStateChildren));
            }
        } else {
            onSaving = false;
        }
        boolean changeStatus = false;
        if (onSaving && !downloadState.equals((Object)DownloadState.COMPLETED) && !downloadState.equals((Object)DownloadState.FAILED)) {
            downloadState = DownloadState.SAVING;
            changeStatus = true;
        } else if (downloadState.equals((Object)DownloadState.COMPLETED) && job.getState().compareTo(DownloadState.SAVED.toString()) == 0) {
            downloadState = DownloadState.SAVED;
            changeStatus = true;
        }
        JobTaxonomyModel jobSpeciesModel = new JobTaxonomyModel(job.getId(), job.getDescriptiveName(), downloadState, null, job.getScientificName(), job.getDataSourceName(), job.getRank());
        jobSpeciesModel.setListChildJobs(listChildJob);
        boolean changeEndTime = false;
        if ((downloadState.equals((Object)DownloadState.FAILED) || downloadState.equals((Object)DownloadState.COMPLETED)) && statusResponse.getEndDate() != null && job.getEndTime() == 0L) {
            logger.trace((Object)("UPDATE end time first time only - " + downloadState));
            endTime = statusResponse.getEndDate().getTimeInMillis();
            job.setEndTime(endTime);
            changeEndTime = true;
        }
        boolean changeStartTime = false;
        long startTime = job.getStartTime();
        if (statusResponse.getStartDate() != null && startTime == 0L) {
            Date start = DateUtil.millisecondsToDate((long)statusResponse.getStartDate().getTimeInMillis());
            jobSpeciesModel.setStartTime(start);
            changeStartTime = true;
        }
        try {
            if (changeStatus || changeEndTime || changeStartTime) {
                job.setState(downloadState.toString());
                speciesJobDao.update((Object)job);
            }
        }
        catch (Exception e) {
            logger.trace((Object)"An error occurred when update dao: ", (Throwable)e);
        }
        long submitTime = job.getSubmitTime();
        Date submit = DateUtil.millisecondsToDate((long)submitTime);
        jobSpeciesModel.setSubmitTime(submit);
        endTime = job.getEndTime();
        long elapsedTime = 0L;
        if (endTime != 0L) {
            Date end = DateUtil.millisecondsToDate((long)endTime);
            jobSpeciesModel.setEndTime(end);
            elapsedTime = endTime;
        } else {
            elapsedTime = Calendar.getInstance().getTimeInMillis();
        }
        jobSpeciesModel.setElapsedTime(DateUtil.getDifference((long)submitTime, (long)elapsedTime));
        return jobSpeciesModel;
    }

    public static DownloadState getDownloadState(String status) {
        if (status != null) {
            if (status.compareToIgnoreCase("PENDING") == 0) {
                return DownloadState.PENDING;
            }
            if (status.compareToIgnoreCase("RUNNING") == 0) {
                return DownloadState.ONGOING;
            }
            if (status.compareToIgnoreCase("FAILED") == 0) {
                return DownloadState.FAILED;
            }
            if (status.compareToIgnoreCase("COMPLETED") == 0) {
                return DownloadState.COMPLETED;
            }
        }
        return null;
    }

    public static int deleteTaxonomyJobById(String jobIdentifier, TaxonomyJobPersistence taxonomyJobDao) throws SQLException {
        logger.trace((Object)("Delete taxonomy job id: " + jobIdentifier));
        try {
            int removed = taxonomyJobDao.deleteItemByIdField(jobIdentifier);
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)("An error occured deleteTaxonomyJobById  " + jobIdentifier + " exception: " + e), (Throwable)e);
            e.printStackTrace();
            return 0;
        }
    }

    public static int changeStatusTaxonomyJobById(String jobIdentifier, DownloadState state, TaxonomyJobPersistence taxonomyJobDAO) {
        logger.trace((Object)("Change status taxonomy job id: " + jobIdentifier));
        int result = 0;
        try {
            CriteriaBuilder queryBuilder = taxonomyJobDAO.getCriteriaBuilder();
            CriteriaQuery cq = queryBuilder.createQuery();
            Predicate pr1 = queryBuilder.equal((Expression)taxonomyJobDAO.rootFrom(cq).get("jobId"), (Object)jobIdentifier);
            cq.where((Expression)pr1);
            Iterator iterator = taxonomyJobDAO.executeCriteriaQuery(cq).iterator();
            if (!iterator.hasNext()) {
                return 0;
            }
            TaxonomyJob job = (TaxonomyJob)iterator.next();
            job.setState(state.toString());
            taxonomyJobDAO.update((Object)job);
        }
        catch (Exception e) {
            logger.error((Object)("An error occured in change status  jobId: " + jobIdentifier + " exception: " + e), (Throwable)e);
        }
        return result;
    }
}

